var gaearticles = {
  tags: [],
  selectedLink: null,
  tagListWrapperId: 'tagListWrapper',
  articlesWrapperId: 'articlesWrapper'
};

gaearticles.tags['AJAX'] = [
  '29e91f011545ed4736c28030069daed8a83c9968'
];
gaearticles.tags['API hooks'] = [
  '6f7583182af6697683b1e32e660efe8eee33c6ed'
];
gaearticles.tags['Authentication'] = [
  '39f2a0dd4a78dec0f86f1fa32bd66c36128ce954',
  '475e1cc13ece89dfb3e33a2b172c01fedc75aa4b'
];
gaearticles.tags['Custom domains'] = [
  '39f2a0dd4a78dec0f86f1fa32bd66c36128ce954',
  '799d581383baa030555d77a7736f889fb6c03f08'
];
gaearticles.tags['Datastore'] = [
  '05de8e4947bfafd5168af4e1c1809574316a7f5e',
  '0b373c70c008aa414dd89b796688b088363d714e',
  '233f7ad1b1fab23a96bd37d0b3659826d444497d',
  '3fd526e06fc0c9bf563d6db1612344e57b94c97e',
  '4584f5cba6bbdeafce7ae2e491ddf148b7465347',
  '4f683f420059a9b4bf7efeeb0d7ba6452249df41',
  '57e8905cbff23a7c5355c3b47900ca1e3f4934ba',
  '5a96d4f944fcf949378b3151d6563f609634d3d2',
  '5ab49918198d7f5b213fae2674d03beb69f3d68a',
  '6f7583182af6697683b1e32e660efe8eee33c6ed',
  '77564b318b63d342dccfb0ee2cd1ca12e5fa587a',
  '992bb9d29a07f0c9cb9bc4837e957e6892578e4c',
  'b9297c10a83ffbde05093e681dc5abf7df9d452a',
  'be5b022d66c8408b6ba64d4e348a9d0eec867d04',
  'cecfc81f689dee8da589df46eec11384678d1aee',
  'dd35e1ef1646376de18faf8b54ea3314ed928e97',
  'e8d48f6d69fdcfb1f582f9e9c90eda8463d277b9',
  'eba5a43a073414ae2ff46a01d806bf2e2c6a6a4b',
  'fa1677751b7e7561b1cc49b6d77b05ed9a2c483a',
  'aa7d6fb1ac292403a80b380306de22f7cda13e53',
  '83afad2194929152784842624eddd7d88f05ab92'
];
gaearticles.tags['Django'] = [
  '7f508b242272025d39aa6cad6072f65c081cd14d',
  '2232cbb5b5c441bd48bd983da5bd19a003aeace5',
  '31c3ad2ae29dfdc02e6cb875dda41631d4496f71',
  '6ff4a24392b04e77f9345c00fcc45a7abb63cb1f',
  '7a0da51cebb4ee674faec20a4256d82a065f2e4d',
  '853dbb3d749542fb741fca1ef3eb8ce80d6bd8d1',
  '96ee58635388a3283b9c4570a9367ee0b24b60a1',
  'e8d48f6d69fdcfb1f582f9e9c90eda8463d277b9'
];
gaearticles.tags['Eclipse'] = [
  'd0825510053aec2ebdccd38d34a222a937b3c739'
];
gaearticles.tags['Facebook API'] = [
  'b121881899aaf8c94f0700ab2b68e4651087b891'
];
gaearticles.tags['Geo'] = [
  '5ab49918198d7f5b213fae2674d03beb69f3d68a'
];
gaearticles.tags['Google Apps'] = [
  '39f2a0dd4a78dec0f86f1fa32bd66c36128ce954',
  '799d581383baa030555d77a7736f889fb6c03f08'
];
gaearticles.tags['Google Data APIs'] = [
  '445caff6d628529d0235c04c056e41fd86d6e0c5',
  '8bf8323e020700fad5ab590ba4a5bfbd916bb229',
  'c268deeef89958210c2e8fdae46008746526a44e',
];
gaearticles.tags['Google Desktop Gadgets'] = [
  'e97069d33c6f0a297dcc81b41f598d68043cebcb'
];
gaearticles.tags['Indexes'] = [
  '05de8e4947bfafd5168af4e1c1809574316a7f5e',
  '0b373c70c008aa414dd89b796688b088363d714e',
  '233f7ad1b1fab23a96bd37d0b3659826d444497d',
  'fa1677751b7e7561b1cc49b6d77b05ed9a2c483a',
  '83afad2194929152784842624eddd7d88f05ab92'
];
gaearticles.tags['Java runtime'] = [
  '57e8905cbff23a7c5355c3b47900ca1e3f4934ba',
  'cecfc81f689dee8da589df46eec11384678d1aee',
  '572378e7f337019618f07cb90a8d18009cea2663',
  'aa7d6fb1ac292403a80b380306de22f7cda13e53'
];
gaearticles.tags['Mapper API'] = [
  '5d610542a50ec20e4f8846ea7c9f61c3f56c1226',
];
gaearticles.tags['Memcache'] = [
  'c33609231c1eac38b54bb4236e7aa58ada86fa68',
  'dd35e1ef1646376de18faf8b54ea3314ed928e97'
];
gaearticles.tags['Logging'] = [
  '1955ab5899645f932732e94415b964aed5900ddb',
  '32ecf9ae0b3b1774d21c120a463fc3f436b5544f',
  '3743fbc4ca0d3bfe9d74bbcd8ce85d4c42bb64cf',
  '6f7583182af6697683b1e32e660efe8eee33c6ed'
];
gaearticles.tags['OpenSocial'] = [
  '9268d2f8d299cf5b8a7c0c26e07399f110a16ad3',
];
gaearticles.tags['Overview'] = [
  'eccedde0959e054d2baa4853eb6c13dd87a0e5c6'
];
gaearticles.tags['Python runtime'] = [
  '358de5ce2017c9fd3717afcc538ba19d3f879e37',
  '1955ab5899645f932732e94415b964aed5900ddb',
  '2232cbb5b5c441bd48bd983da5bd19a003aeace5',
  '29e91f011545ed4736c28030069daed8a83c9968',
  '31c3ad2ae29dfdc02e6cb875dda41631d4496f71',
  '32ecf9ae0b3b1774d21c120a463fc3f436b5544f',
  '3743fbc4ca0d3bfe9d74bbcd8ce85d4c42bb64cf',
  '3fd526e06fc0c9bf563d6db1612344e57b94c97e',
  '445caff6d628529d0235c04c056e41fd86d6e0c5',
  '4584f5cba6bbdeafce7ae2e491ddf148b7465347',
  '57e8905cbff23a7c5355c3b47900ca1e3f4934ba',
  '5a96d4f944fcf949378b3151d6563f609634d3d2',
  '5ab49918198d7f5b213fae2674d03beb69f3d68a',
  '6f7583182af6697683b1e32e660efe8eee33c6ed',
  '6ff4a24392b04e77f9345c00fcc45a7abb63cb1f',
  '7a0da51cebb4ee674faec20a4256d82a065f2e4d',
  '77564b318b63d342dccfb0ee2cd1ca12e5fa587a',
  '853dbb3d749542fb741fca1ef3eb8ce80d6bd8d1',
  '8bf8323e020700fad5ab590ba4a5bfbd916bb229',
  '9268d2f8d299cf5b8a7c0c26e07399f110a16ad3',
  '96ee58635388a3283b9c4570a9367ee0b24b60a1',
  '992bb9d29a07f0c9cb9bc4837e957e6892578e4c',
  'b121881899aaf8c94f0700ab2b68e4651087b891',
  'b9297c10a83ffbde05093e681dc5abf7df9d452a',
  'be5b022d66c8408b6ba64d4e348a9d0eec867d04',
  'c268deeef89958210c2e8fdae46008746526a44e',
  'cecfc81f689dee8da589df46eec11384678d1aee',
  'd0825510053aec2ebdccd38d34a222a937b3c739',
  'e8d48f6d69fdcfb1f582f9e9c90eda8463d277b9',
  'e97069d33c6f0a297dcc81b41f598d68043cebcb',
  'eba5a43a073414ae2ff46a01d806bf2e2c6a6a4b',
  'f6914db4d87162edb9430996362501c33f5004b4',
  '0d131a6dfb591287dc03005d84ddb2d478c50f4d',
  'aa7d6fb1ac292403a80b380306de22f7cda13e53'
];
gaearticles.tags['remote_api'] = [
  'eba5a43a073414ae2ff46a01d806bf2e2c6a6a4b',
  '0d131a6dfb591287dc03005d84ddb2d478c50f4d'
];
gaearticles.tags['Samples'] = [
  '3fd526e06fc0c9bf563d6db1612344e57b94c97e',
  '445caff6d628529d0235c04c056e41fd86d6e0c5',
  '5ab49918198d7f5b213fae2674d03beb69f3d68a',
  '8bf8323e020700fad5ab590ba4a5bfbd916bb229',
  '9268d2f8d299cf5b8a7c0c26e07399f110a16ad3',
  'b121881899aaf8c94f0700ab2b68e4651087b891',
  'c2b0d2f168dcd0e0d95ad6ae968807878fe5cfa9',
  'f6914db4d87162edb9430996362501c33f5004b4',
  '572378e7f337019618f07cb90a8d18009cea2663'
];
gaearticles.tags['Scaling'] = [
  '57e8905cbff23a7c5355c3b47900ca1e3f4934ba',
  '5a96d4f944fcf949378b3151d6563f609634d3d2',
  '992bb9d29a07f0c9cb9bc4837e957e6892578e4c',
  'c33609231c1eac38b54bb4236e7aa58ada86fa68',
  'dd35e1ef1646376de18faf8b54ea3314ed928e97'
];
gaearticles.tags['Task Queue'] = [
  '358de5ce2017c9fd3717afcc538ba19d3f879e37',
  '0d131a6dfb591287dc03005d84ddb2d478c50f4d'
];
gaearticles.tags['YouTube API'] = [
  'c268deeef89958210c2e8fdae46008746526a44e'
];
gaearticles.tags['XMPP'] = [
  'f6914db4d87162edb9430996362501c33f5004b4'
]


gaearticles.indexOf = function(arr, term) {
  if (!Array.prototype.indexOf) {
    for (var i = 0; i < arr.length; i++) {
      if (arr[i] == term) {
        return i;
      }
    }

    return -1;
  }

  return arr.indexOf(term);
}

gaearticles.selectLink = function(link) {
  if (tagLink) {
    if (gaearticles.selectedLink != null) {
      gaearticles.selectedLink.style.fontWeight = 'normal';
    }

    gaearticles.selectedLink = link;
    gaearticles.selectedLink.style.fontWeight = 'bold';
  }
};

gaearticles.showAllArticles = function(link) {
  var articlesWrapper = document.getElementById(gaearticles.articlesWrapperId);
  var articles = articlesWrapper.getElementsByTagName('li');

  for (var i = 0; i < articles.length; i++) {
    articles[i].style.display = 'block';
  }

  gaearticles.selectLink(link);
}

gaearticles.showArticlesByTag = function(tag, link) {
  return function() {
    var articlesWrapper = document.getElementById(gaearticles.articlesWrapperId);
    var articles = articlesWrapper.getElementsByTagName('li');
    var tagged = gaearticles.tags[tag];

    for (var i = 0; i < articles.length; i++) {
      var article = articles[i];
      if (gaearticles.indexOf(tagged, article.id) != -1) {
        article.style.display = 'block';
      } else {
        article.style.display = 'none';
      }
    }

    gaearticles.selectLink(link);
  }
};

gaearticles.getDocHeight = function() {
  var d = document;
  return Math.max(
      Math.max(d.body.scrollHeight, d.documentElement.scrollHeight),
      Math.max(d.body.offsetHeight, d.documentElement.offsetHeight),
      Math.max(d.body.clientHeight, d.documentElement.clientHeight)
  );
}

var tagListWrapper = document.getElementById(gaearticles.tagListWrapperId);
tagListWrapper.innerHTML = '';

var tagList = document.createElement('ul');
for (tag in gaearticles.tags) {
  var tagListItem = document.createElement('li');
  var tagLink = document.createElement('a');

  tagLink.innerHTML = tag;
  tagLink.href = 'javascript:void(0)';
  tagLink.onclick = gaearticles.showArticlesByTag(tag, tagLink);

  tagListItem.appendChild(tagLink);
  tagList.appendChild(tagListItem);
}
tagListWrapper.appendChild(tagList);

var viewAllLink = document.getElementById('viewAllLink');
gaearticles.selectLink(viewAllLink);

// Set the height of the table explicitly so footer doesn't run into
// collapsible bar when tag is selected
var archiveTable = document.getElementById('articlesArchiveTable');
if (archiveTable) {
  archiveTable.style.height = '' + gaearticles.getDocHeight() + 'px';
}
