/*
==========================================================================

Project:   gpctool - a graphical user interface and development 
           environment for the gpc generic polygon clipper library.

File:      appl.h
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

==========================================================================
*/

#include "forms.h"
#include "gpctool.h"
#include "gpc.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>


/* Constants */

#define GPCTOOL_VERSION "1.01" 

#define DASHED          0
#define SOLID           1

#define CLIP            0
#define SUBJECT         1
#define RESULT          2
#define PS              3
#define DEFAULT_XL -100.0
#define DEFAULT_YB -100.0
#define DEFAULT_XR  100.0
#define DEFAULT_YT  100.0


/* Type definitions */

typedef struct  
{
  double xl;            /* Polygon set bounding box left x   */
  double yb;            /* Polygon set bounding box bottom y */
  double xr;            /* Polygon set bounding box right x  */
  double yt;            /* Polygon set bounding box top y    */
  double ps_scale;      /* PostScript dump scale factor      */
  double ps_x_offset;   /* PostScript dump x offset          */
  double ps_y_offset;   /* PostScript dump y offset          */
  double gl_xl;         /* OpenGL left x                     */
  double gl_yb;         /* OpenGL bottom y                   */
  double gl_xr;         /* OpenGL right x                    */
  double gl_yt;         /* OpenGL top y                      */
  double extent;        /* Extent of window                  */
} layout_info;


/* Global variables */

extern gpc_op        op;
extern int           clip_type;
extern int           sketch_poly;
extern gpc_polygon   poly[3];
extern gpc_tristrip  tri;
extern FD_gpctool   *fd_gpctool;
extern FL_FORM      *version_form;
extern FL_FORM      *quit_form;
extern FL_FORM      *opengl_form;
extern layout_info   layout;
extern FL_OBJECT    *min_label_obj, *max_label_obj, *opengl_canvas;
extern char          min_label[], max_label[];


/* External functions */

extern void postscript_preamble(FILE *fp);

extern void postscript_end(FILE *fp);

extern void postscript_mark_vertices(FILE *fp, gpc_polygon *p,
            double linewidth);

extern void postscript_polygon_outline(FILE *fp, gpc_polygon *p,
            double linewidth, int solidline);

extern void postscript_tristrip_fill(FILE *fp, gpc_tristrip *t, double grey);

extern void get_layout(gpc_polygon *s, gpc_polygon *c);

extern void draw_image(void);




