/*
==========================================================================

Project:   gpctool - a graphical user interface and development 
           environment for the gpc generic polygon clipper library.

File:      callbacks.c
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

==========================================================================
*/


#include "forms.h"
#include "gpc.h"
#include "gpctool.h"
#include "appl.h"
/*
extern int mallocs;
*/
/* Callbacks */

void set_op(FL_OBJECT *ob, long data)
{
  op= (gpc_op) data;

  gpc_free_polygon(&poly[RESULT]);
  gpc_free_tristrip(&tri);

  if (clip_type & 2)
  {
    /*
    gpc_free_polygon(&poly[RESULT]);
    gpc_polygon_clip(op, &poly[SUBJECT], &poly[CLIP], &poly[RESULT]);
    gpc_free_tristrip(&tri);
    gpc_polygon_to_tristrip(&poly[RESULT], &tri);
    gpc_free_polygon(&poly[RESULT]);
    */
    gpc_free_tristrip(&tri);
    gpc_tristrip_clip(op, &poly[SUBJECT], &poly[CLIP], &tri);
    
  }
  if (clip_type & 1)
  {
    gpc_free_polygon(&poly[RESULT]);
    gpc_polygon_clip(op, &poly[SUBJECT], &poly[CLIP], &poly[RESULT]);
  }
  draw_image();

  /* Memory leak check */
  /*
  if (clip_type & 1)
    gpc_free_polygon(&poly[RESULT]);
  if (clip_type & 2)
    gpc_free_tristrip(&tri);

  gpc_free_polygon(&poly[SUBJECT]);
  gpc_free_polygon(&poly[CLIP]);
  fprintf(stderr, "\nNet mallocs= %d\n", mallocs);
  */
}


void quit_yes(FL_OBJECT *ob, long data)
{
  gpc_free_polygon(&poly[CLIP]);
  gpc_free_polygon(&poly[SUBJECT]);
  gpc_free_polygon(&poly[RESULT]);
  gpc_free_tristrip(&tri);
  fl_finish();
  exit(0);
}


void quit_no(FL_OBJECT *ob, long data)
{
  fl_hide_form(quit_form);
  fl_activate_form(fd_gpctool->gpctool);
}


void version_dismiss(FL_OBJECT *ob, long data)
{
  fl_hide_form(version_form);
  fl_activate_form(fd_gpctool->gpctool);
}

void version_request(FL_OBJECT *ob, long data)
{
  fl_deactivate_form(fd_gpctool->gpctool);
  fl_show_form(version_form, FL_PLACE_MOUSE, FL_TRANSIENT, "Info");
}


void quit_request(FL_OBJECT *ob, long data)
{
  fl_deactivate_form(fd_gpctool->gpctool);
  fl_show_form(quit_form, FL_PLACE_HOTSPOT, FL_TRANSIENT, "Confirm");
}


void reset_request(FL_OBJECT *ob, long data)
{
  gpc_free_polygon(&poly[CLIP]);
  gpc_free_polygon(&poly[SUBJECT]);
  gpc_free_polygon(&poly[RESULT]);
  gpc_free_tristrip(&tri);
  draw_image();
}


void sketch_polygon(FL_OBJECT *ob, long data)
{
  sketch_poly= (int) data;
  fl_deactivate_form(fd_gpctool->gpctool);
  fl_activate_form(opengl_form);
  /* fill-in code for callback */
}


void load_polygon(FL_OBJECT *ob, long data)
{
  FILE *fp;

  fl_set_fselector_placement(FL_PLACE_MOUSE);
  fl_set_fselector_fontsize(FL_NORMAL_SIZE);
  if (data == 0)
  {
    fl_set_fselector_title("Load clip polygon");
    fp= fopen(fl_show_fselector
             ("Load clip polygon:", "polygons",
              "*.gpf", "clip.gpf"), "r");
  }
  else
  {
    fl_set_fselector_title("Load subject polygon");
    fp= fopen(fl_show_fselector
             ("Load subject polygon:", "polygons",
              "*.gpf", "subject.gpf"), "r");
  }

  if (fp)
  {
    gpc_free_polygon(&poly[data]);
    gpc_read_polygon(fp, FALSE, &poly[data]);
    fclose(fp);
  }
  draw_image();
}


void save_polygon(FL_OBJECT *ob, long data)
{
  FILE *fp;

  fl_set_fselector_placement(FL_PLACE_MOUSE);
  fl_set_fselector_fontsize(FL_NORMAL_SIZE);
  if (data == 0)
  {
    fl_set_fselector_title("Save clip polygon");
    fp= fopen(fl_show_fselector
             ("Save clip polygon:", "polygons",
              "*.gpf", "clip.gpf"), "w");
  }
  else 
    if (data == 1)
    {
      fl_set_fselector_title("Save subject polygon");
      fp= fopen(fl_show_fselector
               ("Save subject polygon:", "polygons",
                "*.gpf", "subject.gpf"), "w");
    }
    else
    {
      fl_set_fselector_title("Save result polygon");
      fp= fopen(fl_show_fselector
               ("Save postscript file:", "polygons",
                "*.gpf", "result.gpf"), "w");
    }

  if (fp)
  {
    gpc_write_polygon(fp, FALSE, &poly[data]);
    fclose(fp);
  }
}


void dump_psfile(FL_OBJECT *ob, long data)
{
  gpc_polygon  p_ps;
  gpc_tristrip t_ps;

  FILE *fp;

  fl_set_fselector_placement(FL_PLACE_MOUSE);
  fl_set_fselector_title("Dump postscript file");
  fl_set_fselector_fontsize(FL_NORMAL_SIZE);
  fp= fopen(fl_show_fselector
           ("Dump postscript file:", "talk", "*.ps", "result.ps"), "w");

  if (fp)
  {
    postscript_preamble(fp);

    gpc_polygon_clip(GPC_UNION, &poly[SUBJECT], &poly[CLIP], &p_ps);
    gpc_polygon_to_tristrip(&p_ps, &t_ps);
    postscript_tristrip_fill(fp, &t_ps, 0.9);
    postscript_polygon_outline(fp, &poly[SUBJECT], 0.5, SOLID);
    postscript_polygon_outline(fp, &poly[CLIP], 0.5, DASHED);
    gpc_free_polygon(&p_ps);
    gpc_free_tristrip(&t_ps);

    if ((poly[RESULT].num_contours > 0) 
     || (tri.num_strips > 0))
    {
      gpc_polygon_clip(op, &poly[SUBJECT], &poly[CLIP], &p_ps);
      gpc_polygon_to_tristrip(&p_ps, &t_ps);
      postscript_tristrip_fill(fp, &t_ps, 0.8);
      
      postscript_polygon_outline(fp, &poly[SUBJECT], 0.5, SOLID);
      postscript_polygon_outline(fp, &poly[CLIP], 0.5, DASHED);
      postscript_polygon_outline(fp, &p_ps, 1.5, SOLID);
      /*
      postscript_mark_vertices(fp, &p_ps, 1.0);
      */
      
      gpc_free_polygon(&p_ps);
      gpc_free_tristrip(&t_ps);
    }

    postscript_end(fp);
    fclose(fp);

  }
}


void set_clip_type(FL_OBJECT *ob, long data)
{
  clip_type= (int)data;

  gpc_free_polygon(&poly[RESULT]);
  gpc_free_tristrip(&tri);

  if (clip_type & 2)
  {
    /*
    gpc_free_polygon(&poly[RESULT]);
    gpc_polygon_clip(op, &poly[SUBJECT], &poly[CLIP], &poly[RESULT]);
    gpc_free_tristrip(&tri);
    gpc_polygon_to_tristrip(&poly[RESULT], &tri);
    gpc_free_polygon(&poly[RESULT]);
    */
    gpc_free_tristrip(&tri);
    gpc_tristrip_clip(op, &poly[SUBJECT], &poly[CLIP], &tri);
    
  }
  if (clip_type & 1)
  {
    gpc_free_polygon(&poly[RESULT]);
    gpc_polygon_clip(op, &poly[SUBJECT], &poly[CLIP], &poly[RESULT]);
  }
  draw_image();
}
