/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.IntegerRange;
import tim.prune.data.Unit;

public class AltitudeRange {
    private IntegerRange _range = new IntegerRange();
    private boolean _empty;
    private int _prevValue;
    private double _climb;
    private double _descent;

    public AltitudeRange() {
        this.clear();
    }

    public void clear() {
        this._range.clear();
        this._climb = 0.0;
        this._descent = 0.0;
        this._empty = true;
        this._prevValue = 0;
    }

    public void addValue(Altitude altitude) {
        if (altitude != null && altitude.isValid()) {
            int n = (int)altitude.getMetricValue();
            this._range.addValue(n);
            if (!this._empty) {
                if (n > this._prevValue) {
                    this._climb += (double)(n - this._prevValue);
                } else {
                    this._descent += (double)(this._prevValue - n);
                }
            }
            this._prevValue = n;
            this._empty = false;
        }
    }

    public void ignoreValue(Altitude altitude) {
        this._empty = true;
        this.addValue(altitude);
    }

    public boolean hasRange() {
        return this._range.getMaximum() > this._range.getMinimum();
    }

    public int getMinimum(Unit unit) {
        if (this._range.getMinimum() <= 0) {
            return this._range.getMinimum();
        }
        return (int)((double)this._range.getMinimum() * unit.getMultFactorFromStd());
    }

    public int getMaximum(Unit unit) {
        if (this._range.getMaximum() <= 0) {
            return this._range.getMaximum();
        }
        return (int)((double)this._range.getMaximum() * unit.getMultFactorFromStd());
    }

    public int getClimb(Unit unit) {
        return (int)(this._climb * unit.getMultFactorFromStd());
    }

    public int getDescent(Unit unit) {
        return (int)(this._descent * unit.getMultFactorFromStd());
    }
}

