/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class Coordinate {
    public static final int NO_CARDINAL = -1;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private static final char[] PRINTABLE_CARDINALS = new char[]{'N', 'E', 'S', 'W'};
    public static final int FORMAT_DEG_MIN_SEC = 10;
    public static final int FORMAT_DEG_MIN = 11;
    public static final int FORMAT_DEG = 12;
    public static final int FORMAT_DEG_WITHOUT_CARDINAL = 13;
    public static final int FORMAT_DEG_WHOLE_MIN = 14;
    public static final int FORMAT_DEG_MIN_SEC_WITH_SPACES = 15;
    public static final int FORMAT_CARDINAL = 16;
    public static final int FORMAT_DECIMAL_FORCE_POINT = 17;
    public static final int FORMAT_NONE = 19;
    private static final NumberFormat EIGHT_DP = NumberFormat.getNumberInstance(Locale.UK);
    private static final NumberFormat FIVE_DP;
    private boolean _valid = false;
    private boolean _cardinalGuessed = false;
    protected int _cardinal = 0;
    private int _degrees = 0;
    private int _minutes = 0;
    private int _seconds = 0;
    private int _fracs = 0;
    private int _fracDenom = 0;
    private String _originalString = null;
    private int _originalFormat = 19;
    private double _asDouble = 0.0;

    static {
        if (EIGHT_DP instanceof DecimalFormat) {
            ((DecimalFormat)EIGHT_DP).applyPattern("0.00000000");
        }
        if ((FIVE_DP = NumberFormat.getNumberInstance(Locale.UK)) instanceof DecimalFormat) {
            ((DecimalFormat)FIVE_DP).applyPattern("0.00000");
        }
    }

    public Coordinate(String string) {
        this._originalString = string;
        int n = 0;
        if (string != null) {
            string = string.trim();
            n = string.length();
        }
        if (n > 0) {
            boolean bl = true;
            this._cardinal = this.getCardinal(string.charAt(0), string.charAt(n - 1));
            if (this._cardinal == -1) {
                bl = false;
                this._cardinal = this.getDefaultCardinal();
                this._cardinalGuessed = true;
            } else if (Coordinate.isJustNumber(string)) {
                bl = false;
                this._cardinalGuessed = true;
            }
            int n2 = 0;
            boolean bl2 = false;
            long[] lArray = new long[4];
            long[] lArray2 = new long[4];
            boolean[] blArray = new boolean[5];
            try {
                int n3 = 0;
                while (n3 < n) {
                    char c = string.charAt(n3);
                    if (c >= '0' && c <= '9') {
                        if (!bl2) {
                            bl2 = true;
                            lArray2[++n2 - 1] = 1L;
                        }
                        if ((double)lArray2[n2 - 1] < 1.0E18) {
                            lArray[n2 - 1] = lArray[n2 - 1] * 10L + (long)(c - 48);
                            int n4 = n2 - 1;
                            lArray2[n4] = lArray2[n4] * 10L;
                        }
                    } else {
                        bl2 = false;
                        if (c != ',' && c != '.') {
                            blArray[n2] = true;
                        }
                    }
                    ++n3;
                }
                this._valid = n2 > 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this._valid = false;
            }
            this._degrees = (int)lArray[0];
            this._asDouble = this._degrees;
            this._originalFormat = bl ? 12 : 13;
            this._fracDenom = 10;
            if (n2 == 2) {
                if (!blArray[1]) {
                    double d = (double)lArray[1] * 60.0 / (double)lArray2[1];
                    this._minutes = (int)d;
                    double d2 = (d - (double)this._minutes) * 60.0;
                    this._seconds = (int)d2;
                    this._fracs = (int)((d2 - (double)this._seconds) * 10.0);
                    this._asDouble = (double)this._degrees + 1.0 * (double)lArray[1] / (double)lArray2[1];
                } else {
                    this._originalFormat = 11;
                    this._minutes = (int)lArray[1];
                    this._seconds = 0;
                    this._fracs = 0;
                    this._asDouble = 1.0 * (double)this._degrees + (double)this._minutes / 60.0;
                }
            } else if (n2 == 3 && !blArray[2]) {
                this._originalFormat = 11;
                this._minutes = (int)lArray[1];
                double d = (double)lArray[2] * 60.0 / (double)lArray2[2];
                this._seconds = (int)d;
                this._fracs = (int)((d - (double)this._seconds) * 10.0);
                this._asDouble = 1.0 * (double)this._degrees + (double)this._minutes / 60.0 + d / 3600.0;
            } else if (n2 == 4 || n2 == 3) {
                this._originalFormat = 10;
                this._minutes = (int)lArray[1];
                this._seconds = (int)lArray[2];
                this._fracs = (int)lArray[3];
                this._fracDenom = (int)lArray2[3];
                if (this._fracDenom < 1) {
                    this._fracDenom = 1;
                }
                this._asDouble = 1.0 * (double)this._degrees + (double)this._minutes / 60.0 + (double)this._seconds / 3600.0 + (double)this._fracs / 3600.0 / (double)this._fracDenom;
            }
            if (this._cardinal == 3 || this._cardinal == 2 || string.charAt(0) == '-') {
                this._asDouble = -this._asDouble;
            }
            this._valid = this._valid && this._degrees <= this.getMaxDegrees() && this._minutes < 60 && this._seconds < 60 && this._fracs < this._fracDenom && Math.abs(this._asDouble) <= (double)this.getMaxDegrees();
        } else {
            this._valid = false;
        }
    }

    protected int getCardinal(char c, char c2) {
        int n = this.getCardinal(c);
        if (n == -1) {
            n = this.getCardinal(c2);
        }
        return n;
    }

    public boolean getCardinalGuessed() {
        return this._cardinalGuessed;
    }

    protected abstract int getCardinal(char var1);

    protected abstract int getDefaultCardinal();

    protected abstract int getMaxDegrees();

    protected Coordinate(double d, int n, int n2) {
        this._asDouble = d;
        this._degrees = (int)Math.abs(d);
        double d2 = (Math.abs(this._asDouble) - (double)this._degrees) * 60.0;
        this._minutes = (int)d2;
        double d3 = (d2 - (double)this._minutes) * 60.0;
        this._seconds = (int)d3;
        this._fracs = (int)((d3 - (double)this._seconds) * 10.0);
        this._fracDenom = 10;
        this._cardinal = n2;
        this._originalFormat = 19;
        if (n == 19) {
            n = 13;
        }
        this._originalString = this.output(n);
        this._originalFormat = n;
        this._valid = true;
    }

    public double getDouble() {
        return this._asDouble;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean equals(Coordinate coordinate) {
        return this._asDouble == coordinate._asDouble;
    }

    public String output(int n) {
        String string = this._originalString;
        if (n != 19 && n != this._originalFormat) {
            switch (n) {
                case 10: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(PRINTABLE_CARDINALS[this._cardinal]).append(Coordinate.threeDigitString(this._degrees)).append('\u00b0').append(Coordinate.twoDigitString(this._minutes)).append('\'').append(Coordinate.twoDigitString(this._seconds)).append('.').append(Coordinate.formatFraction(this._fracs, this._fracDenom));
                    string = stringBuffer.toString();
                    break;
                }
                case 11: {
                    string = PRINTABLE_CARDINALS[this._cardinal] + Coordinate.threeDigitString(this._degrees) + "\u00b0" + FIVE_DP.format((Math.abs(this._asDouble) - (double)this._degrees) * 60.0) + "'";
                    break;
                }
                case 14: {
                    int n2 = this._degrees;
                    int n3 = (int)Math.floor((double)this._minutes + (double)this._seconds / 60.0 + (double)this._fracs / 60.0 / (double)this._fracDenom + 0.5);
                    if (n3 == 60) {
                        n3 = 0;
                        ++n2;
                    }
                    string = PRINTABLE_CARDINALS[this._cardinal] + Coordinate.threeDigitString(n2) + "\u00b0" + n3 + "'";
                    break;
                }
                case 12: 
                case 13: {
                    if (this._originalFormat == 13) break;
                    string = String.valueOf(this._asDouble < 0.0 ? "-" : "") + ((double)this._degrees + (double)this._minutes / 60.0 + (double)this._seconds / 3600.0 + (double)this._fracs / 3600.0 / (double)this._fracDenom);
                    break;
                }
                case 17: {
                    if (this._originalFormat == 13 && string.indexOf(46) >= 0) break;
                    string = EIGHT_DP.format(this._asDouble);
                    break;
                }
                case 15: {
                    string = this._degrees + " " + this._minutes + " " + this._seconds + "." + Coordinate.formatFraction(this._fracs, this._fracDenom);
                    break;
                }
                case 16: {
                    string = "" + PRINTABLE_CARDINALS[this._cardinal];
                }
            }
        }
        return string;
    }

    private static final String formatFraction(int n, int n2) {
        if (n2 <= 1 || n == 0) {
            return "" + n;
        }
        String string = "" + n2;
        int n3 = string.length() - 1;
        String string2 = String.valueOf(string) + n;
        int n4 = string2.length();
        return string2.substring(n4 - n3);
    }

    private static String twoDigitString(int n) {
        if (n <= 0) {
            return "00";
        }
        if (n < 10) {
            return "0" + n;
        }
        if (n < 100) {
            return "" + n;
        }
        return "" + n % 100;
    }

    private static String threeDigitString(int n) {
        if (n <= 0) {
            return "000";
        }
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return "" + n % 1000;
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, int n, int n2) {
        return Coordinate.interpolate(coordinate, coordinate2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, double d) {
        double d2 = coordinate.getDouble();
        double d3 = coordinate2.getDouble();
        double d4 = d2 + (d3 - d2) * d;
        Coordinate coordinate3 = coordinate.makeNew(d4, coordinate._originalFormat);
        return coordinate3;
    }

    protected abstract Coordinate makeNew(double var1, int var3);

    private static boolean isJustNumber(String string) {
        boolean bl = false;
        try {
            double d = Double.parseDouble(string);
            bl = d >= -180.0 && d <= 360.0;
        }
        catch (NumberFormatException numberFormatException) {}
        return bl;
    }

    public String toString() {
        return "Coord: " + this._cardinal + " (" + this._degrees + ") (" + this._minutes + ") (" + this._seconds + "." + Coordinate.formatFraction(this._fracs, this._fracDenom) + ") = " + this._asDouble;
    }
}

