/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.DoubleRange;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public class PointScaler {
    private Track _track = null;
    private double _latMedian = 0.0;
    private double _lonMedian = 0.0;
    private int _minAltitude = 0;
    private double _longFactor = 0.0;
    private double _altFactor = 0.0;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private double[] _altValues = null;
    private double _maxX = 0.0;
    private double _maxY = 0.0;
    private double _maxScaledAlt = 0.0;
    private double[] _latLinesDegs = null;
    private double[] _lonLinesDegs = null;
    private double[] _latLinesScaled = null;
    private double[] _lonLinesScaled = null;
    private static final double[] COORD_SEPARATIONS = new double[]{1.0, 0.5, 0.3333333333333333, 0.16666666666666666, 0.08333333333333333, 0.05, 0.03333333333333333, 0.016666666666666666};
    private static final int MAX_COORD_SEPARATION_INDEX = COORD_SEPARATIONS.length - 1;

    public PointScaler(Track track) {
        this._track = track;
    }

    public void scale() {
        DoubleRange doubleRange = new DoubleRange();
        DoubleRange doubleRange2 = new DoubleRange();
        DoubleRange doubleRange3 = new DoubleRange();
        int n = 0;
        int n2 = 0;
        DataPoint dataPoint = null;
        if (this._track != null && (n = this._track.getNumPoints()) > 0) {
            n2 = 0;
            while (n2 < n) {
                dataPoint = this._track.getPoint(n2);
                if (dataPoint != null) {
                    doubleRange.addValue(dataPoint.getLatitude().getDouble());
                    doubleRange2.addValue(dataPoint.getLongitude().getDouble());
                    doubleRange3.addValue(dataPoint.getAltitude().getValue(Altitude.Format.METRES));
                }
                ++n2;
            }
            this._latMedian = (doubleRange.getMinimum() + doubleRange.getMaximum()) / 2.0;
            this._lonMedian = (doubleRange2.getMinimum() + doubleRange2.getMaximum()) / 2.0;
            this._minAltitude = (int)doubleRange3.getMinimum();
            this._longFactor = Math.cos(this._latMedian / 180.0 * Math.PI);
            DataPoint dataPoint2 = new DataPoint(new Latitude(doubleRange.getMinimum(), 12), new Longitude(this._lonMedian, 12), null);
            DataPoint dataPoint3 = new DataPoint(new Latitude(doubleRange.getMaximum(), 12), new Longitude(this._lonMedian, 12), null);
            double d = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3), UnitSetLibrary.UNITS_METRES);
            this._altFactor = 1.0 / d;
            if (this._xValues == null || this._xValues.length != n) {
                this._xValues = new double[n];
                this._yValues = new double[n];
                this._altValues = new double[n];
            }
            n2 = 0;
            while (n2 < n) {
                dataPoint = this._track.getPoint(n2);
                if (dataPoint != null) {
                    this._xValues[n2] = this.getScaledLongitude(dataPoint.getLongitude().getDouble());
                    this._yValues[n2] = this.getScaledLatitude(dataPoint.getLatitude().getDouble());
                    this._altValues[n2] = this.getScaledAltitude(dataPoint.getAltitude());
                    if (this._altValues[n2] > this._maxScaledAlt) {
                        this._maxScaledAlt = this._altValues[n2];
                    }
                }
                ++n2;
            }
            this._maxX = this.getScaledLongitude(doubleRange2.getMaximum());
            this._maxY = this.getScaledLatitude(doubleRange.getMaximum());
        }
    }

    public double getMaximumHoriz() {
        return this._maxX;
    }

    public double getMaximumVert() {
        return this._maxY;
    }

    public double getMaxScaledAlt() {
        return this._maxScaledAlt;
    }

    public double getHorizValue(int n) {
        return this._xValues[n];
    }

    public double getVertValue(int n) {
        return this._yValues[n];
    }

    public double getAltValue(int n) {
        return this._altValues[n];
    }

    private double getScaledLatitude(double d) {
        return d - this._latMedian;
    }

    private double getScaledLongitude(double d) {
        return (d - this._lonMedian) * this._longFactor;
    }

    private double getScaledAltitude(Altitude altitude) {
        if (altitude == null) {
            return -1.0;
        }
        return (double)(altitude.getValue(Altitude.Format.METRES) - this._minAltitude) * this._altFactor;
    }

    private double getUnscaledLatitude(double d) {
        return d + this._latMedian;
    }

    private double getUnscaledLongitude(double d) {
        return d / this._longFactor + this._lonMedian;
    }

    public void calculateLatLongLines() {
        double d;
        double d2 = this.getMaximumHoriz() > this.getMaximumVert() ? this.getMaximumHoriz() : this.getMaximumVert();
        double d3 = this.getUnscaledLongitude(-d2);
        double d4 = this.getUnscaledLongitude(d2);
        double d5 = this.getUnscaledLatitude(-d2);
        double d6 = this.getUnscaledLatitude(d2);
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        do {
            d = COORD_SEPARATIONS[++n];
            n2 = PointScaler.getNumLinesBetween(d5, d6, d);
        } while (((n3 = PointScaler.getNumLinesBetween(d3, d4, d)) <= 1 || n2 <= 1) && n < MAX_COORD_SEPARATION_INDEX);
        this._latLinesDegs = PointScaler.getLines(d5, d6, d, n2);
        this._lonLinesDegs = PointScaler.getLines(d3, d4, d, n3);
        this._latLinesScaled = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            this._latLinesScaled[n4] = this.getScaledLatitude(this._latLinesDegs[n4]);
            ++n4;
        }
        this._lonLinesScaled = new double[n3];
        n4 = 0;
        while (n4 < n3) {
            this._lonLinesScaled[n4] = this.getScaledLongitude(this._lonLinesDegs[n4]);
            ++n4;
        }
    }

    private static int getNumLinesBetween(double d, double d2, double d3) {
        double d4 = (int)d;
        if (d < 0.0) {
            d4 -= 1.0;
        }
        int n = 0;
        while (d4 < d2) {
            if (d4 >= d) {
                ++n;
            }
            d4 += d3;
        }
        return n;
    }

    private static double[] getLines(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        double d4 = (int)d;
        if (d < 0.0) {
            d4 -= 1.0;
        }
        int n2 = 0;
        while (d4 < d2) {
            if (d4 >= d) {
                dArray[n2] = d4;
                ++n2;
            }
            d4 += d3;
        }
        return dArray;
    }

    public double[] getLatitudeLines() {
        return this._latLinesDegs;
    }

    public double[] getLongitudeLines() {
        return this._lonLinesDegs;
    }

    public double[] getScaledLatitudeLines() {
        return this._latLinesScaled;
    }

    public double[] getScaledLongitudeLines() {
        return this._lonLinesScaled;
    }
}

