/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;

public class Selection {
    private Track _track = null;
    private int _currentPoint = -1;
    private boolean _valid = false;
    private int _prevNumPoints = 0;
    private int _startIndex = -1;
    private int _endIndex = -1;
    private int _currentPhotoIndex = -1;
    private int _currentAudioIndex = -1;
    private AltitudeRange _altitudeRange = null;
    private long _totalSeconds = 0L;
    private long _movingSeconds = 0L;
    private double _angDistance = -1.0;
    private double _angMovingDistance = -1.0;
    private int _numSegments = 0;

    public Selection(Track track) {
        this._track = track;
    }

    public void markInvalid() {
        this._valid = false;
    }

    public int getCurrentPointIndex() {
        return this._currentPoint;
    }

    public boolean hasRangeSelected() {
        return this._startIndex >= 0 && this._endIndex > this._startIndex;
    }

    private void recalculate() {
        this._numSegments = 0;
        int n = this._track.getNumPoints();
        if (n != this._prevNumPoints) {
            this._prevNumPoints = n;
            this.check();
        }
        if (n > 0 && this.hasRangeSelected()) {
            this._altitudeRange = new AltitudeRange();
            Altitude altitude = null;
            Timestamp timestamp = null;
            Timestamp timestamp2 = null;
            Timestamp timestamp3 = null;
            Timestamp timestamp4 = null;
            DataPoint dataPoint = null;
            DataPoint dataPoint2 = null;
            this._angDistance = 0.0;
            this._angMovingDistance = 0.0;
            this._totalSeconds = 0L;
            this._movingSeconds = 0L;
            int n2 = this._startIndex;
            while (n2 <= this._endIndex) {
                dataPoint2 = this._track.getPoint(n2);
                altitude = dataPoint2.getAltitude();
                if (!dataPoint2.isWaypoint() && altitude.isValid()) {
                    this._altitudeRange.addValue(altitude);
                }
                if ((timestamp = dataPoint2.getTimestamp()).isValid()) {
                    if (timestamp2 == null || timestamp2.isAfter(timestamp)) {
                        timestamp2 = timestamp;
                    }
                    if (timestamp3 == null || timestamp.isAfter(timestamp3)) {
                        timestamp3 = timestamp;
                    }
                    if (!dataPoint2.getSegmentStart() && timestamp4 != null && timestamp.isAfter(timestamp4)) {
                        this._movingSeconds += timestamp.getSecondsSince(timestamp4);
                    }
                    timestamp4 = timestamp;
                }
                if (!dataPoint2.isWaypoint()) {
                    if (dataPoint != null) {
                        double d = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
                        this._angDistance += d;
                        if (dataPoint2.getSegmentStart()) {
                            ++this._numSegments;
                        } else {
                            this._angMovingDistance += d;
                        }
                    }
                    dataPoint = dataPoint2;
                    if (this._numSegments == 0) {
                        this._numSegments = 1;
                    }
                }
                ++n2;
            }
            if (timestamp3 != null) {
                this._totalSeconds = timestamp3.getSecondsSince(timestamp2);
            }
        }
        this._valid = true;
    }

    public int getStart() {
        if (!this._valid) {
            this.recalculate();
        }
        return this._startIndex;
    }

    public int getEnd() {
        if (!this._valid) {
            this.recalculate();
        }
        return this._endIndex;
    }

    public AltitudeRange getAltitudeRange() {
        if (!this._valid) {
            this.recalculate();
        }
        return this._altitudeRange;
    }

    public long getNumSeconds() {
        if (!this._valid) {
            this.recalculate();
        }
        return this._totalSeconds;
    }

    public long getMovingSeconds() {
        if (!this._valid) {
            this.recalculate();
        }
        return this._movingSeconds;
    }

    public double getDistance() {
        return Distance.convertRadiansToDistance(this._angDistance);
    }

    public double getMovingDistance() {
        return Distance.convertRadiansToDistance(this._angMovingDistance);
    }

    public int getNumSegments() {
        return this._numSegments;
    }

    public void clearAll() {
        this._currentPoint = -1;
        this.selectRange(-1, -1);
        this._currentPhotoIndex = -1;
        this._currentAudioIndex = -1;
        this.check();
    }

    public void selectRange(int n, int n2) {
        this._startIndex = n;
        this._endIndex = n2;
        this.markInvalid();
        this.check();
    }

    public void selectRangeStart() {
        this.selectRangeStart(this._currentPoint);
    }

    private void selectRangeStart(int n) {
        if (n < 0) {
            this._endIndex = -1;
            this._startIndex = -1;
        } else {
            this._startIndex = n;
            if (this._endIndex <= this._startIndex) {
                this._endIndex = this._track.getNumPoints() - 1;
            }
        }
        this.markInvalid();
        UpdateMessageBroker.informSubscribers();
    }

    public void selectRangeEnd() {
        this.selectRangeEnd(this._currentPoint);
    }

    public void selectRangeEnd(int n) {
        if (n < 0) {
            this._endIndex = -1;
            this._startIndex = -1;
        } else {
            this._endIndex = n;
            if (this._startIndex > this._endIndex || this._startIndex < 0) {
                this._startIndex = 0;
            }
        }
        this.markInvalid();
        UpdateMessageBroker.informSubscribers();
    }

    public void modifyRangeDeleted() {
        if (this._currentPoint > this._endIndex) {
            this._currentPoint -= this._endIndex - this._startIndex;
        } else if (this._currentPoint > this._startIndex) {
            this._currentPoint = this._startIndex;
        }
        this._endIndex = -1;
        this._startIndex = -1;
        this.check();
    }

    public void modifyPointDeleted() {
        if (this.hasRangeSelected() && this._currentPoint <= this._endIndex) {
            --this._endIndex;
            if (this._currentPoint < this._startIndex) {
                --this._startIndex;
            }
            this.markInvalid();
        }
        this.check();
    }

    public void selectPointPhotoAudio(int n, int n2, int n3) {
        this._currentPoint = n;
        this._currentPhotoIndex = n2;
        this._currentAudioIndex = n3;
        this.check();
    }

    public int getCurrentPhotoIndex() {
        return this._currentPhotoIndex;
    }

    public int getCurrentAudioIndex() {
        return this._currentAudioIndex;
    }

    private void check() {
        if (this._track != null && this._track.getNumPoints() > 0) {
            int n = this._track.getNumPoints() - 1;
            if (this._currentPoint > n) {
                this._currentPoint = n;
            }
            if (this._endIndex > n) {
                this._endIndex = n;
            }
            if (this._startIndex > n) {
                this._startIndex = n;
            }
        } else {
            this._endIndex = -1;
            this._startIndex = -1;
            this._currentPoint = -1;
        }
        UpdateMessageBroker.informSubscribers((byte)4);
    }
}

