/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.GetWikipediaXmlHandler;
import tim.prune.function.gpsies.GenericDownloaderFunction;
import tim.prune.function.gpsies.GpsiesTrack;

public class GetWikipediaFunction
extends GenericDownloaderFunction {
    private static final int MAX_RESULTS = 20;
    private static final int MAX_DISTANCE = 15;
    private static final String GEONAMES_USERNAME = "gpsprune";

    public GetWikipediaFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.getwikipedia";
    }

    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    public void run() {
        Object object;
        Serializable serializable;
        Object object2;
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double d = 0.0;
        double d2 = 0.0;
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            object2 = this._app.getViewport().getBounds();
            d = (object2[0] + object2[2]) / 2.0;
            d2 = (object2[1] + object2[3]) / 2.0;
        } else {
            d = dataPoint.getLatitude().getDouble();
            d2 = dataPoint.getLongitude().getDouble();
        }
        object2 = "";
        InputStream inputStream = null;
        String string = "http://api.geonames.org/findNearbyWikipedia?lat=" + d + "&lng=" + d2 + "&maxRows=" + 20 + "&radius=" + 15 + "&lang=" + I18nManager.getText("wikipedia.lang") + "&username=" + GEONAMES_USERNAME;
        GetWikipediaXmlHandler getWikipediaXmlHandler = new GetWikipediaXmlHandler();
        try {
            serializable = new URL(string);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = ((URL)serializable).openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)getWikipediaXmlHandler);
        }
        catch (Exception exception) {
            object2 = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = getWikipediaXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<GpsiesTrack>)serializable);
        if (((String)object2).equals("") && (serializable == null || ((ArrayList)serializable).size() == 0)) {
            object2 = I18nManager.getText("dialog.gpsies.nonefound");
        }
        this._statusLabel.setText((String)object2);
        if (!(serializable != null && ((ArrayList)serializable).size() != 0 || (object = getWikipediaXmlHandler.getErrorMessage()) == null || ((String)object).equals(""))) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object);
        }
    }

    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String[] stringArray;
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount() && (stringArray = (string = this._trackListModel.getTrack(n3).getDownloadLink()).split(",")).length == 2) {
                DataPoint dataPoint = new DataPoint(new Latitude(stringArray[0]), new Longitude(stringArray[1]), null);
                dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                this._app.createPoint(dataPoint);
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

