/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.GetWikipediaXmlHandler;
import tim.prune.function.gpsies.GenericDownloaderFunction;
import tim.prune.function.gpsies.GpsiesTrack;

public class SearchWikipediaNames
extends GenericDownloaderFunction {
    private String _searchTerm = null;
    private static final int MAX_RESULTS = 20;
    private static final String GEONAMES_USERNAME = "gpsprune";

    public SearchWikipediaNames(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.searchwikipedianames";
    }

    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return null;
    }

    public void begin() {
        Object object = JOptionPane.showInputDialog(this._app.getFrame(), I18nManager.getText("dialog.searchwikipedianames.search"), I18nManager.getText(this.getNameKey()), 3, null, null, "");
        if (object != null) {
            this._searchTerm = object.toString();
            if (!this._searchTerm.equals("")) {
                super.begin();
            }
        }
    }

    public void run() {
        Serializable serializable;
        String string;
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        String string2 = "";
        InputStream inputStream = null;
        String string3 = I18nManager.getText("wikipedia.lang");
        string3 = string3.equals("de") || string3.equals("als") ? "de" : "en";
        try {
            string = URLEncoder.encode(this._searchTerm, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = this._searchTerm;
        }
        String string4 = "http://api.geonames.org/wikipediaSearch?title=" + string + "&maxRows=" + 20 + "&lang=" + string3 + "&username=" + GEONAMES_USERNAME;
        GetWikipediaXmlHandler getWikipediaXmlHandler = new GetWikipediaXmlHandler();
        try {
            serializable = new URL(string4);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            inputStream = ((URL)serializable).openStream();
            sAXParser.parse(inputStream, (DefaultHandler)getWikipediaXmlHandler);
        }
        catch (Exception exception) {
            string2 = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = getWikipediaXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<GpsiesTrack>)serializable);
        if (string2.equals("") && (serializable == null || ((ArrayList)serializable).size() == 0)) {
            string2 = I18nManager.getText("dialog.gpsies.nonefound");
        }
        this._statusLabel.setText(string2);
    }

    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String[] stringArray;
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount() && (stringArray = (string = this._trackListModel.getTrack(n3).getDownloadLink()).split(",")).length == 2) {
                DataPoint dataPoint = new DataPoint(new Latitude(stringArray[0]), new Longitude(stringArray[1]), null);
                dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                this._app.createPoint(dataPoint);
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

