/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.cache;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.function.cache.RowInfo;
import tim.prune.function.cache.TileCacheModel;
import tim.prune.function.cache.TileFilter;
import tim.prune.function.cache.TileSetTableModel;
import tim.prune.gui.WholeNumberField;

public class ManageCacheFunction
extends GenericFunction
implements Runnable {
    private JDialog _dialog = null;
    private CardLayout _cards = null;
    private JPanel _cardPanel = null;
    private JProgressBar _progressBar = null;
    private File _cacheDir = null;
    private TileCacheModel _model = null;
    private JTable _setsTable = null;
    private JButton _deleteSetButton = null;
    private JLabel _tileSetLabel = null;
    private JLabel _zoomLabel = null;
    private JLabel _ageLabel = null;
    private JRadioButton _deleteAllRadio = null;
    private WholeNumberField _daysField = null;
    private static TileFilter _TILEFILTER = new TileFilter();

    public ManageCacheFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.managetilecache";
    }

    public void begin() {
        this._cacheDir = null;
        String string = Config.getConfigString("prune.diskcache");
        if (string != null && !string.equals("")) {
            this._cacheDir = new File(string);
        }
        if (this._cacheDir == null || !this._cacheDir.exists() || !this._cacheDir.isDirectory()) {
            this._app.showErrorMessage(this.getNameKey(), "error.cache.notthere");
            return;
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._cardPanel = this.makeContents();
            this._dialog.getContentPane().add(this._cardPanel);
            this._dialog.pack();
        }
        new Thread(this).start();
        this._cards.first(this._cardPanel);
        this._dialog.setVisible(true);
    }

    private JPanel makeContents() {
        JPanel jPanel = new JPanel();
        this._cards = new CardLayout();
        jPanel.setLayout(this._cards);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(new JLabel(I18nManager.getText("confirm.running")));
        this._progressBar = new JProgressBar(0, 10);
        this._progressBar.setIndeterminate(true);
        jPanel3.add(this._progressBar);
        jPanel3.add(Box.createVerticalGlue());
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageCacheFunction.this._model != null) {
                    ManageCacheFunction.this._model.cancel();
                }
                ManageCacheFunction.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "card1");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this._setsTable = new JTable();
        this._setsTable.setPreferredScrollableViewportSize(new Dimension(500, 130));
        this._setsTable.setSelectionMode(2);
        jPanel6.add((Component)new JScrollPane(this._setsTable), "Center");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5));
        jPanel5.add((Component)jPanel6, "Center");
        this._setsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                ManageCacheFunction.this._deleteSetButton.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        jPanel4 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        this._deleteSetButton = new JButton(I18nManager.getText("button.delete"));
        this._deleteSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageCacheFunction.this.showDeleteCard();
            }
        });
        jPanel7.add(this._deleteSetButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        JButton jButton2 = new JButton(I18nManager.getText("button.close"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageCacheFunction.this._dialog != null) {
                    ManageCacheFunction.this._dialog.dispose();
                }
            }
        });
        jPanel8.add(jButton2);
        jPanel4.add((Component)jPanel7, "West");
        jPanel4.add((Component)jPanel8, "East");
        jPanel5.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel5, "card2");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        JPanel jPanel10 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel10.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this._tileSetLabel = new JLabel("dummy text to be replaced");
        jPanel10.add((Component)this._tileSetLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 20;
        this._zoomLabel = new JLabel("dummy text to be replaced");
        jPanel10.add((Component)this._zoomLabel, gridBagConstraints);
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.diskcache.deleteold"));
        this._deleteAllRadio = new JRadioButton(I18nManager.getText("dialog.diskcache.deleteall"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._deleteAllRadio);
        buttonGroup.add(jRadioButton);
        this._deleteAllRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ManageCacheFunction.this.enableAgeFields();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.ipady = 0;
        jPanel10.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this._ageLabel = new JLabel(I18nManager.getText("dialog.diskcache.maximumage"));
        jPanel10.add((Component)this._ageLabel, gridBagConstraints);
        this._daysField = new WholeNumberField(2);
        this._daysField.setMinimumSize(new Dimension(20, 1));
        this._daysField.setText("30");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel10.add((Component)this._daysField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel10.add((Component)this._deleteAllRadio, gridBagConstraints);
        this._deleteAllRadio.setSelected(true);
        jPanel9.add((Component)jPanel10, "Center");
        jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton3 = new JButton(I18nManager.getText("button.delete"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageCacheFunction.this.deleteCurrentSets();
            }
        });
        jPanel4.add(jButton3);
        jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageCacheFunction.this._cards.show(ManageCacheFunction.this._cardPanel, "card2");
            }
        });
        jPanel4.add(jButton);
        jPanel9.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel9, "card3");
        return jPanel;
    }

    public void run() {
        this._model = new TileCacheModel(this._cacheDir);
        this._model.buildTileSets();
        if (this._model.isAborted()) {
            return;
        }
        if (this._model.getNumTileSets() <= 0) {
            this._app.showErrorMessage(this.getNameKey(), "error.cache.empty");
            this._dialog.dispose();
            return;
        }
        this._setsTable.setModel(new TileSetTableModel(this._model));
        this._deleteSetButton.setEnabled(false);
        this._setsTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        this._setsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this._cards.next(this._cardPanel);
    }

    private void showDeleteCard() {
        int n = 0;
        String string = null;
        RowInfo rowInfo = new RowInfo();
        int n2 = 0;
        while (n2 < this._setsTable.getRowCount()) {
            if (this._setsTable.isRowSelected(n2)) {
                if (string == null) {
                    string = this._model.getTileSet(n2).getPath();
                }
                rowInfo.addRow(this._model.getTileSet(n2).getRowInfo());
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        String string2 = n == 1 ? string : I18nManager.getText("dialog.diskcache.tileset.multiple");
        this._tileSetLabel.setText(String.valueOf(I18nManager.getText("dialog.diskcache.tileset")) + " : " + string2);
        this._zoomLabel.setText(String.valueOf(I18nManager.getText("dialog.diskcache.table.zoom")) + " : " + rowInfo.getZoomRange());
        this.enableAgeFields();
        this._cards.next(this._cardPanel);
    }

    private void enableAgeFields() {
        boolean bl = !this._deleteAllRadio.isSelected();
        this._ageLabel.setEnabled(bl);
        this._daysField.setEnabled(bl);
    }

    private void deleteCurrentSets() {
        int n = -1;
        if (!this._deleteAllRadio.isSelected()) {
            n = this._daysField.getValue();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._setsTable.getRowCount()) {
            int n4;
            File file;
            if (this._setsTable.isRowSelected(n3) && (file = new File(this._model.getCacheDir(), this._model.getTileSet(n3).getPath())).exists() && (n4 = ManageCacheFunction.deleteFilesFrom(file, n)) > 0) {
                n2 += n4;
            }
            ++n3;
        }
        if (n2 > 0) {
            JOptionPane.showMessageDialog(this._dialog, String.valueOf(I18nManager.getText("dialog.diskcache.deleted1")) + " " + n2 + " " + I18nManager.getText("dialog.diskcache.deleted2"), I18nManager.getText(this.getNameKey()), 1);
            this._cards.first(this._cardPanel);
            new Thread(this).start();
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.cache.cannotdelete");
        }
    }

    private static int deleteFilesFrom(File file, int n) {
        int n2 = 0;
        long l = System.currentTimeMillis();
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File file2 = fileArray[n4];
                if (file2.isDirectory()) {
                    n2 += ManageCacheFunction.deleteFilesFrom(file2, n);
                } else if (file2.isFile() && file2.exists() && _TILEFILTER.accept(file2)) {
                    long l2 = (l - file2.lastModified()) / 1000L / 60L / 60L / 24L;
                    if ((n < 0 || l2 > (long)n) && file2.delete()) {
                        ++n2;
                    }
                }
                ++n4;
            }
            file.delete();
        }
        return n2;
    }
}

