/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;

public class MarkPointsInRectangleFunction
extends GenericFunction {
    private double _minLat = 0.0;
    private double _maxLat = 0.0;
    private double _minLon = 0.0;
    private double _maxLon = 0.0;

    public MarkPointsInRectangleFunction(App app) {
        super(app);
    }

    public void setRectCoords(double d, double d2, double d3, double d4) {
        if (d == d3 || d2 == d4) {
            this._maxLon = 0.0;
            this._minLon = 0.0;
            this._maxLat = 0.0;
            this._minLat = 0.0;
        } else {
            if (d3 > d) {
                this._minLon = d;
                this._maxLon = d3;
            } else {
                this._minLon = d3;
                this._maxLon = d;
            }
            if (d4 > d2) {
                this._minLat = d2;
                this._maxLat = d4;
            } else {
                this._minLat = d4;
                this._maxLat = d2;
            }
        }
    }

    public void begin() {
        if (this._maxLon == this._minLon || this._maxLat == this._minLat) {
            return;
        }
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            double d = dataPoint.getLongitude().getDouble();
            double d2 = dataPoint.getLatitude().getDouble();
            boolean bl = d >= this._minLon && d <= this._maxLon && d2 >= this._minLat && d2 <= this._maxLat;
            dataPoint.setMarkedForDeletion(bl);
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        UpdateMessageBroker.informSubscribers();
        if (n2 > 0) {
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("dialog.compress.confirm1")) + " " + n2 + " " + I18nManager.getText("dialog.compress.confirm2"), I18nManager.getText(this.getNameKey()), 1);
        }
    }

    public String getNameKey() {
        return "menu.track.markrectangle";
    }
}

