/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.browser.BrowserLauncher;
import tim.prune.function.gpsies.TrackListModel;

public abstract class GenericDownloaderFunction
extends GenericFunction
implements Runnable {
    protected JDialog _dialog = null;
    protected TrackListModel _trackListModel = null;
    protected JTable _trackTable = null;
    protected boolean _cancelled = false;
    protected JLabel _statusLabel = null;
    private JTextArea _descriptionBox = null;
    private JButton _loadButton = null;
    private JButton _showButton = null;

    public GenericDownloaderFunction(App app) {
        super(app);
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    GenericDownloaderFunction.this._cancelled = true;
                }
            });
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._trackListModel.clear();
        this._loadButton.setEnabled(false);
        this._showButton.setEnabled(false);
        this._cancelled = false;
        this._descriptionBox.setText("");
        new Thread(this).start();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._statusLabel = new JLabel(I18nManager.getText("confirm.running"));
        jPanel.add((Component)this._statusLabel, "North");
        this._trackListModel = new TrackListModel(this.getColumnKey(0), this.getColumnKey(1));
        this._trackTable = new JTable(this._trackListModel);
        this._trackTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = GenericDownloaderFunction.this._trackTable.getSelectedRowCount();
                    if (n > 0) {
                        GenericDownloaderFunction.this.setDescription(GenericDownloaderFunction.this._trackListModel.getTrack(GenericDownloaderFunction.this._trackTable.getSelectedRow()).getDescription());
                        GenericDownloaderFunction.this._descriptionBox.setCaretPosition(0);
                    } else {
                        GenericDownloaderFunction.this._descriptionBox.setText("");
                    }
                    GenericDownloaderFunction.this._loadButton.setEnabled(n > 0);
                    GenericDownloaderFunction.this._showButton.setEnabled(n == 1);
                }
            }
        });
        this._trackTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        if (this._trackListModel.getColumnCount() > 1) {
            this._trackTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        }
        JScrollPane jScrollPane = new JScrollPane(this._trackTable);
        jScrollPane.setPreferredSize(new Dimension(450, 200));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.gpsies.description")) + " :");
        jPanel2.add((Component)jLabel, "North");
        this._descriptionBox = new JTextArea(5, 20);
        this._descriptionBox.setEditable(false);
        this._descriptionBox.setLineWrap(true);
        this._descriptionBox.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._descriptionBox);
        jScrollPane2.setPreferredSize(new Dimension(400, 80));
        jPanel2.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel2);
        jSplitPane.setResizeWeight(1.0);
        jPanel.add((Component)jSplitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._loadButton = new JButton(I18nManager.getText("button.load"));
        this._loadButton.setEnabled(false);
        this._loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloaderFunction.this.loadSelected();
            }
        });
        jPanel3.add(this._loadButton);
        this._showButton = new JButton(I18nManager.getText("button.showwebpage"));
        this._showButton.setEnabled(false);
        this._showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloaderFunction.this.showSelectedWebpage();
            }
        });
        jPanel3.add(this._showButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloaderFunction.this._cancelled = true;
                GenericDownloaderFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    protected abstract String getColumnKey(int var1);

    private void setDescription(String string) {
        String string2 = string;
        if (string == null || string.length() < 2) {
            string2 = I18nManager.getText("dialog.gpsies.nodescription");
        }
        this._descriptionBox.setText(string2);
    }

    protected abstract void loadSelected();

    private void showSelectedWebpage() {
        int n = this._trackTable.getSelectedRow();
        if (n >= 0 && n < this._trackListModel.getRowCount()) {
            String string = this._trackListModel.getTrack(n).getWebUrl();
            BrowserLauncher.launchBrowser(string);
        }
    }
}

