/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Unit;
import tim.prune.function.gpsies.GpsiesTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackListModel
extends AbstractTableModel {
    private ArrayList<GpsiesTrack> _trackList = null;
    private String _nameColLabel = null;
    private String _lengthColLabel = null;
    private int _numColumns = 2;
    private NumberFormat _distanceFormatter = NumberFormat.getInstance();

    public TrackListModel(String string, String string2) {
        this._nameColLabel = I18nManager.getText(string);
        if (string2 != null) {
            this._lengthColLabel = I18nManager.getText(string2);
        }
        this._numColumns = this._lengthColLabel != null ? 2 : 1;
        this._distanceFormatter.setMaximumFractionDigits(1);
    }

    @Override
    public int getColumnCount() {
        return this._numColumns;
    }

    @Override
    public int getRowCount() {
        if (this._trackList == null) {
            return 0;
        }
        return this._trackList.size();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this._nameColLabel;
        }
        return this._lengthColLabel;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        GpsiesTrack gpsiesTrack = this._trackList.get(n);
        if (n2 == 0) {
            return gpsiesTrack.getTrackName();
        }
        double d = gpsiesTrack.getLength();
        Unit unit = Config.getUnitSet().getDistanceUnit();
        double d2 = d * unit.getMultFactorFromStd();
        return String.valueOf(this._distanceFormatter.format(d2)) + " " + I18nManager.getText(unit.getShortnameKey());
    }

    public void addTracks(ArrayList<GpsiesTrack> arrayList) {
        if (this._trackList == null) {
            this._trackList = new ArrayList();
        }
        int n = this._trackList.size();
        if (arrayList != null && arrayList.size() > 0) {
            this._trackList.addAll(arrayList);
        }
        int n2 = this._trackList.size();
        if (n <= 0) {
            this.fireTableDataChanged();
        } else {
            this.fireTableRowsInserted(n, n2 - 1);
        }
    }

    public GpsiesTrack getTrack(int n) {
        return this._trackList.get(n);
    }

    public void clear() {
        this._trackList = null;
    }
}

