/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.browser.BrowserLauncher;
import tim.prune.function.gpsies.FormPoster;
import tim.prune.gui.GuiGridLayout;
import tim.prune.save.GpxExporter;

public class UploadGpsiesFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField _usernameField = null;
    private JPasswordField _passwordField = null;
    private JTextField _nameField = null;
    private JTextArea _descField = null;
    private JCheckBox _privateCheckbox = null;
    private JCheckBox[] _activityCheckboxes = null;
    private OutputStreamWriter _writer = null;
    private JButton _uploadButton = null;
    private static final String GPSIES_URL = "http://www.gpsies.com/upload.do";
    private static final String[] ACTIVITY_KEYS = new String[]{"trekking", "walking", "jogging", "biking", "motorbiking", "snowshoe", "sailing", "skating"};

    public UploadGpsiesFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.uploadgpsies";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.username")));
        this._usernameField = new JTextField(15);
        guiGridLayout.add(this._usernameField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.password")));
        this._passwordField = new JPasswordField(15);
        guiGridLayout.add(this._passwordField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.column.name")));
        this._nameField = new JTextField(15);
        guiGridLayout.add(this._nameField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.description")));
        this._descField = new JTextArea(5, 15);
        this._descField.setLineWrap(true);
        this._descField.setWrapStyleWord(true);
        guiGridLayout.add(new JScrollPane(this._descField));
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                UploadGpsiesFunction.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    UploadGpsiesFunction.this._dialog.dispose();
                }
            }
        };
        this._usernameField.addKeyListener(keyAdapter);
        this._passwordField.addKeyListener(keyAdapter);
        this._nameField.addKeyListener(keyAdapter);
        this._descField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    keyEvent.consume();
                    if (keyEvent.isShiftDown()) {
                        UploadGpsiesFunction.this._nameField.requestFocusInWindow();
                    } else {
                        UploadGpsiesFunction.this._privateCheckbox.requestFocusInWindow();
                    }
                }
            }
        });
        this._passwordField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127)) {
                    UploadGpsiesFunction.this._passwordField.setText("");
                }
            }
        });
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.keepprivate")));
        this._privateCheckbox = new JCheckBox();
        this._privateCheckbox.setSelected(true);
        guiGridLayout.add(this._privateCheckbox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder(1));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                UploadGpsiesFunction.this.enableOK();
            }
        };
        GuiGridLayout guiGridLayout2 = new GuiGridLayout(jPanel3, true);
        int n = ACTIVITY_KEYS.length;
        this._activityCheckboxes = new JCheckBox[n];
        int n2 = 0;
        while (n2 < n) {
            this._activityCheckboxes[n2] = new JCheckBox(I18nManager.getText("dialog.gpsies.activity." + ACTIVITY_KEYS[n2]));
            this._activityCheckboxes[n2].addChangeListener(changeListener);
            guiGridLayout2.add(this._activityCheckboxes[n2]);
            ++n2;
        }
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.gpsies.activities")));
        guiGridLayout.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._uploadButton = new JButton(I18nManager.getText("button.upload"));
        this._uploadButton.setEnabled(false);
        this._uploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UploadGpsiesFunction.this.startUpload();
            }
        });
        jPanel5.add(this._uploadButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UploadGpsiesFunction.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        boolean bl;
        boolean bl2 = bl = this._usernameField.getText().length() > 0 && this._nameField.getText().length() > 0;
        if (bl) {
            char[] cArray = this._passwordField.getPassword();
            bl = cArray.length > 0;
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = 48;
                ++n;
            }
            if (bl) {
                bl = false;
                n = 0;
                while (n < this._activityCheckboxes.length) {
                    bl = bl || this._activityCheckboxes[n].isSelected();
                    ++n;
                }
            }
        }
        this._uploadButton.setEnabled(bl);
    }

    private void startUpload() {
        block25: {
            BufferedReader bufferedReader = null;
            try {
                int n;
                FormPoster formPoster = new FormPoster(new URL(GPSIES_URL));
                formPoster.setParameter("device", "Prune");
                formPoster.setParameter("username", this._usernameField.getText());
                formPoster.setParameter("password", new String(this._passwordField.getPassword()));
                boolean bl = false;
                int n2 = 0;
                while (n2 < ACTIVITY_KEYS.length) {
                    if (this._activityCheckboxes[n2].isSelected()) {
                        bl = true;
                        formPoster.setParameter("trackTypes", ACTIVITY_KEYS[n2]);
                    }
                    ++n2;
                }
                if (!bl) {
                    formPoster.setParameter("trackTypes", "walking");
                }
                formPoster.setParameter("filename", this._nameField.getText());
                formPoster.setParameter("fileDescription", this._descField.getText());
                formPoster.setParameter("startpointCountry", "DE");
                formPoster.setParameter("endpointCountry", "DE");
                formPoster.setParameter("status", this._privateCheckbox.isSelected() ? "3" : "1");
                formPoster.setParameter("submit", "speichern");
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                this._writer = new OutputStreamWriter(pipedOutputStream);
                new Thread(new Runnable(){

                    public void run() {
                        block11: {
                            boolean[] blArray = new boolean[6];
                            blArray[0] = true;
                            blArray[1] = true;
                            blArray[2] = true;
                            blArray[3] = true;
                            blArray[5] = true;
                            boolean[] blArray2 = blArray;
                            try {
                                try {
                                    GpxExporter.exportData(UploadGpsiesFunction.this._writer, UploadGpsiesFunction.this._app.getTrackInfo(), UploadGpsiesFunction.this._nameField.getText(), null, blArray2, null);
                                }
                                catch (IOException iOException) {
                                    try {
                                        UploadGpsiesFunction.this._writer.close();
                                    }
                                    catch (IOException iOException2) {}
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    UploadGpsiesFunction.this._writer.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                UploadGpsiesFunction.this._writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }).start();
                formPoster.setParameter("formFile", "filename.gpx", pipedInputStream);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(formPoster.post());
                int n3 = formPoster.getResponseCode();
                bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string = bufferedReader.readLine();
                String string2 = null;
                if (n3 == 200 && string.substring(0, 2).toUpperCase().equals("OK") && (n = string.indexOf(91)) > 0 && string.endsWith("]")) {
                    string2 = string.substring(n + 1, string.length() - 1);
                }
                if (string2 != null) {
                    n = JOptionPane.showConfirmDialog(this._app.getFrame(), I18nManager.getText("dialog.gpsies.confirmopenpage"), I18nManager.getText(this.getNameKey()), 2, 3);
                    if (n == 0) {
                        BrowserLauncher.launchBrowser(string2);
                    }
                } else {
                    this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.gpsies.uploadnotok")) + ": " + string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block25;
                }
                catch (IOException iOException) {}
                break block25;
            }
            catch (IOException iOException) {
                try {
                    this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.gpsies.uploadfailed")) + ": " + iOException.getClass().getName() + " : " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block25;
                }
                catch (IOException iOException3) {}
                break block25;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        this._dialog.dispose();
    }
}

