/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.function.srtm.SrtmTile;
import tim.prune.function.srtm.TileFinder;
import tim.prune.undo.UndoLookupSrtm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupSrtmFunction
extends GenericFunction
implements Runnable {
    private JDialog _dialog = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;
    private static final long HGT_SIZE = 2884802L;
    private static final int VOID_VAL = Short.MIN_VALUE;

    public LookupSrtmFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.lookupsrtm";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), false);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._progressBar.setMinimum(0);
        this._progressBar.setMaximum(100);
        this._progressBar.setValue(20);
        this._cancelled = false;
        new Thread(this).start();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("confirm.running")), "North");
        this._progressBar = new JProgressBar();
        this._progressBar.setPreferredSize(new Dimension(250, 30));
        jPanel.add((Component)this._progressBar, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LookupSrtmFunction.this._cancelled = true;
                LookupSrtmFunction.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public void run() {
        Track track = this._app.getTrackInfo().getTrack();
        ArrayList<SrtmTile> arrayList = new ArrayList<SrtmTile>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < track.getNumPoints()) {
            if (track.getPoint(n).hasAltitude()) {
                if (track.getPoint(n).getAltitude().getValue() == 0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            n += 1;
        }
        int n2 = n = bl && !bl2 ? 1 : 0;
        if (bl2 && bl && JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.lookupsrtm.overwritezeros"), I18nManager.getText(this.getNameKey()), 0) == 0) {
            n = 1;
        }
        this._dialog.setVisible(true);
        int n3 = 0;
        while (n3 < track.getNumPoints()) {
            if (!track.getPoint(n3).hasAltitude() || n && track.getPoint(n3).getAltitude().getValue() == 0) {
                SrtmTile srtmTile = new SrtmTile(track.getPoint(n3));
                boolean bl3 = false;
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    if (arrayList.get(n4).equals(srtmTile)) {
                        bl3 = true;
                    }
                    ++n4;
                }
                if (!bl3) {
                    arrayList.add(srtmTile);
                }
            }
            ++n3;
        }
        this.lookupValues(arrayList, n != 0);
    }

    private void lookupValues(ArrayList<SrtmTile> arrayList, boolean bl) {
        Track track = this._app.getTrackInfo().getTrack();
        UndoLookupSrtm undoLookupSrtm = new UndoLookupSrtm(this._app.getTrackInfo());
        int n = 0;
        this._progressBar.setMaximum(arrayList.size());
        this._progressBar.setIndeterminate(arrayList.size() <= 1);
        this._progressBar.setValue(0);
        String string = null;
        URL[] uRLArray = TileFinder.getUrls(arrayList);
        int n2 = 0;
        while (n2 < arrayList.size() && !this._cancelled) {
            block24: {
                if (uRLArray[n2] != null) {
                    SrtmTile srtmTile = arrayList.get(n2);
                    try {
                        int n3;
                        boolean bl2;
                        this._progressBar.setValue(n2);
                        int[] nArray = new int[1442401];
                        ZipInputStream zipInputStream = new ZipInputStream(uRLArray[n2].openStream());
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        boolean bl3 = bl2 = zipEntry.getSize() == 2884802L;
                        if (bl2) {
                            n3 = 0;
                            while (n3 < 1442401) {
                                nArray[n3] = zipInputStream.read() * 256 + zipInputStream.read();
                                if (nArray[n3] >= 32768) {
                                    int n4 = n3;
                                    nArray[n4] = nArray[n4] - 65536;
                                }
                                ++n3;
                            }
                        }
                        zipInputStream.close();
                        if (!bl2) break block24;
                        n3 = 0;
                        while (n3 < track.getNumPoints()) {
                            DataPoint dataPoint = track.getPoint(n3);
                            if ((!dataPoint.hasAltitude() || bl && dataPoint.getAltitude().getValue() == 0) && new SrtmTile(dataPoint).equals(srtmTile)) {
                                double d = (dataPoint.getLongitude().getDouble() - (double)srtmTile.getLongitude()) * 1200.0;
                                double d2 = 1201.0 - (dataPoint.getLatitude().getDouble() - (double)srtmTile.getLatitude()) * 1200.0;
                                int n5 = (int)d2 * 1201 + (int)d;
                                try {
                                    int[] nArray2 = new int[]{nArray[n5], nArray[n5 + 1], nArray[n5 - 1201], nArray[n5 - 1200]};
                                    int n6 = (nArray2[0] == Short.MIN_VALUE ? 1 : 0) + (nArray2[1] == Short.MIN_VALUE ? 1 : 0) + (nArray2[2] == Short.MIN_VALUE ? 1 : 0) + (nArray2[3] == Short.MIN_VALUE ? 1 : 0);
                                    double d3 = 0.0;
                                    switch (n6) {
                                        case 0: {
                                            d3 = LookupSrtmFunction.bilinearInterpolate(nArray2, d, d2);
                                            break;
                                        }
                                        case 1: {
                                            d3 = LookupSrtmFunction.bilinearInterpolate(LookupSrtmFunction.fixVoid(nArray2), d, d2);
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            d3 = LookupSrtmFunction.averageNonVoid(nArray2);
                                            break;
                                        }
                                        default: {
                                            d3 = -32768.0;
                                        }
                                    }
                                    if (d3 != -32768.0) {
                                        dataPoint.setFieldValue(Field.ALTITUDE, "" + d3, false);
                                        ++n;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            }
                            ++n3;
                        }
                    }
                    catch (IOException iOException) {
                        string = String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage();
                    }
                }
            }
            ++n2;
        }
        this._dialog.dispose();
        if (this._cancelled) {
            return;
        }
        if (n > 0) {
            track.requestRescale();
            UpdateMessageBroker.informSubscribers((byte)1);
            this._app.completeFunction(undoLookupSrtm, String.valueOf(I18nManager.getText("confirm.lookupsrtm1")) + " " + n + " " + I18nManager.getText("confirm.lookupsrtm2"));
        } else if (string != null) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), string);
        } else if (arrayList.size() > 0) {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonefound");
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonerequired");
        }
    }

    private static double bilinearInterpolate(int[] nArray, double d, double d2) {
        double d3 = d - (double)((int)d);
        double d4 = 1.0 - (d2 - (double)((int)d2));
        double d5 = (1.0 - d3) * (1.0 - d4) * (double)nArray[0] + d3 * (1.0 - d4) * (double)nArray[1] + (1.0 - d3) * d4 * (double)nArray[2] + d3 * d4 * (double)nArray[3];
        return d5;
    }

    private static int[] fixVoid(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n] == Short.MIN_VALUE ? (int)Math.round(LookupSrtmFunction.averageNonVoid(nArray)) : nArray[n];
            ++n;
        }
        return nArray2;
    }

    private static final double averageNonVoid(int[] nArray) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != Short.MIN_VALUE) {
                d += (double)nArray[n2];
                ++n;
            }
            ++n2;
        }
        if (n < 1) {
            return -32768.0;
        }
        return d / (double)n;
    }
}

