/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import tim.prune.function.srtm.SrtmTile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileFinder {
    private static final String URL_PREFIX = "http://dds.cr.usgs.gov/srtm/version2_1/SRTM3/";
    private static final String[] CONTINENTS = new String[]{"", "Eurasia", "North_America", "Australia", "Islands", "South_America", "Africa"};

    public static URL[] getUrls(ArrayList<SrtmTile> arrayList) {
        if (arrayList == null || arrayList.size() < 1) {
            return null;
        }
        URL[] uRLArray = new URL[arrayList.size()];
        byte[] byArray = TileFinder.readDatFile();
        int n = 0;
        while (n < arrayList.size()) {
            SrtmTile srtmTile = arrayList.get(n);
            int n2 = (srtmTile.getLatitude() + 59) * 360 + (srtmTile.getLongitude() + 180);
            try {
                byte by = byArray[n2];
                if (by > 0) {
                    try {
                        uRLArray[n] = new URL(URL_PREFIX + CONTINENTS[by] + "/" + srtmTile.getTileName());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n;
        }
        return uRLArray;
    }

    private static byte[] readDatFile() {
        try {
            InputStream inputStream = TileFinder.class.getResourceAsStream("/tim/prune/function/srtm/srtmtiles.dat");
            if (inputStream != null) {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                inputStream.close();
                return byArray;
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception trying to read srtmtiles.dat : " + iOException.getMessage());
        }
        return null;
    }
}

