/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AltitudeRange;
import tim.prune.data.AudioClip;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Selection;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.TrackInfo;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.AudioListener;
import tim.prune.gui.DisplayUtils;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.PhotoThumbnail;

public class DetailsDisplay
extends GenericDisplay {
    private JLabel _indexLabel = null;
    private JLabel _latLabel = null;
    private JLabel _longLabel = null;
    private JLabel _altLabel = null;
    private JLabel _timeLabel = null;
    private JLabel _speedLabel = null;
    private JLabel _vSpeedLabel = null;
    private JLabel _nameLabel = null;
    private JLabel _typeLabel = null;
    private JLabel _rangeLabel = null;
    private JLabel _distanceLabel = null;
    private JLabel _durationLabel = null;
    private JLabel _altRangeLabel = null;
    private JLabel _updownLabel = null;
    private JLabel _aveSpeedLabel = null;
    private JPanel _photoDetailsPanel = null;
    private JLabel _photoLabel = null;
    private JLabel _photoPathLabel = null;
    private PhotoThumbnail _photoThumbnail = null;
    private JLabel _photoTimestampLabel = null;
    private JLabel _photoConnectedLabel = null;
    private JLabel _photoBearingLabel = null;
    private JPanel _rotationButtons = null;
    private JPanel _audioDetailsPanel = null;
    private JLabel _audioLabel = null;
    private JLabel _audioPathLabel = null;
    private JLabel _audioConnectedLabel = null;
    private JLabel _audioTimestampLabel = null;
    private JLabel _audioLengthLabel = null;
    private JProgressBar _audioProgress = null;
    private JPanel _playAudioPanel = null;
    private JComboBox _coordFormatDropdown = null;
    private JComboBox _distUnitsDropdown = null;
    private NumberFormat _distanceFormatter = NumberFormat.getInstance();
    private static final String LABEL_POINT_SELECTED = String.valueOf(I18nManager.getText("details.index.selected")) + ": ";
    private static final String LABEL_POINT_LATITUDE = String.valueOf(I18nManager.getText("fieldname.latitude")) + ": ";
    private static final String LABEL_POINT_LONGITUDE = String.valueOf(I18nManager.getText("fieldname.longitude")) + ": ";
    private static final String LABEL_POINT_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_POINT_TIMESTAMP = String.valueOf(I18nManager.getText("fieldname.timestamp")) + ": ";
    private static final String LABEL_POINT_WAYPOINTNAME = String.valueOf(I18nManager.getText("fieldname.waypointname")) + ": ";
    private static final String LABEL_POINT_WAYPOINTTYPE = String.valueOf(I18nManager.getText("fieldname.waypointtype")) + ": ";
    private static final String LABEL_POINT_SPEED = String.valueOf(I18nManager.getText("fieldname.speed")) + ": ";
    private static final String LABEL_POINT_VERTSPEED = String.valueOf(I18nManager.getText("fieldname.verticalspeed")) + ": ";
    private static final String LABEL_RANGE_SELECTED = String.valueOf(I18nManager.getText("details.range.selected")) + ": ";
    private static final String LABEL_RANGE_DURATION = String.valueOf(I18nManager.getText("fieldname.duration")) + ": ";
    private static final String LABEL_RANGE_DISTANCE = String.valueOf(I18nManager.getText("fieldname.distance")) + ": ";
    private static final String LABEL_RANGE_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_RANGE_CLIMB = String.valueOf(I18nManager.getText("details.range.climb")) + ": ";
    private static final String LABEL_RANGE_DESCENT = ", " + I18nManager.getText("details.range.descent") + ": ";
    private static final String LABEL_AUDIO_FILE = String.valueOf(I18nManager.getText("details.audio.file")) + ": ";
    private static final String LABEL_FULL_PATH = String.valueOf(I18nManager.getText("details.media.fullpath")) + ": ";

    public DetailsDisplay(TrackInfo trackInfo) {
        super(trackInfo);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        Font font = new JLabel().getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        JPanel jPanel2 = DetailsDisplay.makeDetailsPanel("details.pointdetails", font);
        this._indexLabel = new JLabel(I18nManager.getText("details.nopointselection"));
        jPanel2.add(this._indexLabel);
        this._latLabel = new JLabel("");
        jPanel2.add(this._latLabel);
        this._longLabel = new JLabel("");
        jPanel2.add(this._longLabel);
        this._altLabel = new JLabel("");
        jPanel2.add(this._altLabel);
        this._timeLabel = new JLabel("");
        this._timeLabel.setMinimumSize(new Dimension(120, 10));
        jPanel2.add(this._timeLabel);
        this._speedLabel = new JLabel("");
        jPanel2.add(this._speedLabel);
        this._vSpeedLabel = new JLabel("");
        jPanel2.add(this._vSpeedLabel);
        this._nameLabel = new JLabel("");
        jPanel2.add(this._nameLabel);
        this._typeLabel = new JLabel("");
        jPanel2.add(this._typeLabel);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = DetailsDisplay.makeDetailsPanel("details.rangedetails", font);
        this._rangeLabel = new JLabel(I18nManager.getText("details.norangeselection"));
        jPanel3.add(this._rangeLabel);
        this._distanceLabel = new JLabel("");
        jPanel3.add(this._distanceLabel);
        this._durationLabel = new JLabel("");
        jPanel3.add(this._durationLabel);
        this._aveSpeedLabel = new JLabel("");
        jPanel3.add(this._aveSpeedLabel);
        this._altRangeLabel = new JLabel("");
        jPanel3.add(this._altRangeLabel);
        this._updownLabel = new JLabel("");
        jPanel3.add(this._updownLabel);
        jPanel3.setAlignmentX(0.0f);
        this._photoDetailsPanel = DetailsDisplay.makeDetailsPanel("details.photodetails", font);
        this._photoLabel = new JLabel(I18nManager.getText("details.nophoto"));
        this._photoDetailsPanel.add(this._photoLabel);
        this._photoPathLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoPathLabel);
        this._photoTimestampLabel = new JLabel("");
        this._photoTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._photoDetailsPanel.add(this._photoTimestampLabel);
        this._photoConnectedLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoConnectedLabel);
        this._photoBearingLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoBearingLabel);
        this._photoThumbnail = new PhotoThumbnail();
        this._photoThumbnail.setVisible(false);
        this._photoThumbnail.setPreferredSize(new Dimension(100, 100));
        this._photoDetailsPanel.add(this._photoThumbnail);
        JButton jButton = DetailsDisplay.makeRotateButton("rotate_left_icon.png", FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT);
        JButton jButton2 = DetailsDisplay.makeRotateButton("rotate_right_icon.png", FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT);
        JButton jButton3 = DetailsDisplay.makeRotateButton("show_details_icon.gif", FunctionLibrary.FUNCTION_PHOTO_POPUP);
        this._rotationButtons = new JPanel();
        this._rotationButtons.add(jButton);
        this._rotationButtons.add(jButton2);
        this._rotationButtons.add(Box.createHorizontalStrut(10));
        this._rotationButtons.add(jButton3);
        this._rotationButtons.setAlignmentX(0.0f);
        this._rotationButtons.setVisible(false);
        this._photoDetailsPanel.add(this._rotationButtons);
        this._photoDetailsPanel.setVisible(false);
        this._audioDetailsPanel = DetailsDisplay.makeDetailsPanel("details.audiodetails", font);
        this._audioLabel = new JLabel(I18nManager.getText("details.noaudio"));
        this._audioDetailsPanel.add(this._audioLabel);
        this._audioPathLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioPathLabel);
        this._audioTimestampLabel = new JLabel("");
        this._audioTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._audioDetailsPanel.add(this._audioTimestampLabel);
        this._audioLengthLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioLengthLabel);
        this._audioConnectedLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioConnectedLabel);
        this._audioProgress = new JProgressBar(0, 100);
        this._audioProgress.setString(I18nManager.getText("details.audio.playing"));
        this._audioProgress.setStringPainted(true);
        this._audioProgress.setVisible(false);
        this._audioDetailsPanel.add(this._audioProgress);
        this._playAudioPanel = new JPanel();
        this._playAudioPanel.setLayout(new FlowLayout(2));
        JButton jButton4 = DetailsDisplay.makeRotateButton("play_audio.gif", FunctionLibrary.FUNCTION_PLAY_AUDIO);
        jButton4.addActionListener(new AudioListener(this._audioProgress));
        this._playAudioPanel.add(jButton4);
        JButton jButton5 = DetailsDisplay.makeRotateButton("stop_audio.gif", FunctionLibrary.FUNCTION_STOP_AUDIO);
        this._playAudioPanel.add(jButton5);
        this._playAudioPanel.setAlignmentX(0.0f);
        this._playAudioPanel.setVisible(false);
        this._audioDetailsPanel.add(this._playAudioPanel);
        this._audioDetailsPanel.setVisible(false);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._photoDetailsPanel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._audioDetailsPanel);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("details.coordformat")) + ": ");
        jLabel.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        String[] stringArray = new String[]{I18nManager.getText("units.original"), I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailsDisplay.this.dataUpdated((byte)32);
            }
        });
        jPanel4.add(this._coordFormatDropdown);
        this._coordFormatDropdown.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.distanceunits")) + ": ");
        jLabel2.setAlignmentX(0.0f);
        jPanel4.add(jLabel2);
        this._distUnitsDropdown = new JComboBox();
        UnitSet unitSet = Config.getUnitSet();
        int n = 0;
        while (n < UnitSetLibrary.getNumUnitSets()) {
            this._distUnitsDropdown.addItem(I18nManager.getText(UnitSetLibrary.getUnitSet(n).getDistanceUnit().getNameKey()));
            if (UnitSetLibrary.getUnitSet(n) == unitSet) {
                this._distUnitsDropdown.setSelectedIndex(n);
            }
            ++n;
        }
        this._distUnitsDropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.selectUnitSet(DetailsDisplay.this._distUnitsDropdown.getSelectedIndex());
                UpdateMessageBroker.informSubscribers((byte)32);
            }
        });
        jPanel4.add(this._distUnitsDropdown);
        this._distUnitsDropdown.setAlignmentX(0.0f);
        this.add((Component)jPanel4, "South");
    }

    public void dataUpdated(byte by) {
        String string;
        String string2;
        Object object;
        Object object2;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        Selection selection = this._trackInfo.getSelection();
        if ((by | 1) > 0) {
            selection.markInvalid();
        }
        int n = selection.getCurrentPointIndex();
        this._speedLabel.setText("");
        UnitSet unitSet = UnitSetLibrary.getUnitSet(this._distUnitsDropdown.getSelectedIndex());
        String string3 = I18nManager.getText(unitSet.getDistanceUnit().getShortnameKey());
        String string4 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        if (this._track == null || dataPoint == null) {
            this._indexLabel.setText(I18nManager.getText("details.nopointselection"));
            this._latLabel.setText("");
            this._longLabel.setText("");
            this._altLabel.setText("");
            this._timeLabel.setText("");
            this._nameLabel.setText("");
            this._typeLabel.setText("");
            this._speedLabel.setText("");
            this._vSpeedLabel.setText("");
        } else {
            this._indexLabel.setText(String.valueOf(LABEL_POINT_SELECTED) + (n + 1) + " " + I18nManager.getText("details.index.of") + " " + this._track.getNumPoints());
            this._latLabel.setText(DetailsDisplay.makeCoordinateLabel(LABEL_POINT_LATITUDE, dataPoint.getLatitude(), this._coordFormatDropdown.getSelectedIndex()));
            this._longLabel.setText(DetailsDisplay.makeCoordinateLabel(LABEL_POINT_LONGITUDE, dataPoint.getLongitude(), this._coordFormatDropdown.getSelectedIndex()));
            object2 = Config.getUnitSet().getAltitudeUnit();
            this._altLabel.setText(dataPoint.hasAltitude() ? String.valueOf(LABEL_POINT_ALTITUDE) + dataPoint.getAltitude().getValue((Unit)object2) + " " + I18nManager.getText(((Unit)object2).getShortnameKey()) : "");
            if (dataPoint.hasTimestamp()) {
                this._timeLabel.setText(String.valueOf(LABEL_POINT_TIMESTAMP) + dataPoint.getTimestamp().getText());
            } else {
                this._timeLabel.setText("");
            }
            object = new SpeedValue();
            SpeedCalculator.calculateSpeed(this._track, n, (SpeedValue)object);
            if (((SpeedValue)object).isValid()) {
                string2 = String.valueOf(this.roundedNumber(((SpeedValue)object).getValue())) + " " + string4;
                this._speedLabel.setText(String.valueOf(LABEL_POINT_SPEED) + string2);
            } else {
                this._speedLabel.setText("");
            }
            SpeedCalculator.calculateVerticalSpeed(this._track, n, (SpeedValue)object);
            if (((SpeedValue)object).isValid()) {
                string2 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                string = String.valueOf(this.roundedNumber(((SpeedValue)object).getValue())) + " " + string2;
                this._vSpeedLabel.setText(String.valueOf(LABEL_POINT_VERTSPEED) + string);
            } else {
                this._vSpeedLabel.setText("");
            }
            string2 = dataPoint.getWaypointName();
            if (string2 != null && !string2.equals("")) {
                this._nameLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTNAME) + string2);
            } else {
                this._nameLabel.setText("");
            }
            string = dataPoint.getFieldValue(Field.WAYPT_TYPE);
            if (string != null && !string.equals("")) {
                this._typeLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTTYPE) + string);
            } else {
                this._typeLabel.setText("");
            }
        }
        if (this._track == null || !selection.hasRangeSelected()) {
            this._rangeLabel.setText(I18nManager.getText("details.norangeselection"));
            this._distanceLabel.setText("");
            this._durationLabel.setText("");
            this._altRangeLabel.setText("");
            this._updownLabel.setText("");
            this._aveSpeedLabel.setText("");
        } else {
            this._rangeLabel.setText(String.valueOf(LABEL_RANGE_SELECTED) + (selection.getStart() + 1) + " " + I18nManager.getText("details.range.to") + " " + (selection.getEnd() + 1));
            this._distanceLabel.setText(String.valueOf(LABEL_RANGE_DISTANCE) + this.roundedNumber(selection.getDistance()) + " " + string3);
            if (selection.getNumSeconds() > 0L) {
                this._durationLabel.setText(String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(selection.getNumSeconds()));
                this._aveSpeedLabel.setText(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": " + this.roundedNumber(selection.getDistance() / (double)selection.getNumSeconds() * 3600.0) + " " + string4);
            } else {
                this._durationLabel.setText("");
                this._aveSpeedLabel.setText("");
            }
            object2 = selection.getAltitudeRange();
            object = Config.getUnitSet().getAltitudeUnit();
            string2 = I18nManager.getText(((Unit)object).getShortnameKey());
            if (((AltitudeRange)object2).hasRange()) {
                this._altRangeLabel.setText(String.valueOf(LABEL_RANGE_ALTITUDE) + ((AltitudeRange)object2).getMinimum((Unit)object) + string2 + " " + I18nManager.getText("details.altitude.to") + " " + ((AltitudeRange)object2).getMaximum((Unit)object) + string2);
                this._updownLabel.setText(String.valueOf(LABEL_RANGE_CLIMB) + ((AltitudeRange)object2).getClimb((Unit)object) + string2 + LABEL_RANGE_DESCENT + ((AltitudeRange)object2).getDescent((Unit)object) + string2);
            } else {
                this._altRangeLabel.setText("");
                this._updownLabel.setText("");
            }
        }
        this._photoDetailsPanel.setVisible(this._trackInfo.getPhotoList().getNumPhotos() > 0);
        object2 = this._trackInfo.getPhotoList().getPhoto(this._trackInfo.getSelection().getCurrentPhotoIndex());
        if ((dataPoint == null || dataPoint.getPhoto() == null) && object2 == null) {
            this._photoLabel.setText(I18nManager.getText("details.nophoto"));
            this._photoPathLabel.setText("");
            this._photoPathLabel.setToolTipText("");
            this._photoTimestampLabel.setText("");
            this._photoConnectedLabel.setText("");
            this._photoBearingLabel.setText("");
            this._photoThumbnail.setVisible(false);
            this._rotationButtons.setVisible(false);
        } else {
            if (object2 == null) {
                object2 = dataPoint.getPhoto();
            }
            this._photoLabel.setText(String.valueOf(I18nManager.getText("details.photofile")) + ": " + ((MediaObject)object2).getName());
            object = ((MediaObject)object2).getFullPath();
            string2 = DetailsDisplay.shortenPath((String)object);
            this._photoPathLabel.setText(object == null ? "" : String.valueOf(LABEL_FULL_PATH) + string2);
            this._photoPathLabel.setToolTipText(((MediaObject)object2).getFullPath());
            this._photoTimestampLabel.setText(((MediaObject)object2).hasTimestamp() ? String.valueOf(LABEL_POINT_TIMESTAMP) + ((MediaObject)object2).getTimestamp().getText() : "");
            this._photoConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object2).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
            if (((Photo)object2).getBearing() >= 0.0 && ((Photo)object2).getBearing() <= 360.0) {
                this._photoBearingLabel.setText(String.valueOf(I18nManager.getText("details.photo.bearing")) + ": " + (int)((Photo)object2).getBearing() + " \u00b0");
            } else {
                this._photoBearingLabel.setText("");
            }
            this._photoThumbnail.setVisible(true);
            this._photoThumbnail.setPhoto((Photo)object2);
            this._rotationButtons.setVisible(true);
            if ((by & 0x10) > 0) {
                this._photoThumbnail.refresh();
            }
        }
        this._photoThumbnail.repaint();
        this._audioDetailsPanel.setVisible(this._trackInfo.getAudioList().getNumAudios() > 0);
        object = this._trackInfo.getAudioList().getAudio(this._trackInfo.getSelection().getCurrentAudioIndex());
        if (object == null) {
            this._audioLabel.setText(I18nManager.getText("details.noaudio"));
            this._audioPathLabel.setText("");
            this._audioPathLabel.setToolTipText("");
            this._audioTimestampLabel.setText("");
            this._audioLengthLabel.setText("");
            this._audioConnectedLabel.setText("");
        } else {
            this._audioLabel.setText(String.valueOf(LABEL_AUDIO_FILE) + ((MediaObject)object).getName());
            string2 = ((MediaObject)object).getFullPath();
            string = DetailsDisplay.shortenPath(string2);
            this._audioPathLabel.setText(string2 == null ? "" : String.valueOf(LABEL_FULL_PATH) + string);
            this._audioPathLabel.setToolTipText(string2 == null ? "" : string2);
            this._audioTimestampLabel.setText(((MediaObject)object).hasTimestamp() ? String.valueOf(LABEL_POINT_TIMESTAMP) + ((MediaObject)object).getTimestamp().getText() : "");
            int n2 = ((AudioClip)object).getLengthInSeconds();
            this._audioLengthLabel.setText(n2 < 0 ? "" : String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(n2));
            this._audioConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
        }
        this._playAudioPanel.setVisible(object != null);
    }

    private static String makeCoordinateLabel(String string, Coordinate coordinate, int n) {
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = coordinate.output(10);
                break;
            }
            case 2: {
                string2 = coordinate.output(11);
                break;
            }
            case 3: {
                string2 = coordinate.output(12);
                break;
            }
            default: {
                string2 = coordinate.output(19);
            }
        }
        if (string2.indexOf(65533) >= 0) {
            string2 = string2.replaceAll(String.valueOf('\ufffd'), "\u00b0");
        }
        return String.valueOf(string) + DetailsDisplay.restrictDP(string2);
    }

    private String roundedNumber(double d) {
        int n = 0;
        if (d < 1.0) {
            n = 3;
        } else if (d < 10.0) {
            n = 2;
        } else if (d < 100.0) {
            n = 1;
        }
        this._distanceFormatter.setMaximumFractionDigits(n);
        this._distanceFormatter.setMinimumFractionDigits(n);
        return this._distanceFormatter.format(d);
    }

    private static String restrictDP(String string) {
        int n;
        if (string == null) {
            return "";
        }
        int n2 = Math.max(string.lastIndexOf(46), string.lastIndexOf(44));
        if (n2 >= 0 && (n = n2 + 7) < string.length() - 1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static JPanel makeDetailsPanel(String string, Font font) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText(string));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        return jPanel;
    }

    private static JButton makeRotateButton(String string, GenericFunction genericFunction) {
        JButton jButton = new JButton(IconManager.getImageIcon(string));
        jButton.setToolTipText(I18nManager.getText(genericFunction.getNameKey()));
        jButton.setMargin(new Insets(0, 2, 0, 2));
        jButton.addActionListener(new FunctionLauncher(genericFunction));
        return jButton;
    }

    private static String shortenPath(String string) {
        String string2 = System.getProperty("user.home").toLowerCase();
        if (string != null && string.toLowerCase().startsWith(string2)) {
            string = string.substring(string2.length() + 1);
        }
        if (string == null || string.length() < 21) {
            return string;
        }
        return String.valueOf(string.substring(0, 20)) + "...";
    }
}

