/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.data.Checker;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.MidpointData;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.compress.MarkPointsInRectangleFunction;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;
import tim.prune.gui.IconManager;
import tim.prune.gui.map.MapPosition;
import tim.prune.gui.map.MapTileManager;
import tim.prune.gui.map.MapUtils;
import tim.prune.gui.map.OverlayPanel;
import tim.prune.gui.map.ScaleBar;

public class MapCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
DataSubscriber,
KeyListener,
MouseWheelListener {
    private App _app = null;
    private Track _track = null;
    private TrackInfo _trackInfo = null;
    private Selection _selection = null;
    private MidpointData _midpoints = null;
    private int _clickedPoint = -1;
    private int _prevSelectedPoint = -1;
    private MapTileManager _tileManager = new MapTileManager(this);
    private BufferedImage _mapImage = null;
    private JSlider _transparencySlider = null;
    private JCheckBox _scaleCheckBox = null;
    private JCheckBox _mapCheckBox = null;
    private JCheckBox _autopanCheckBox = null;
    private JCheckBox _connectCheckBox = null;
    private JCheckBox _editmodeCheckBox = null;
    private JPopupMenu _popup = null;
    private JPanel _topPanel = null;
    private JPanel _sidePanel = null;
    private ScaleBar _scaleBar = null;
    private DoubleRange _latRange = null;
    private DoubleRange _lonRange = null;
    private DoubleRange _xRange = null;
    private DoubleRange _yRange = null;
    private boolean _recalculate = false;
    private boolean _checkBounds = false;
    private MapPosition _mapPosition = null;
    private int _dragFromX = -1;
    private int _dragFromY = -1;
    private int _dragToX = -1;
    private int _dragToY = -1;
    private int _popupMenuX = -1;
    private int _popupMenuY = -1;
    private boolean _shownOsmErrorAlready = false;
    private int _drawMode = 0;
    private static final int CLICK_SENSITIVITY = 10;
    private static final int PAN_DISTANCE = 20;
    private static final int AUTOPAN_DISTANCE = 75;
    private static final Color COLOR_MESSAGES = Color.GRAY;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ZOOM_RECT = 1;
    private static final int MODE_DRAW_POINTS_START = 2;
    private static final int MODE_DRAW_POINTS_CONT = 3;
    private static final int MODE_DRAG_POINT = 4;
    private static final int MODE_CREATE_MIDPOINT = 5;
    private static final int MODE_MARK_RECTANGLE = 6;
    private static final int INDEX_UNKNOWN = -2;

    public MapCanvas(App app, TrackInfo trackInfo) {
        this._app = app;
        this._trackInfo = trackInfo;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
        this._midpoints = new MidpointData();
        this._mapPosition = new MapPosition();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MapCanvas.this._tileManager.clearMemoryCaches();
                MapCanvas.this._recalculate = true;
                Config.setConfigBoolean("prune.showmap", itemEvent.getStateChange() == 1);
                UpdateMessageBroker.informSubscribers();
                if (itemEvent.getStateChange() == 2 && MapCanvas.this._transparencySlider.getValue() < 0) {
                    MapCanvas.this._transparencySlider.setValue(0);
                }
            }
        };
        this._topPanel = new OverlayPanel();
        this._topPanel.setLayout(new FlowLayout());
        this._transparencySlider = new JSlider(-6, 6, 0);
        this._transparencySlider.setPreferredSize(new Dimension(100, 20));
        this._transparencySlider.setMajorTickSpacing(1);
        this._transparencySlider.setSnapToTicks(true);
        this._transparencySlider.setOpaque(false);
        this._transparencySlider.setValue(0);
        this._transparencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = MapCanvas.this._transparencySlider.getValue();
                if (n == 1 || n == -1) {
                    MapCanvas.this._transparencySlider.setValue(0);
                } else {
                    MapCanvas.this._recalculate = true;
                    MapCanvas.this.repaint();
                }
            }
        });
        this._transparencySlider.setFocusable(false);
        this._topPanel.add(this._transparencySlider);
        this._scaleCheckBox = new JCheckBox(IconManager.getImageIcon("scalebar.gif"), true);
        this._scaleCheckBox.setSelectedIcon(IconManager.getImageIcon("scalebar_on.gif"));
        this._scaleCheckBox.setOpaque(false);
        this._scaleCheckBox.setToolTipText(I18nManager.getText("menu.map.showscalebar"));
        this._scaleCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MapCanvas.this._scaleBar.setVisible(MapCanvas.this._scaleCheckBox.isSelected());
            }
        });
        this._scaleCheckBox.setFocusable(false);
        this._topPanel.add(this._scaleCheckBox);
        this._mapCheckBox = new JCheckBox(IconManager.getImageIcon("map_icon.gif"), false);
        this._mapCheckBox.setSelectedIcon(IconManager.getImageIcon("map_icon_on.gif"));
        this._mapCheckBox.setOpaque(false);
        this._mapCheckBox.setToolTipText(I18nManager.getText("menu.map.showmap"));
        this._mapCheckBox.addItemListener(itemListener2);
        this._mapCheckBox.setFocusable(false);
        this._topPanel.add(this._mapCheckBox);
        this._autopanCheckBox = new JCheckBox(IconManager.getImageIcon("autopan.gif"), true);
        this._autopanCheckBox.setSelectedIcon(IconManager.getImageIcon("autopan_on.gif"));
        this._autopanCheckBox.setOpaque(false);
        this._autopanCheckBox.setToolTipText(I18nManager.getText("menu.map.autopan"));
        this._autopanCheckBox.addItemListener(itemListener);
        this._autopanCheckBox.setFocusable(false);
        this._topPanel.add(this._autopanCheckBox);
        this._connectCheckBox = new JCheckBox(IconManager.getImageIcon("points_disconnected.gif"), true);
        this._connectCheckBox.setSelectedIcon(IconManager.getImageIcon("points_connected.gif"));
        this._connectCheckBox.setOpaque(false);
        this._connectCheckBox.setToolTipText(I18nManager.getText("menu.map.connect"));
        this._connectCheckBox.addItemListener(itemListener);
        this._connectCheckBox.setFocusable(false);
        this._topPanel.add(this._connectCheckBox);
        this._editmodeCheckBox = new JCheckBox(IconManager.getImageIcon("drag_points_icon.gif"), false);
        this._editmodeCheckBox.setSelectedIcon(IconManager.getImageIcon("drag_points_icon_on.gif"));
        this._editmodeCheckBox.setOpaque(false);
        this._editmodeCheckBox.setToolTipText(I18nManager.getText("menu.map.editmode"));
        this._editmodeCheckBox.addItemListener(itemListener);
        this._editmodeCheckBox.setFocusable(false);
        this._topPanel.add(this._editmodeCheckBox);
        this._sidePanel = new OverlayPanel();
        this._sidePanel.setLayout(new BoxLayout(this._sidePanel, 1));
        JButton jButton = new JButton(IconManager.getImageIcon("zoom_in.gif"));
        jButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton.setContentAreaFilled(false);
        jButton.setToolTipText(I18nManager.getText("menu.map.zoomin"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomIn();
            }
        });
        jButton.setFocusable(false);
        this._sidePanel.add(jButton);
        JButton jButton2 = new JButton(IconManager.getImageIcon("zoom_out.gif"));
        jButton2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText(I18nManager.getText("menu.map.zoomout"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomOut();
            }
        });
        jButton2.setFocusable(false);
        this._sidePanel.add(jButton2);
        this._scaleBar = new ScaleBar();
        this.setLayout(new BorderLayout());
        this._topPanel.setVisible(false);
        this._sidePanel.setVisible(false);
        this.add((Component)this._topPanel, "North");
        this.add((Component)this._sidePanel, "West");
        this.add((Component)this._scaleBar, "South");
        this.makePopup();
    }

    private void makePopup() {
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("menu.map.zoomin"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.panMap((MapCanvas.this._popupMenuX - MapCanvas.this.getWidth() / 2) / 2, (MapCanvas.this._popupMenuY - MapCanvas.this.getHeight() / 2) / 2);
                MapCanvas.this.zoomIn();
            }
        });
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("menu.map.zoomout"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.panMap(-(MapCanvas.this._popupMenuX - MapCanvas.this.getWidth() / 2), -(MapCanvas.this._popupMenuY - MapCanvas.this.getHeight() / 2));
                MapCanvas.this.zoomOut();
            }
        });
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.map.zoomfull"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomToFit();
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        });
        this._popup.add(jMenuItem3);
        this._popup.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(I18nManager.getText(FunctionLibrary.FUNCTION_SET_MAP_BG.getNameKey()));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_SET_MAP_BG.begin();
            }
        });
        this._popup.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(I18nManager.getText("menu.map.newpoint"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this._app.createPoint(MapCanvas.this.createPointFromClick(MapCanvas.this._popupMenuX, MapCanvas.this._popupMenuY));
            }
        });
        this._popup.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(I18nManager.getText("menu.map.drawpoints"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this._drawMode = 2;
            }
        });
        this._popup.add(jMenuItem6);
    }

    private void zoomToFit() {
        this._latRange = this._track.getLatRange();
        this._lonRange = this._track.getLonRange();
        this._xRange = new DoubleRange(MapUtils.getXFromLongitude(this._lonRange.getMinimum()), MapUtils.getXFromLongitude(this._lonRange.getMaximum()));
        this._yRange = new DoubleRange(MapUtils.getYFromLatitude(this._latRange.getMinimum()), MapUtils.getYFromLatitude(this._latRange.getMaximum()));
        this._mapPosition.zoomToXY(this._xRange.getMinimum(), this._xRange.getMaximum(), this._yRange.getMinimum(), this._yRange.getMaximum(), this.getWidth(), this.getHeight());
    }

    public void paint(Graphics graphics) {
        block19: {
            block18: {
                int n;
                int n2;
                int n3;
                super.paint(graphics);
                if (this._mapImage != null && (this._mapImage.getWidth() != this.getWidth() || this._mapImage.getHeight() != this.getHeight())) {
                    this._mapImage = null;
                }
                if (this._track.getNumPoints() <= 0) break block18;
                if (this._autopanCheckBox.isSelected()) {
                    n3 = this._selection.getCurrentPointIndex();
                    if (n3 >= 0 && this._dragFromX == -1 && n3 != this._prevSelectedPoint) {
                        n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n3));
                        n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n3));
                        int n4 = 0;
                        int n5 = 0;
                        if (n2 < 20) {
                            n4 = n2 - 75;
                        } else if (n2 > this.getWidth() - 20) {
                            n4 = 75 + n2 - this.getWidth();
                        }
                        if (n < 20) {
                            n5 = n - 75;
                        }
                        if (n > this.getHeight() - 20) {
                            n5 = 75 + n - this.getHeight();
                        }
                        if (n4 != 0 || n5 != 0) {
                            this._mapPosition.pan(n4, n5);
                        }
                    }
                    this._prevSelectedPoint = n3;
                }
                if (this._mapImage == null || this._recalculate) {
                    this.paintMapContents();
                    this._scaleBar.updateScale(this._mapPosition.getZoom(), this._mapPosition.getYFromPixels(0, 0));
                }
                if (this._mapImage != null) {
                    graphics.drawImage(this._mapImage, 0, 0, this.getWidth(), this.getHeight(), null);
                }
                switch (this._drawMode) {
                    case 4: {
                        this.drawDragLines(graphics, this._selection.getCurrentPointIndex() - 1, this._selection.getCurrentPointIndex() + 1);
                        break;
                    }
                    case 5: {
                        this.drawDragLines(graphics, this._clickedPoint - 1, this._clickedPoint);
                        break;
                    }
                    case 1: 
                    case 6: {
                        if (this._dragFromX != -1 && this._dragFromY != -1) {
                            graphics.setColor(Color.RED);
                            graphics.drawLine(this._dragFromX, this._dragFromY, this._dragFromX, this._dragToY);
                            graphics.drawLine(this._dragFromX, this._dragFromY, this._dragToX, this._dragFromY);
                            graphics.drawLine(this._dragToX, this._dragFromY, this._dragToX, this._dragToY);
                            graphics.drawLine(this._dragFromX, this._dragToY, this._dragToX, this._dragToY);
                            break;
                        }
                        break block19;
                    }
                    case 3: {
                        graphics.setColor(Config.getColourScheme().getColour(1));
                        n3 = this._track.getNumPoints() - 1;
                        n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n3));
                        n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n3));
                        graphics.drawLine(n2, n, this._dragToX, this._dragToY);
                    }
                }
                break block19;
            }
            graphics.setColor(Config.getColourScheme().getColour(0));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(COLOR_MESSAGES);
            graphics.drawString(I18nManager.getText("display.nodata"), 50, this.getHeight() / 2);
            this._scaleBar.updateScale(-1, 0.0);
        }
        this.paintChildren(graphics);
    }

    private void paintMapContents() {
        int n;
        if (this._mapImage == null || this._mapImage.getWidth() != this.getWidth() || this._mapImage.getHeight() != this.getHeight()) {
            this._mapImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        Graphics graphics = this._mapImage.getGraphics();
        graphics.setColor(Config.getColourScheme().getColour(0));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        boolean bl = Config.getConfigBoolean("prune.showmap");
        this._mapCheckBox.setSelected(bl);
        if (!bl) {
            this._shownOsmErrorAlready = false;
        }
        this._recalculate = false;
        if (bl) {
            this._tileManager.centreMap(this._mapPosition.getZoom(), this._mapPosition.getCentreTileX(), this._mapPosition.getCentreTileY());
            n = 0;
            if (this._mapImage == null) {
                return;
            }
            if (this._tileManager.isOverzoomed()) {
                graphics.setColor(COLOR_MESSAGES);
                graphics.drawString(I18nManager.getText("map.overzoom"), 50, this.getHeight() / 2);
            } else {
                int n2 = this._tileManager.getNumLayers();
                int[] nArray = this._mapPosition.getTileIndices(this.getWidth(), this.getHeight());
                int[] nArray2 = this._mapPosition.getDisplayOffsets(this.getWidth(), this.getHeight());
                int n3 = nArray[0];
                while (n3 <= nArray[1] && n == 0) {
                    int n4 = (n3 - nArray[0]) * 256 - nArray2[0];
                    int n5 = nArray[2];
                    while (n5 <= nArray[3]) {
                        int n6 = (n5 - nArray[2]) * 256 - nArray2[1];
                        int n7 = 0;
                        while (n7 < n2) {
                            Image image = this._tileManager.getTile(n7, n3, n5);
                            if (image != null) {
                                graphics.drawImage(image, n4, n6, 256, 256, null);
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n3;
                }
                n3 = Math.max(1, this._transparencySlider.getValue()) - 1;
                if (n3 > 0) {
                    int[] nArray3 = new int[6];
                    nArray3[1] = 40;
                    nArray3[2] = 80;
                    nArray3[3] = 120;
                    nArray3[4] = 160;
                    nArray3[5] = 210;
                    int[] nArray4 = nArray3;
                    Color color = Config.getColourScheme().getColour(0);
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), nArray4[n3]);
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        }
        n = 1;
        try {
            n = this.paintPoints(graphics);
        }
        catch (NullPointerException nullPointerException) {}
        graphics.dispose();
        if (n <= 0 && this._checkBounds) {
            this.zoomToFit();
            this._recalculate = true;
            this.repaint();
        }
        this._checkBounds = false;
        this._transparencySlider.setEnabled(bl);
    }

    private int paintPoints(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ColourScheme colourScheme = Config.getColourScheme();
        int[] nArray = new int[6];
        nArray[0] = 255;
        nArray[1] = 190;
        nArray[2] = 130;
        nArray[3] = 80;
        nArray[4] = 40;
        int[] nArray2 = nArray;
        int n6 = 255;
        if (this._transparencySlider.getValue() < 0) {
            n6 = nArray2[-1 - this._transparencySlider.getValue()];
        }
        Color color = MapCanvas.makeTransparentColour(colourScheme.getColour(1), n6);
        Color color2 = MapCanvas.makeTransparentColour(colourScheme.getColour(2), n6);
        Color color3 = MapCanvas.makeTransparentColour(colourScheme.getColour(4), n6);
        Color color4 = MapCanvas.makeTransparentColour(colourScheme.getColour(5), n6);
        Color color5 = MapCanvas.makeTransparentColour(colourScheme.getColour(3), n6);
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        int n9 = n7 / 2;
        int n10 = n8 / 2;
        int n11 = this._track.getNumPoints();
        int[] nArray3 = new int[n11];
        int[] nArray4 = new int[n11];
        if (graphics instanceof Graphics2D) {
            n5 = Config.getConfigInt("prune.linewidth");
            if (n5 < 1 || n5 > 4) {
                n5 = 2;
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(n5));
        }
        n5 = 0;
        graphics.setColor(color);
        int n12 = -1;
        int n13 = -1;
        boolean bl = this._connectCheckBox.isSelected();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n14 = 0;
        while (n14 < n11) {
            n4 = n9 + this._mapPosition.getXFromCentre(this._track.getX(n14));
            n3 = n10 + this._mapPosition.getYFromCentre(this._track.getY(n14));
            nArray3[n14] = n4 = MapCanvas.wrapLongitudeValue(n4, n7, this._mapPosition.getZoom());
            nArray4[n14] = n3;
            bl3 = n4 >= 0 && n4 < n7 && n3 >= 0 && n3 < n8;
            bl5 = this._track.getPoint(n14).isWaypoint();
            boolean bl6 = bl4 = bl4 || bl5;
            if (bl3 && !bl5) {
                if (this._track.getPoint(n14).getDeleteFlag()) {
                    graphics.setColor(color3);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawRect(n4 - 2, n3 - 2, 3, 3);
                ++n5;
            }
            if (!bl5) {
                if (bl && (bl3 || bl2) && (n12 != -1 || n13 != -1) && !this._track.getPoint(n14).getSegmentStart()) {
                    graphics.drawLine(n12, n13, n4, n3);
                }
                n12 = n4;
                n13 = n3;
            }
            bl2 = bl3;
            ++n14;
        }
        graphics.setColor(color5);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n4 = fontMetrics.getHeight();
        if (bl4) {
            n3 = 0;
            while (n3 < this._track.getNumPoints()) {
                if (this._track.getPoint(n3).isWaypoint()) {
                    n2 = nArray3[n3];
                    n = nArray4[n3];
                    if (n2 >= 0 && n2 < n7 && n >= 0 && n < n8) {
                        graphics.fillRect(n2 - 3, n - 3, 6, 6);
                        ++n5;
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this._track.getNumPoints()) {
                if (this._track.getPoint(n3).isWaypoint()) {
                    n2 = nArray3[n3];
                    n = nArray4[n3];
                    if (n2 >= 0 && n2 < n7 && n >= 0 && n < n8) {
                        String string = this._track.getPoint(n3).getWaypointName();
                        int n15 = fontMetrics.stringWidth(string);
                        boolean bl7 = false;
                        int[] nArray5 = new int[]{n2 + 2, n2 - n15 - 2, n2 - n15 / 2, n2 - n15 / 2};
                        int[] nArray6 = new int[]{n + n4 / 2, n + n4 / 2, n - 2, n + n4 + 2};
                        int n16 = 4;
                        while (n16 < 13 && !bl7) {
                            nArray5[0] = nArray5[0] + 2;
                            nArray5[1] = nArray5[1] - 2;
                            nArray6[2] = nArray6[2] - 2;
                            nArray6[3] = nArray6[3] + 2;
                            int n17 = 0;
                            while (n17 < 4) {
                                if (nArray5[n17] > 0 && nArray5[n17] + n15 < n7 && nArray6[n17] < n8 && nArray6[n17] - n4 > 0 && !this.overlapsPoints(nArray5[n17], nArray6[n17], n15, n4, color5)) {
                                    graphics.drawString(string, nArray5[n17], nArray6[n17]);
                                    bl7 = true;
                                    break;
                                }
                                ++n17;
                            }
                            n16 += 2;
                        }
                    }
                }
                ++n3;
            }
        }
        graphics.setColor(color4);
        n3 = 0;
        while (n3 < this._track.getNumPoints()) {
            if (this._track.getPoint(n3).hasMedia()) {
                n2 = nArray3[n3];
                n = nArray4[n3];
                if (n2 >= 0 && n2 < n7 && n >= 0 && n < n8) {
                    graphics.drawRect(n2 - 1, n - 1, 2, 2);
                    graphics.drawRect(n2 - 2, n - 2, 4, 4);
                    ++n5;
                }
            }
            ++n3;
        }
        if (this._selection.hasRangeSelected()) {
            graphics.setColor(color2);
            n3 = this._selection.getStart();
            while (n3 <= this._selection.getEnd()) {
                n2 = nArray3[n3];
                n = nArray4[n3];
                graphics.drawRect(n2 - 1, n - 1, 2, 2);
                ++n3;
            }
        }
        if ((n3 = this._selection.getCurrentPointIndex()) >= 0) {
            n2 = nArray3[n3];
            n = nArray4[n3];
            graphics.setColor(color3);
            graphics.drawLine(n2, 0, n2, n8);
            graphics.drawLine(0, n, n7, n);
        }
        return n5;
    }

    private static int wrapLongitudeValue(int n, int n2, int n3) {
        if (n > n2) {
            int n4 = n;
            while (n4 > n2) {
                n4 -= 256 << n3;
            }
            if (n4 >= 0) {
                return n4;
            }
        } else if (n < 0) {
            int n5 = n;
            while (n5 < 0) {
                n5 += 256 << n3;
            }
            if (n5 < n2) {
                return n5;
            }
        }
        return n;
    }

    private void drawDragLines(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        graphics.setColor(Config.getColourScheme().getColour(1));
        if (n > -1 && !this._track.getPoint(n + 1).getSegmentStart()) {
            n4 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n));
            n3 = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n));
            graphics.drawLine(n4, n3, this._dragToX, this._dragToY);
        }
        if (n2 < this._track.getNumPoints() && !this._track.getPoint(n2).getSegmentStart()) {
            n4 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n2));
            n3 = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n2));
            graphics.drawLine(n4, n3, this._dragToX, this._dragToY);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean overlapsPoints(int n, int n2, int n3, int n4, Color color) {
        int n5 = color.getRGB();
        int n6 = n5 & 0xFF;
        int n7 = n5 >> 8 & 0xFF;
        int n8 = n5 >> 16 & 0xFF;
        try {
            int n9 = 0;
            block2: while (true) {
                if (n9 >= n3) {
                    return false;
                }
                int n10 = 0;
                while (true) {
                    if (n10 >= n4) {
                        ++n9;
                        continue block2;
                    }
                    int n11 = this._mapImage.getRGB(n + n9, n2 - n10);
                    int n12 = n11 & 0xFF;
                    int n13 = n11 >> 8 & 0xFF;
                    int n14 = n11 >> 16 & 0xFF;
                    if (Math.abs(n12 - n6) < 80) return true;
                    if (Math.abs(n13 - n7) < 80) return true;
                    if (Math.abs(n14 - n8) < 80) {
                        return true;
                    }
                    ++n10;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    private static Color makeTransparentColour(Color color, int n) {
        if (n > 240) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public synchronized void tilesUpdated(boolean bl) {
        if (!bl && !this._shownOsmErrorAlready && this._mapCheckBox.isSelected()) {
            this._shownOsmErrorAlready = true;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    MapCanvas.this._app.showErrorMessage("error.osmimage.dialogtitle", "error.osmimage.failed");
                }
            }).start();
        }
        this._recalculate = true;
        this.repaint();
    }

    public void zoomOut() {
        this._mapPosition.zoomOut();
        this._recalculate = true;
        this.repaint();
    }

    public void zoomIn() {
        this._mapPosition.zoomIn();
        this._recalculate = true;
        this.repaint();
    }

    public void panMap(int n, int n2) {
        this._mapPosition.pan(n, n2);
        this._recalculate = true;
        this.repaint();
    }

    private DataPoint createPointFromClick(int n, int n2) {
        double d = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n2, this.getHeight()));
        double d2 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n, this.getWidth()));
        return new DataPoint(new Latitude(d, 19), new Longitude(d2, 19), null);
    }

    private void movePointToMouse(int n, int n2, int n3, int n4) {
        double d = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n2, this.getHeight()));
        double d2 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n, this.getWidth()));
        double d3 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(n4, this.getHeight())) - d;
        double d4 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(n3, this.getWidth())) - d2;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        FieldEditList fieldEditList = new FieldEditList();
        FieldEditList fieldEditList2 = new FieldEditList();
        FieldList fieldList = this._track.getFieldList();
        int n5 = fieldList.getNumFields();
        int n6 = 0;
        while (n6 < n5) {
            Field field = fieldList.getField(n6);
            if (field == Field.LATITUDE) {
                fieldEditList.addEdit(new FieldEdit(field, Double.toString(dataPoint.getLatitude().getDouble() + d3)));
                fieldEditList2.addEdit(new FieldEdit(field, dataPoint.getFieldValue(Field.LATITUDE)));
            } else if (field == Field.LONGITUDE) {
                fieldEditList.addEdit(new FieldEdit(field, Double.toString(dataPoint.getLongitude().getDouble() + d4)));
                fieldEditList2.addEdit(new FieldEdit(field, dataPoint.getFieldValue(Field.LONGITUDE)));
            }
            ++n6;
        }
        this._app.completePointEdit(fieldEditList, fieldEditList2);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(512, 300);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track != null && this._track.getNumPoints() > 0) {
            if (!mouseEvent.isMetaDown()) {
                if (mouseEvent.getClickCount() == 1) {
                    if (this._drawMode == 0) {
                        int n = this._clickedPoint;
                        if (n == -2) {
                            n = this._track.getNearestPointIndex(this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth()), this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight()), this._mapPosition.getBoundsFromPixels(10), false);
                        }
                        if (mouseEvent.isShiftDown()) {
                            this._trackInfo.extendSelection(n);
                        } else {
                            this._trackInfo.selectPoint(n);
                        }
                    } else if (this._drawMode == 2) {
                        this._app.createPoint(this.createPointFromClick(mouseEvent.getX(), mouseEvent.getY()));
                        this._dragToX = mouseEvent.getX();
                        this._dragToY = mouseEvent.getY();
                        this._drawMode = 3;
                    } else if (this._drawMode == 3) {
                        DataPoint dataPoint = this.createPointFromClick(mouseEvent.getX(), mouseEvent.getY());
                        this._app.createPoint(dataPoint);
                        dataPoint.setSegmentStart(false);
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    if (this._drawMode == 0) {
                        this.panMap(mouseEvent.getX() - this.getWidth() / 2, mouseEvent.getY() - this.getHeight() / 2);
                        this.zoomIn();
                    } else if (this._drawMode == 2 || this._drawMode == 3) {
                        this._drawMode = 0;
                    }
                }
            } else {
                this._popupMenuX = mouseEvent.getX();
                this._popupMenuY = mouseEvent.getY();
                this._popup.show(this, this._popupMenuX, this._popupMenuY);
            }
        }
        this._app.setCurrentMode(App.AppMode.NORMAL);
        if (this._drawMode == 6) {
            this._drawMode = 0;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._clickedPoint = -2;
        if (this._track == null || this._track.getNumPoints() <= 0) {
            return;
        }
        if (!mouseEvent.isMetaDown() && this._drawMode == 0 && (this._editmodeCheckBox.isSelected() || mouseEvent.isAltDown() || mouseEvent.isAltGraphDown())) {
            double d = this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth());
            double d2 = this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight());
            double d3 = this._mapPosition.getBoundsFromPixels(10);
            this._clickedPoint = this._track.getNearestPointIndex(d, d2, d3, false);
            if (this._clickedPoint >= 0) {
                this._trackInfo.selectPoint(this._clickedPoint);
                if (this._trackInfo.getCurrentPoint() != null) {
                    this._drawMode = 4;
                    this._dragFromX = this._dragToX = mouseEvent.getX();
                    this._dragFromY = this._dragToY = mouseEvent.getY();
                }
            } else {
                int n = this._midpoints.getNearestPointIndex(d, d2, d3);
                if (n > 0) {
                    this._drawMode = 5;
                    this._clickedPoint = n;
                    this._dragFromX = this._dragToX = mouseEvent.getX();
                    this._dragFromY = this._dragToY = mouseEvent.getY();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._recalculate = true;
        if (this._drawMode == 4) {
            if (Math.abs(this._dragToX - this._dragFromX) > 2 || Math.abs(this._dragToY - this._dragFromY) > 2) {
                this.movePointToMouse(this._dragFromX, this._dragFromY, this._dragToX, this._dragToY);
            }
            this._drawMode = 0;
        } else if (this._drawMode == 5) {
            this._drawMode = 0;
            this._app.createPoint(this.createPointFromClick(this._dragToX, this._dragToY), this._clickedPoint);
        } else if (this._drawMode == 1) {
            if (Math.abs(this._dragToX - this._dragFromX) > 20 && Math.abs(this._dragToY - this._dragFromY) > 20) {
                this._mapPosition.zoomToPixels(this._dragFromX, this._dragToX, this._dragFromY, this._dragToY, this.getWidth(), this.getHeight());
            }
            this._drawMode = 0;
        } else if (this._drawMode == 6) {
            this._app.setCurrentMode(App.AppMode.NORMAL);
            this._drawMode = 0;
            MarkPointsInRectangleFunction markPointsInRectangleFunction = new MarkPointsInRectangleFunction(this._app);
            double d = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(this._dragFromX, this.getWidth()));
            double d2 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(this._dragFromY, this.getHeight()));
            double d3 = MapUtils.getLongitudeFromX(this._mapPosition.getXFromPixels(this._dragToX, this.getWidth()));
            double d4 = MapUtils.getLatitudeFromY(this._mapPosition.getYFromPixels(this._dragToY, this.getHeight()));
            if (this._dragFromX < 0 || this._dragFromY < 0) {
                d = d3;
                d2 = d4;
            }
            markPointsInRectangleFunction.setRectCoords(d, d2, d3, d4);
            markPointsInRectangleFunction.begin();
        }
        this._dragFromY = -1;
        this._dragFromX = -1;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (this._drawMode == 4 || this._drawMode == 5) {
                this._dragToX = mouseEvent.getX();
                this._dragToY = mouseEvent.getY();
                this._recalculate = true;
                this.repaint();
            } else if (this._drawMode == 6) {
                if (this._dragFromX == -1) {
                    this._dragFromX = mouseEvent.getX();
                    this._dragFromY = mouseEvent.getY();
                }
                this._dragToX = mouseEvent.getX();
                this._dragToY = mouseEvent.getY();
                this.repaint();
            } else {
                if (this._dragFromX != -1) {
                    this.panMap(this._dragFromX - mouseEvent.getX(), this._dragFromY - mouseEvent.getY());
                }
                this._dragFromX = this._dragToX = mouseEvent.getX();
                this._dragFromY = this._dragToY = mouseEvent.getY();
            }
        } else {
            this._drawMode = 1;
            if (this._dragFromX == -1) {
                this._dragFromX = mouseEvent.getX();
                this._dragFromY = mouseEvent.getY();
            }
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (this._drawMode == 3) {
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        } else if (this._drawMode == 6) {
            bl2 = true;
        } else if (this._editmodeCheckBox.isSelected() || mouseEvent.isAltDown() || mouseEvent.isAltGraphDown()) {
            double d;
            double d2;
            double d3 = this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth());
            boolean bl3 = bl = this._track.getNearestPointIndex(d3, d2 = this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight()), d = this._mapPosition.getBoundsFromPixels(10), false) >= 0 || this._midpoints.getNearestPointIndex(d3, d2, d) >= 0;
        }
        if (bl && !this.isCursorSet()) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else if (bl2 && !this.isCursorSet()) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else if (!bl && !bl2 && this.isCursorSet()) {
            this.setCursor(null);
        }
    }

    public void actionCompleted(String string) {
    }

    public void dataUpdated(byte by) {
        this._recalculate = true;
        if ((by & 1) > 0) {
            this._checkBounds = true;
        }
        if ((by & 0x40) > 0) {
            this._tileManager.resetConfig();
        }
        if ((by & 3) > 0) {
            this._midpoints.updateData(this._track);
        }
        if (this._app.getCurrentMode() == App.AppMode.DRAWRECT) {
            this._drawMode = 6;
            if (!this.isCursorSet()) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
        this.repaint();
        boolean bl = this._track.getNumPoints() > 0;
        this._topPanel.setVisible(bl);
        this._sidePanel.setVisible(bl);
        this.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this._selection.getCurrentPointIndex();
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            int n3;
            int n4 = n3 = keyEvent.isShiftDown() ? 3 : 1;
            if (n == 38) {
                this.zoomIn();
            } else if (n == 40) {
                this.zoomOut();
            } else if (n == 37 && n2 > 0) {
                this._trackInfo.incrementPointIndex(-n3);
            } else if (n == 39) {
                this._trackInfo.incrementPointIndex(n3);
            } else if (n == 33) {
                this._trackInfo.selectPoint(Checker.getPreviousSegmentStart(this._trackInfo.getTrack(), this._trackInfo.getSelection().getCurrentPointIndex()));
            } else if (n == 34) {
                this._trackInfo.selectPoint(Checker.getNextSegmentStart(this._trackInfo.getTrack(), this._trackInfo.getSelection().getCurrentPointIndex()));
            } else if (n == 36) {
                this._trackInfo.selectPoint(0);
            } else if (n == 35) {
                this._trackInfo.selectPoint(this._trackInfo.getTrack().getNumPoints() - 1);
            }
        } else {
            int n5 = 0;
            if (n == 38) {
                n5 = -20;
            } else if (n == 40) {
                n5 = 20;
            }
            int n6 = 0;
            if (n == 39) {
                n6 = 20;
            } else if (n == 37) {
                n6 = -20;
            }
            this.panMap(n6, n5);
            if (n == 27) {
                this._drawMode = 0;
            } else if (n == 8 && n2 >= 0) {
                this._app.deleteCurrentPoint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.panMap((mouseWheelEvent.getX() - this.getWidth() / 2) / 2, (mouseWheelEvent.getY() - this.getHeight() / 2) / 2);
            this.zoomIn();
        } else if (n > 0) {
            this.panMap(-(mouseWheelEvent.getX() - this.getWidth() / 2), -(mouseWheelEvent.getY() - this.getHeight() / 2));
            this.zoomOut();
        }
    }

    public MapPosition getMapPosition() {
        return this._mapPosition;
    }
}

