/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.config.Config;
import tim.prune.gui.map.DiskTileCacher;
import tim.prune.gui.map.MapCanvas;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.MemTileCacher;
import tim.prune.gui.map.TileDownloader;

public class MapTileManager
implements ImageObserver {
    private MapCanvas _parent = null;
    private MapSource _mapSource = null;
    private MemTileCacher[] _tempCaches = null;
    private int _numLayers = -1;
    private int _zoom = 0;
    private int _numTileIndices = 1;

    public MapTileManager(MapCanvas mapCanvas) {
        this._parent = mapCanvas;
        this.adjustSelectedMap();
        this.resetConfig();
    }

    public void centreMap(int n, int n2, int n3) {
        this._zoom = n;
        this._numTileIndices = 1 << this._zoom;
        if (this._tempCaches != null) {
            int n4 = 0;
            while (n4 < this._tempCaches.length) {
                this._tempCaches[n4].centreMap(n, n2, n3);
                ++n4;
            }
        }
    }

    public boolean isOverzoomed() {
        int n;
        int n2 = n = this._mapSource == null ? 0 : this._mapSource.getMaxZoomLevel();
        return this._zoom > n;
    }

    public void clearMemoryCaches() {
        int n = this._mapSource.getNumLayers();
        if (this._tempCaches == null || this._tempCaches.length != n) {
            this._tempCaches = new MemTileCacher[n];
            int n2 = 0;
            while (n2 < n) {
                this._tempCaches[n2] = new MemTileCacher();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                this._tempCaches[n3].clearAll();
                ++n3;
            }
        }
    }

    public void resetConfig() {
        int n = Config.getConfigInt("prune.mapsource");
        this._mapSource = MapSourceLibrary.getSource(n);
        if (this._mapSource == null) {
            this._mapSource = MapSourceLibrary.getSource(0);
        }
        this.clearMemoryCaches();
        this._numLayers = this._mapSource.getNumLayers();
    }

    private void adjustSelectedMap() {
        int n;
        int n2 = Config.getConfigInt("prune.mapsource");
        int n3 = Config.getConfigInt("prune.numfixedmapsources");
        if (n3 == 0) {
            n3 = 6;
        }
        if ((n = MapSourceLibrary.getNumFixedSources()) != n3 && (n2 >= n3 || n2 >= n)) {
            Config.setConfigInt("prune.mapsource", n2 += n - n3);
        }
        Config.setConfigInt("prune.numfixedmapsources", n);
    }

    public int getNumLayers() {
        return this._numLayers;
    }

    public Image getTile(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this._numTileIndices) {
            return null;
        }
        MemTileCacher memTileCacher = this._tempCaches[n];
        Image image = memTileCacher.getTile(n2 = (n2 % this._numTileIndices + this._numTileIndices) % this._numTileIndices, n3);
        if (image != null) {
            return image;
        }
        String string = Config.getConfigString("prune.diskcache");
        boolean bl = string != null;
        boolean bl2 = Config.getConfigBoolean("prune.onlinemode");
        if (bl && (image = DiskTileCacher.getTile(string, this._mapSource.makeFilePath(n, this._zoom, n2, n3), bl2)) != null) {
            memTileCacher.setTile(image, n2, n3, this._zoom);
            if (image.getWidth(this) > 0) {
                return image;
            }
            return null;
        }
        if (bl2) {
            try {
                URL uRL = new URL(this._mapSource.makeURL(n, this._zoom, n2, n3));
                if (!bl || !DiskTileCacher.saveTile(uRL, string, this._mapSource.makeFilePath(n, this._zoom, n2, n3), this)) {
                    TileDownloader.triggerLoad(this, uRL, n, n2, n3, this._zoom);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = (n & 0x20) > 0;
        boolean bl3 = bl = (n & 0x40) > 0;
        if (bl2 || bl) {
            this._parent.tilesUpdated(bl2);
        }
        return !bl2;
    }

    public void notifyImageLoaded(Image image, int n, int n2, int n3, int n4) {
        MemTileCacher memTileCacher;
        if (image != null && (memTileCacher = this._tempCaches[n]).getTile(n2, n3) == null) {
            memTileCacher.setTile(image, n2, n3, n4);
            image.getWidth(this);
        }
    }
}

