/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.util.regex.Matcher;
import tim.prune.I18nManager;
import tim.prune.gui.map.MapSource;

public class OsmMapSource
extends MapSource {
    private String _name = null;
    private String[] _baseUrls = null;
    private String[] _siteNames = null;
    private int _maxZoom = 0;

    public OsmMapSource(String string, String string2) {
        this(string, string2, "png", null, null, 18);
    }

    public OsmMapSource(String string, String string2, String string3, int n) {
        if (string3 != null && string3.length() == 3) {
            this.init(string, string2, string3, null, null, 18);
        } else {
            this.init(string, string2, "png", string3, "png", 18);
        }
    }

    public OsmMapSource(String string, String string2, String string3, String string4, String string5, int n) {
        this.init(string, string2, string3, string4, string5, n);
    }

    private void init(String string, String string2, String string3, String string4, String string5, int n) {
        this._name = string;
        if (this._name == null || this._name.trim().equals("")) {
            this._name = I18nManager.getText("mapsource.unknown");
        }
        this._baseUrls = new String[2];
        this._baseUrls[0] = OsmMapSource.fixBaseUrl(string2);
        this._baseUrls[1] = OsmMapSource.fixBaseUrl(string4);
        this._extensions = new String[2];
        this._extensions[0] = string3;
        this._extensions[1] = string5;
        this._siteNames = new String[2];
        this._siteNames[0] = OsmMapSource.fixSiteName(this._baseUrls[0]);
        this._siteNames[1] = OsmMapSource.fixSiteName(this._baseUrls[1]);
        if (this._baseUrls[0] == null && this._baseUrls[1] != null) {
            this._baseUrls[0] = this._baseUrls[1];
            this._siteNames[0] = this._siteNames[1];
            this._siteNames[1] = null;
            this._baseUrls[1] = null;
        }
        this._maxZoom = n;
    }

    public static OsmMapSource fromConfig(String string) {
        OsmMapSource osmMapSource = null;
        if (string.startsWith("o:")) {
            String[] stringArray = string.substring(2).split(";");
            try {
                if (stringArray.length == 3) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], null, Integer.parseInt(stringArray[2]));
                } else if (stringArray.length == 4) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
                } else if (stringArray.length == 6) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], Integer.parseInt(stringArray[5]));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return osmMapSource;
    }

    public String getName() {
        return this._name;
    }

    public int getNumLayers() {
        return this._baseUrls[1] == null ? 1 : 2;
    }

    public String getBaseUrl(int n) {
        return this._baseUrls[n];
    }

    public String getSiteName(int n) {
        return this._siteNames[n];
    }

    public String makeURL(int n, int n2, int n3, int n4) {
        return String.valueOf(OsmMapSource.pickServerUrl(this._baseUrls[n])) + n2 + "/" + n3 + "/" + n4 + "." + this.getFileExtension(n);
    }

    public final int getMaxZoomLevel() {
        return this._maxZoom;
    }

    protected static final String pickServerUrl(String string) {
        if (string == null || string.indexOf(91) < 0) {
            return string;
        }
        Matcher matcher = WILD_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(2);
        int n = string2.length();
        String string3 = null;
        if (n > 0) {
            int n2 = (int)Math.floor(Math.random() * (double)n);
            string3 = "" + string2.charAt(n2);
        }
        String string4 = String.valueOf(matcher.group(1)) + (string3 == null ? "" : string3) + matcher.group(3);
        return string4;
    }

    public String getConfigString() {
        return "o:" + this.getName() + ";" + this.getSiteStrings() + this.getMaxZoomLevel();
    }
}

