/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.SourceInfo;
import tim.prune.load.BabelLoader;

public class BabelLoadFromGps
extends BabelLoader {
    private JTextField _deviceField = null;
    private JTextField _formatField = null;

    public BabelLoadFromGps(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.loadfromgps";
    }

    protected String getFilePath() {
        return this._deviceField.getText();
    }

    protected SourceInfo getSourceInfo() {
        return new SourceInfo(this._deviceField.getText(), SourceInfo.FILE_TYPE.GPSBABEL);
    }

    protected String getInputFormat() {
        return this._formatField.getText();
    }

    protected boolean isInputOk() {
        return this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected();
    }

    protected JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(Config.getConfigString("prune.gpsdevice"), 12);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    BabelLoadFromGps.this._dialog.dispose();
                }
            }
        };
        this._deviceField.addKeyListener(keyAdapter);
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(Config.getConfigString("prune.gpsformat"), 12);
        this._formatField.addKeyListener(keyAdapter);
        jPanel3.add(this._formatField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BabelLoadFromGps.this.enableOkButton();
            }
        };
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.getwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.gettracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._saveCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.save"));
        this._saveCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._saveCheckbox);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BabelLoadFromGps.this._cancelled = false;
                new Thread(BabelLoadFromGps.this).start();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._deviceField.addActionListener(actionListener);
        this._formatField.addActionListener(actionListener);
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BabelLoadFromGps.this._cancelled = true;
                BabelLoadFromGps.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    protected void saveConfigValues() {
        String string = this._deviceField.getText().trim();
        String string2 = this._formatField.getText().trim();
        Config.setConfigString("prune.gpsdevice", string);
        Config.setConfigString("prune.gpsformat", string2);
    }
}

