/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.I18nManager;
import tim.prune.function.Cancellable;

public class MediaLoadProgressDialog {
    private JDialog _progressDialog = null;
    private JProgressBar _progressBar = null;
    private JFrame _parentFrame = null;
    private Cancellable _function = null;

    public MediaLoadProgressDialog(JFrame jFrame, Cancellable cancellable) {
        this._parentFrame = jFrame;
        this._function = cancellable;
    }

    private void createProgressDialog() {
        this._progressDialog = new JDialog((Frame)this._parentFrame, I18nManager.getText("dialog.jpegload.progress.title"));
        this._progressDialog.setLocationRelativeTo(this._parentFrame);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        this._progressBar.setString("");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel.add(new JLabel(I18nManager.getText("dialog.jpegload.progress")));
        jPanel.add(this._progressBar);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MediaLoadProgressDialog.this._function.cancel();
            }
        });
        jPanel.add(jButton);
        this._progressDialog.getContentPane().add(jPanel);
        this._progressDialog.pack();
        this._progressDialog.setVisible(true);
    }

    public void show() {
        if (this._progressDialog == null) {
            this.createProgressDialog();
            this._progressBar.setIndeterminate(true);
        }
    }

    public void showProgress(int n, int n2) {
        if (this._progressDialog == null) {
            this.createProgressDialog();
        }
        if (this._progressBar.isIndeterminate()) {
            this._progressBar.setIndeterminate(false);
        }
        if (n2 > 0) {
            this._progressBar.setMaximum(n2);
        }
        this._progressBar.setValue(n);
        this._progressBar.setString(n + " / " + this._progressBar.getMaximum());
    }

    public void close() {
        if (this._progressDialog != null) {
            this._progressDialog.dispose();
        }
    }
}

