/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.InputStream;
import tim.prune.save.xml.TagReceiver;

public class GpxSlicer {
    private TagReceiver _receiver = null;
    private StringBuilder _builder = null;
    private static final char[] GPX_START = "<gpx".toCharArray();
    private static final char[] GPX_END = ">".toCharArray();
    private static final char[] TRKPT_START = "<trkpt".toCharArray();
    private static final char[] TRKPT_END = "/trkpt>".toCharArray();
    private static final char[] WPT_START = "<wpt".toCharArray();
    private static final char[] WPT_END = "/wpt>".toCharArray();
    private static final char[] RTEPT_START = "<rtept".toCharArray();
    private static final char[] RTEPT_END = "/rtept>".toCharArray();
    private static final char[] CDATA_START = "<![CDATA[".toCharArray();
    private static final char[] CDATA_END = "]]>".toCharArray();

    public GpxSlicer(TagReceiver tagReceiver) {
        this._receiver = tagReceiver;
    }

    public void slice(InputStream inputStream) {
        this._builder = new StringBuilder(100);
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = null;
        boolean bl3 = false;
        int n = 0;
        try {
            while ((n = inputStream.read()) >= 0) {
                if (!bl && !bl2 && n == 60) {
                    this._builder.setLength(0);
                }
                this._builder.append((char)n);
                if (bl2) {
                    if (!this.foundSequence(CDATA_END)) continue;
                    bl2 = false;
                    continue;
                }
                if (!bl) {
                    if (!bl3 && this.foundSequence(GPX_START)) {
                        bl = true;
                        bl3 = true;
                        cArray = GPX_END;
                    } else if (n == 116) {
                        if (this.foundSequence(TRKPT_START)) {
                            bl = true;
                            cArray = TRKPT_END;
                        } else if (this.foundSequence(WPT_START)) {
                            bl = true;
                            cArray = WPT_END;
                        } else if (this.foundSequence(RTEPT_START)) {
                            bl = true;
                            cArray = RTEPT_END;
                        }
                    }
                } else if (this.foundSequence(cArray)) {
                    this._receiver.reportTag(this._builder.toString());
                    this._builder.setLength(0);
                    bl = false;
                }
                if (!this.foundSequence(CDATA_START)) continue;
                bl2 = true;
            }
        }
        catch (IOException iOException) {}
    }

    private boolean foundSequence(char[] cArray) {
        int n = cArray.length;
        int n2 = this._builder.length();
        if (n2 < n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n - 1 - n3];
            char c2 = this._builder.charAt(n2 - 1 - n3);
            if (c != c2) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

