/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;

public class RegisteredEventListeners {
    private final Set<CacheEventListener> cacheEventListeners = new CopyOnWriteArraySet<CacheEventListener>();
    private final Ehcache cache;
    private long elementsRemovedCounter;
    private long elementsPutCounter;
    private long elementsUpdatedCounter;
    private long elementsExpiredCounter;
    private long elementsEvictedCounter;
    private long elementsRemoveAllCounter;

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        ++this.elementsRemovedCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementRemoved(this.cache, element);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        ++this.elementsPutCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementPut(this.cache, element);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        ++this.elementsUpdatedCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementUpdated(this.cache, element);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        ++this.elementsExpiredCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementExpired(this.cache, element);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Element element, boolean remoteEvent) {
        ++this.elementsEvictedCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementEvicted(this.cache, element);
            }
        }
    }

    public void notifyRemoveAll(boolean remoteEvent) {
        ++this.elementsRemoveAllCounter;
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyRemoveAll(this.cache);
            }
        }
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    public final boolean registerListener(CacheEventListener cacheEventListener) {
        if (cacheEventListener == null) {
            return false;
        }
        return this.cacheEventListeners.add(cacheEventListener);
    }

    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        return this.cacheEventListeners.remove(cacheEventListener);
    }

    public final Set getCacheEventListeners() {
        return this.cacheEventListeners;
    }

    public final void dispose() {
        for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
            cacheEventListener.dispose();
        }
        this.cacheEventListeners.clear();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(" cacheEventListeners: ");
        for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
            stringBuffer.append(cacheEventListener.getClass().getName()).append(" ");
        }
        return stringBuffer.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter = 0L;
        this.elementsPutCounter = 0L;
        this.elementsUpdatedCounter = 0L;
        this.elementsExpiredCounter = 0L;
        this.elementsEvictedCounter = 0L;
        this.elementsRemoveAllCounter = 0L;
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter;
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter;
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter;
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter;
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter;
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter;
    }
}

