/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.management.sampled.SampledCacheMBean;

public class SampledCache
implements SampledCacheMBean {
    private final Ehcache cache;
    private final String immutableCacheName;

    public SampledCache(Ehcache cache) {
        this.cache = cache;
        this.immutableCacheName = cache.getName();
    }

    String getImmutableCacheName() {
        return this.immutableCacheName;
    }

    public void flush() {
        this.cache.flush();
    }

    public String getCacheName() {
        return this.cache.getName();
    }

    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public long getAverageGetTimeMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeMostRecentSample();
    }

    public long getCacheElementEvictedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementEvictedMostRecentSample();
    }

    public long getCacheElementExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementExpiredMostRecentSample();
    }

    public long getCacheElementPutMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementPutMostRecentSample();
    }

    public long getCacheElementRemovedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementRemovedMostRecentSample();
    }

    public long getCacheElementUpdatedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementUpdatedMostRecentSample();
    }

    public long getCacheHitInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitInMemoryMostRecentSample();
    }

    public long getCacheHitMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitMostRecentSample();
    }

    public long getCacheHitOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOnDiskMostRecentSample();
    }

    public long getCacheMissExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissExpiredMostRecentSample();
    }

    public long getCacheMissMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissMostRecentSample();
    }

    public long getCacheMissNotFoundMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissNotFoundMostRecentSample();
    }

    public int getStatisticsAccuracy() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracy();
    }

    public String getStatisticsAccuracyDescription() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracyDescription();
    }

    public void clearStatistics() {
        this.cache.clearStatistics();
    }

    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    public boolean isSampledStatisticsEnabled() {
        return this.cache.getSampledCacheStatistics().isSampledStatisticsEnabled();
    }

    public boolean isTerracottaClustered() {
        return this.cache.getCacheConfiguration().isTerracottaClustered();
    }

    public void enableStatistics() {
        this.cache.setStatisticsEnabled(true);
    }

    public void disableStatistics() {
        this.cache.setStatisticsEnabled(false);
    }

    public void enableSampledStatistics() {
        this.cache.setSampledStatisticsEnabled(true);
    }

    public void disableSampledStatistics() {
        this.cache.setSampledStatisticsEnabled(false);
    }

    public float getAverageGetTimeMillis() {
        return this.cache.getLiveCacheStatistics().getAverageGetTimeMillis();
    }

    public long getCacheHitCount() {
        return this.cache.getLiveCacheStatistics().getCacheHitCount();
    }

    public long getCacheMissCount() {
        return this.cache.getLiveCacheStatistics().getCacheMissCount();
    }

    public long getCacheMissCountExpired() {
        return this.cache.getLiveCacheStatistics().getCacheMissCountExpired();
    }

    public long getConfigDiskExpiryThreadIntervalSeconds() {
        return this.cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
    }

    public int getConfigMaxElementsInMemory() {
        return this.cache.getCacheConfiguration().getMaxElementsInMemory();
    }

    public int getConfigMaxElementsOnDisk() {
        return this.cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    public String getConfigMemoryStoreEvictionPolicy() {
        return this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString();
    }

    public long getConfigTimeToIdleSeconds() {
        return this.cache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    public long getConfigTimeToLiveSeconds() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    public long getEvictedCount() {
        return this.cache.getLiveCacheStatistics().getEvictedCount();
    }

    public long getExpiredCount() {
        return this.cache.getLiveCacheStatistics().getExpiredCount();
    }

    public long getInMemoryHitCount() {
        return this.cache.getLiveCacheStatistics().getInMemoryHitCount();
    }

    public long getInMemorySize() {
        return this.cache.getLiveCacheStatistics().getInMemorySize();
    }

    public long getOnDiskHitCount() {
        return this.cache.getLiveCacheStatistics().getOnDiskHitCount();
    }

    public long getOnDiskSize() {
        return this.cache.getLiveCacheStatistics().getOnDiskSize();
    }

    public long getPutCount() {
        return this.cache.getLiveCacheStatistics().getPutCount();
    }

    public long getRemovedCount() {
        return this.cache.getLiveCacheStatistics().getRemovedCount();
    }

    public long getSize() {
        return this.cache.getLiveCacheStatistics().getSize();
    }

    public long getUpdateCount() {
        return this.cache.getLiveCacheStatistics().getUpdateCount();
    }

    public boolean isConfigDiskPersistent() {
        return this.cache.getCacheConfiguration().isDiskPersistent();
    }

    public boolean isConfigEternal() {
        return this.cache.getCacheConfiguration().isEternal();
    }

    public boolean isConfigOverflowToDisk() {
        return this.cache.getCacheConfiguration().isOverflowToDisk();
    }

    public void dispose() {
    }
}

