/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import grails.util.Environment;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.cfg.DefaultGrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean
implements ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(ConfigurableLocalSessionFactoryBean.class);
    private ClassLoader classLoader = null;
    private GrailsApplication grailsApplication;
    private Class<?> configClass;
    private Class<?> currentSessionContextClass;

    public void setCurrentSessionContextClass(Class<?> currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public void setConfigClass(Class<?> configClass) {
        this.configClass = configClass;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    protected Configuration newConfiguration() {
        Object config;
        ClassLoader cl;
        ClassLoader classLoader = cl = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        if (this.configClass == null) {
            try {
                this.configClass = cl.loadClass("org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsAnnotationConfiguration");
            }
            catch (Throwable e) {
                this.configClass = DefaultGrailsDomainConfiguration.class;
            }
        }
        if ((config = BeanUtils.instantiateClass(this.configClass)) instanceof GrailsDomainConfiguration) {
            ((GrailsDomainConfiguration)config).setGrailsApplication(this.grailsApplication);
        }
        if (this.currentSessionContextClass != null) {
            ((Configuration)config).setProperty("hibernate.current_session_context_class", this.currentSessionContextClass.getName());
            this.setExposeTransactionAwareSessionFactory(false);
        }
        return (Configuration)config;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        try {
            return super.newSessionFactory(config);
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            if (this.isCacheConfigurationError(cause)) {
                LOG.fatal((Object)("There was an error configuring the Hibernate second level cache: " + this.getCauseMessage(e)));
                LOG.fatal((Object)"This is normally due to one of two reasons. Either you have incorrectly specified the cache provider class name in [DataSource.groovy] or you do not have the cache provider on your classpath (eg. runtime (\"net.sf.ehcache:ehcache:1.6.1\"))");
                if (Environment.isDevelopmentMode()) {
                    System.exit(1);
                }
            }
            throw e;
        }
    }

    private String getCauseMessage(HibernateException e) {
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause.getMessage();
    }

    private boolean isCacheConfigurationError(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause != null && cause instanceof CacheException;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    public void destroy() throws HibernateException {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Map classMetaData = this.getSessionFactory().getAllClassMetadata();
        for (Object o : classMetaData.values()) {
            ClassMetadata classMetadata = (ClassMetadata)o;
            Class mappedClass = classMetadata.getMappedClass(EntityMode.POJO);
            registry.removeMetaClass(mappedClass);
        }
        super.destroy();
    }
}

