/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.DefaultGrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Mappings;

public class GrailsAnnotationConfiguration
extends AnnotationConfiguration
implements GrailsDomainConfiguration {
    private static final Log LOG = LogFactory.getLog(GrailsAnnotationConfiguration.class);
    private static final long serialVersionUID = -7115087342689305517L;
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (!AnnotationDomainClassArtefactHandler.isJPADomainClass((Class)domainClass.getClazz())) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    public void setGrailsApplication(GrailsApplication application) {
        GrailsClass[] existingDomainClasses;
        this.grailsApplication = application;
        if (this.grailsApplication == null) {
            return;
        }
        for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
        ArtefactHandler handler = this.grailsApplication.getArtefactHandler("Domain");
        if (!(handler instanceof AnnotationDomainClassArtefactHandler)) {
            return;
        }
        Set jpaDomainNames = ((AnnotationDomainClassArtefactHandler)handler).getJpaClassNames();
        if (jpaDomainNames == null) {
            return;
        }
        ClassLoader loader = this.grailsApplication.getClassLoader();
        for (String jpaDomainName : jpaDomainNames) {
            try {
                this.addAnnotatedClass(loader.loadClass(jpaDomainName));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        if (this.grailsApplication != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[GrailsAnnotationConfiguration] Setting context class loader to Grails GroovyClassLoader");
            }
            Thread.currentThread().setContextClassLoader(this.grailsApplication.getClassLoader());
        }
        SessionFactory sessionFactory = super.buildSessionFactory();
        if (this.grailsApplication != null) {
            GrailsHibernateUtil.configureHibernateDomainClasses(sessionFactory, this.grailsApplication);
        }
        return sessionFactory;
    }

    protected void secondPassCompile() throws MappingException {
        if (!this.configLocked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsAnnotationConfiguration] [" + this.domainClasses.size() + "] Grails domain classes to bind to persistence runtime"));
            }
            DefaultGrailsDomainConfiguration.configureDomainBinder(this.grailsApplication, this.domainClasses);
            for (GrailsDomainClass domainClass : this.domainClasses) {
                String fullClassName = domainClass.getFullName();
                String hibernateConfig = fullClassName.replace('.', '/') + ".hbm.xml";
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader.getResource(hibernateConfig) != null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsAnnotationConfiguration] Binding persistent class [" + fullClassName + "]"));
                }
                Mappings mappings = super.createMappings();
                Mapping m = GrailsDomainBinder.getMapping(domainClass);
                mappings.setAutoImport(m == null || m.getAutoImport());
                GrailsDomainBinder.bindClass(domainClass, mappings);
            }
        }
        super.secondPassCompile();
        this.configLocked = true;
    }
}

