/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.wrapper.IDownload;

class Download
implements IDownload {
    private static final int PROGRESS_CHUNK = 20000;
    private static final int BUFFER_SIZE = 10000;

    Download() {
    }

    public void download(String address, File destination) throws Exception {
        if (destination.exists()) {
            return;
        }
        destination.getParentFile().mkdirs();
        this.downloadInternal(address, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(String address, File destination) throws Exception {
        OutputStream out = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = new URL(address);
            out = new BufferedOutputStream(new FileOutputStream(destination));
            URLConnection conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 20000L > 0L) {
                    System.out.print(".");
                    progressCounter -= 20000L;
                }
                out.write(buffer, 0, numRead);
            }
        }
        finally {
            System.out.println("");
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

