/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNGNUDiffGenerator
extends DefaultSVNDiffGenerator
implements ISVNGNUDiffGenerator {
    private String myHeader;
    private boolean myIsHeaderWritten;
    private FSRoot myOriginalRoot;
    private String myOriginalPath;
    private FSRoot myNewRoot;
    private String myNewPath;
    private boolean myIsDiffWritten;

    public void displayHeader(int type, String path, String copyFromPath, long copyFromRevision, OutputStream result) throws SVNException {
        switch (type) {
            case 0: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Added: " + path;
                break;
            }
            case 1: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Deleted: " + path;
                break;
            }
            case 2: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Modified: " + path;
                break;
            }
            case 3: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                copyFromPath = copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath;
                this.myHeader = "Copied: " + path + " (from rev " + copyFromRevision + ", " + copyFromPath + ")";
                break;
            }
            case 4: {
                try {
                    result.write(this.getEOL());
                    break;
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                }
            }
        }
    }

    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        CountingOutputStream counitngStream = new CountingOutputStream(result, 0L);
        super.displayFileDiff(path, file1, file2, rev1, rev2, mimeType1, mimeType2, counitngStream);
        if (counitngStream.getPosition() > 0L) {
            try {
                result.write(this.getEOL());
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
        }
        this.setDiffWritten(counitngStream.getPosition() > 0L);
    }

    public void setHeaderWritten(boolean written) {
        this.myIsHeaderWritten = written;
    }

    protected boolean displayHeader(OutputStream os, String path, boolean deleted) throws IOException {
        if (this.myHeader != null) {
            os.write(this.myHeader.getBytes(this.getEncoding()));
            os.write(this.getEOL());
            this.myHeader = null;
            this.myIsHeaderWritten = true;
        } else if (!this.myIsHeaderWritten) {
            path = path.startsWith("/") ? path.substring(1) : path;
            String header = "Index: " + path;
            os.write(header.getBytes(this.getEncoding()));
            os.write(this.getEOL());
            this.myIsHeaderWritten = true;
        }
        os.write(HEADER_SEPARATOR);
        os.write(this.getEOL());
        return false;
    }

    protected void displayBinary(OutputStream os, String mimeType1, String mimeType2) throws IOException {
        os.write("(Binary files differ)".getBytes(this.getEncoding()));
        os.write(this.getEOL());
    }

    protected void displayHeaderFields(OutputStream os, String label1, String label2) throws IOException {
        os.write("--- ".getBytes(this.getEncoding()));
        String originalLabel = null;
        String newLabel = null;
        try {
            originalLabel = this.generateLabel(this.myOriginalRoot, this.myOriginalPath);
            newLabel = this.generateLabel(this.myNewRoot, this.myNewPath);
        }
        catch (SVNException svne) {
            throw new IOException(svne.getLocalizedMessage());
        }
        os.write(originalLabel.getBytes(this.getEncoding()));
        os.write(this.getEOL());
        os.write("+++ ".getBytes(this.getEncoding()));
        os.write(newLabel.getBytes(this.getEncoding()));
        os.write(this.getEOL());
    }

    protected void setOriginalFile(FSRoot originalRoot, String originalPath) {
        this.myOriginalRoot = originalRoot;
        this.myOriginalPath = originalPath;
    }

    protected void setNewFile(FSRoot newRoot, String newPath) {
        this.myNewRoot = newRoot;
        this.myNewPath = newPath;
    }

    private String generateLabel(FSRoot root, String path) throws SVNException {
        String date = null;
        String txnName = null;
        long rev = 0L;
        if (root != null) {
            FSFS fsfs = root.getOwner();
            SVNProperties props = null;
            if (root instanceof FSRevisionRoot) {
                FSRevisionRoot revisionRoot = (FSRevisionRoot)root;
                rev = revisionRoot.getRevision();
                props = fsfs.getRevisionProperties(rev);
            } else {
                FSTransactionRoot txnRoot = (FSTransactionRoot)root;
                txnName = txnRoot.getTxnID();
                props = fsfs.getTransactionProperties(txnName);
            }
            date = props.getStringValue("svn:date");
        }
        String dateString = null;
        if (date != null) {
            int tInd = date.indexOf(84);
            dateString = date.substring(0, tInd) + " " + date.substring(tInd + 1, tInd + 9) + " UTC";
        } else {
            dateString = "                       ";
        }
        if (txnName != null) {
            return path + '\t' + dateString + " (txn " + txnName + ")";
        }
        return path + '\t' + dateString + " (rev " + rev + ")";
    }

    protected boolean useLocalFileSeparatorChar() {
        return false;
    }

    public void setDiffWritten(boolean b) {
        this.myIsDiffWritten = b;
    }

    public boolean isDiffWritten() {
        return this.myIsDiffWritten;
    }

    public void printHeader(OutputStream os) throws SVNException {
        if (this.myHeader != null) {
            try {
                this.displayHeader(os, null, false);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
        }
    }
}

