/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassMarshaller
implements ObjectMarshaller<XML> {
    private final boolean includeVersion;
    private ProxyHandler proxyHandler;

    public DomainClassMarshaller() {
        this.includeVersion = false;
    }

    public DomainClassMarshaller(boolean includeVersion) {
        this.includeVersion = includeVersion;
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler) {
        this(includeVersion);
        this.proxyHandler = proxyHandler;
    }

    @Override
    public boolean supports(Object object) {
        return ConverterUtil.isDomainClass(object.getClass());
    }

    @Override
    public void marshalObject(Object value, XML xml) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = ConverterUtil.getDomainClass(clazz.getName());
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        Object idValue = beanWrapper.getPropertyValue(id.getName());
        if (idValue != null) {
            xml.attribute("id", String.valueOf(idValue));
        }
        if (this.includeVersion) {
            Object versionValue = beanWrapper.getPropertyValue(domainClass.getVersion().getName());
            xml.attribute("version", String.valueOf(versionValue));
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            xml.startNode(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                xml.convertAnother(val);
            } else {
                Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
                if (this.isRenderDomainClassRelations()) {
                    if (referenceObject != null) {
                        if ((referenceObject = this.proxyHandler.unwrapIfProxy((Object)referenceObject)) instanceof SortedMap) {
                            referenceObject = new TreeMap(referenceObject);
                        } else if (referenceObject instanceof SortedSet) {
                            referenceObject = new TreeSet((SortedSet)((Object)referenceObject));
                        } else if (referenceObject instanceof Set) {
                            referenceObject = new HashSet((Set)((Object)referenceObject));
                        } else if (referenceObject instanceof Map) {
                            referenceObject = new HashMap(referenceObject);
                        } else if (referenceObject instanceof Collection) {
                            referenceObject = new ArrayList((Collection)((Object)referenceObject));
                        }
                        xml.convertAnother(referenceObject);
                    }
                } else if (referenceObject != null) {
                    GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
                    if (referencedDomainClass == null || property.isEmbedded() || GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                        xml.convertAnother(referenceObject);
                    } else if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                        this.asShortObject(referenceObject, xml, referencedDomainClass.getIdentifier(), referencedDomainClass);
                    } else {
                        GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
                        String refPropertyName = referencedDomainClass.getPropertyName();
                        if (referenceObject instanceof Collection) {
                            Collection o = (Collection)((Object)referenceObject);
                            for (Object e : o) {
                                xml.startNode(xml.getElementName(e));
                                this.asShortObject(e, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        } else if (referenceObject instanceof Map) {
                            Map map = referenceObject;
                            for (Map.Entry entry : map.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                Object o = entry.getValue();
                                xml.startNode("entry").attribute("key", key);
                                this.asShortObject(o, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        }
                    }
                }
            }
            xml.end();
        }
    }

    protected void asShortObject(Object refObj, XML xml, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        Object idValue = new BeanWrapperImpl(refObj).getPropertyValue(idProperty.getName());
        xml.attribute("id", String.valueOf(idValue));
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

