/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.GroovyObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.taglib.NamespacedTagDispatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagLibraryLookup
implements ApplicationContextAware,
GrailsApplicationAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private GrailsApplication grailsApplication;
    private Map<String, String> tagLibraries = new HashMap<String, String>();
    private Map<String, NamespacedTagDispatcher> namespaceDispatchers = new HashMap<String, NamespacedTagDispatcher>();
    private Set<String> tagsThatReturnObject = new HashSet<String>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void afterPropertiesSet() throws Exception {
        GrailsClass[] taglibs;
        if (this.grailsApplication == null || this.applicationContext == null) {
            return;
        }
        for (GrailsClass grailsClass : taglibs = this.grailsApplication.getArtefacts("TagLib")) {
            this.registerTagLib((GrailsTagLibClass)grailsClass);
        }
        this.namespaceDispatchers.put("tmpl", new NamespacedTagDispatcher("g", GroovyPage.class, this.grailsApplication, this){

            public Object invokeMethod(final String name, Object args) {
                Object[] tagArgs;
                HashMap<String, Object> attrs = new HashMap<String, Object>(){
                    {
                        this.put("template", name);
                    }
                };
                if (args != null && args instanceof Object[] && (tagArgs = (Object[])args).length > 0 && tagArgs[0] instanceof Map) {
                    attrs.put("model", tagArgs[0]);
                }
                return super.invokeMethod("render", new Object[]{attrs});
            }
        });
    }

    public void registerTagLib(GrailsTagLibClass taglib) {
        String nameKey;
        String namespace = taglib.getNamespace();
        this.namespaceDispatchers.put(namespace, new NamespacedTagDispatcher(namespace, GroovyPage.class, this.grailsApplication, this));
        for (String tagName : taglib.getTagNames()) {
            nameKey = this.tagNameKey(namespace, tagName);
            this.tagLibraries.put(nameKey, taglib.getFullName());
            this.tagsThatReturnObject.remove(nameKey);
        }
        for (String tagName : taglib.getTagNamesThatReturnObject()) {
            nameKey = this.tagNameKey(namespace, tagName);
            this.tagsThatReturnObject.add(nameKey);
        }
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        String fullName = this.tagLibraries.get(this.tagNameKey(namespace, tagName));
        if (fullName != null) {
            return (GroovyObject)this.applicationContext.getBean(fullName);
        }
        return null;
    }

    private String tagNameKey(String namespace, String tagName) {
        return namespace + ':' + tagName;
    }

    public boolean doesTagReturnObject(String namespace, String tagName) {
        return this.tagsThatReturnObject.contains(this.tagNameKey(namespace, tagName));
    }

    public NamespacedTagDispatcher lookupNamespaceDispatcher(String namespace) {
        return this.namespaceDispatchers.get(namespace);
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceDispatchers.containsKey(namespace);
    }

    public Set<String> getAvailableNamespaces() {
        return this.namespaceDispatchers.keySet();
    }
}

