/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;
import jsr166y.forkjoin.PoolBarrier;
import jsr166y.forkjoin.RunState;
import jsr166y.forkjoin.Submission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinPool
implements ForkJoinExecutor {
    private static final DefaultForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    private final ForkJoinWorkerThreadFactory factory;
    private volatile ForkJoinWorkerThread[] workers;
    private final ReentrantLock workerLock;
    private final Condition termination;
    volatile int poolSize;
    private int runningWorkers;
    private final SubmissionQueue submissionQueue;
    private final RunState runState;
    private final PoolBarrier poolBarrier;
    private final AtomicInteger runningSubmissions;
    private final AtomicInteger activeWorkerCounter;
    private Thread.UncaughtExceptionHandler ueh;
    private final int poolNumber;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private ForkJoinWorkerThread createWorker(int index) {
        ForkJoinWorkerThread w = this.factory.newThread(this);
        w.setDaemon(true);
        w.setWorkerPoolIndex(index);
        w.setName("ForkJoinPool-" + this.poolNumber + "-worker-" + index);
        Thread.UncaughtExceptionHandler h = this.ueh;
        if (h != null) {
            w.setUncaughtExceptionHandler(h);
        }
        this.activeWorkerCounter.incrementAndGet();
        return w;
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(int poolSize) {
        this(poolSize, defaultForkJoinWorkerThreadFactory);
    }

    public ForkJoinPool(ForkJoinWorkerThreadFactory factory) {
        this(Runtime.getRuntime().availableProcessors(), factory);
    }

    public ForkJoinPool(int poolSize, ForkJoinWorkerThreadFactory factory) {
        ForkJoinPool.checkPermission();
        if (poolSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        this.poolSize = poolSize;
        this.factory = factory;
        this.poolNumber = poolNumberGenerator.incrementAndGet();
        this.workers = new ForkJoinWorkerThread[poolSize];
        this.poolBarrier = new PoolBarrier();
        this.activeWorkerCounter = new AtomicInteger();
        this.runningSubmissions = new AtomicInteger();
        this.submissionQueue = new SubmissionQueue();
        this.runState = new RunState();
        this.workerLock = new ReentrantLock();
        this.termination = this.workerLock.newCondition();
        this.createAndStartWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndStartWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            int i;
            ForkJoinWorkerThread[] ws = this.workers;
            for (i = 0; i < ws.length; ++i) {
                ws[i] = this.createWorker(i);
            }
            for (i = 0; i < ws.length; ++i) {
                ws[i].start();
                ++this.runningWorkers;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T> T invoke(ForkJoinTask<T> task) {
        return this.doSubmit(task).awaitInvoke();
    }

    @Override
    public <T> Future<T> submit(ForkJoinTask<T> task) {
        return this.doSubmit(task);
    }

    @Override
    public <T> void execute(ForkJoinTask<T> task) {
        this.doSubmit(task);
    }

    private <T> Submission<T> doSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.runState.isAtLeastShutdown()) {
            throw new RejectedExecutionException();
        }
        Submission<T> job = new Submission<T>(task, this);
        this.submissionQueue.add(job);
        this.poolBarrier.poolSignal();
        return job;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getParallelismLevel() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningWorkerCount() {
        int r;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            r = this.runningWorkers;
        }
        finally {
            lock.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler h) {
        ForkJoinPool.checkPermission();
        Thread.UncaughtExceptionHandler old = null;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            old = this.ueh;
            this.ueh = h;
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread w = ws[i];
                if (w == null) continue;
                w.setUncaughtExceptionHandler(h);
            }
        }
        finally {
            lock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler h;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            h = this.ueh;
        }
        finally {
            lock.unlock();
        }
        return h;
    }

    private void broadcastPoolSize() {
        int ps = this.poolSize;
        ForkJoinWorkerThread[] ws = this.workers;
        for (int i = 0; i < ws.length; ++i) {
            ForkJoinWorkerThread w = ws[i];
            if (w == null) continue;
            w.setPoolSize(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWorkers(int numberToAdd) {
        int nadded = 0;
        ForkJoinPool.checkPermission();
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            if (!this.runState.isAtLeastStopping()) {
                int i;
                ForkJoinWorkerThread[] ws = this.workers;
                int len = ws.length;
                int newLen = len + numberToAdd;
                ForkJoinWorkerThread[] nws = new ForkJoinWorkerThread[newLen];
                System.arraycopy(ws, 0, nws, 0, len);
                for (i = len; i < newLen; ++i) {
                    nws[i] = this.createWorker(i);
                }
                this.workers = nws;
                for (i = len; i < newLen; ++i) {
                    nws[i].start();
                    ++this.runningWorkers;
                }
                this.poolSize += numberToAdd;
                nadded = numberToAdd;
            }
        }
        finally {
            lock.unlock();
        }
        this.broadcastPoolSize();
        return nadded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeWorkers(int numberToRemove) {
        int nremoved = 0;
        ForkJoinPool.checkPermission();
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            int k = ws.length;
            while (!this.runState.isAtLeastStopping() && --k > 0 && nremoved < numberToRemove) {
                RunState rs;
                ForkJoinWorkerThread w = ws[k];
                if (w == null || !(rs = w.getRunState()).transitionToShutdown()) continue;
                --this.poolSize;
                ++nremoved;
            }
        }
        finally {
            lock.unlock();
        }
        this.broadcastPoolSize();
        return nremoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPoolSize(int newSize) {
        ForkJoinPool.checkPermission();
        if (newSize <= 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            int ps = this.poolSize;
            if (newSize > ps) {
                this.addWorkers(newSize - ps);
            } else if (newSize < ps) {
                this.removeWorkers(ps - newSize);
            }
        }
        finally {
            lock.unlock();
        }
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void workerTerminated(ForkJoinWorkerThread w, Throwable ex) {
        try {
            ReentrantLock lock = this.workerLock;
            lock.lock();
            try {
                if (!this.runState.isAtLeastStopping()) {
                    int idx = w.getWorkerPoolIndex();
                    ForkJoinWorkerThread[] ws = this.workers;
                    int len = ws.length;
                    if (idx >= 0 && idx < len && ws[idx] == w) {
                        int newlen;
                        ws[idx] = null;
                        for (newlen = len; newlen > 0 && ws[newlen - 1] == null; --newlen) {
                        }
                        if (newlen < len) {
                            ForkJoinWorkerThread[] nws = new ForkJoinWorkerThread[newlen];
                            System.arraycopy(ws, 0, nws, 0, newlen);
                            this.workers = nws;
                            this.poolBarrier.signal();
                        }
                    }
                }
                if (--this.runningWorkers == 0) {
                    this.terminate();
                    this.runState.transitionToTerminated();
                    this.termination.signalAll();
                }
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            if (ex != null) {
                ForkJoinTask.rethrowException(ex);
            }
        }
    }

    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.runState.transitionToShutdown();
        this.tryTerminateOnShutdown();
    }

    public void shutdownNow() {
        ForkJoinPool.checkPermission();
        this.terminate();
    }

    public boolean isShutdown() {
        return this.runState.isAtLeastShutdown();
    }

    public boolean isTerminated() {
        return this.runState.isTerminated();
    }

    public boolean isTerminating() {
        return this.runState.isStopping();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            while (true) {
                if (this.runState.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void terminate() {
        if (this.runState.transitionToStopping()) {
            this.stopAllWorkers();
            this.cancelQueuedSubmissions();
            this.cancelQueuedWorkerTasks();
            this.interruptUnterminatedWorkers();
        }
    }

    private void tryTerminateOnShutdown() {
        if (this.runState.isAtLeastShutdown() && this.runningSubmissions.get() == 0 && this.submissionQueue.isEmpty() && this.runningSubmissions.get() == 0) {
            this.terminate();
        }
    }

    private void cancelQueuedSubmissions() {
        Submission<?> task;
        while (!this.submissionQueue.isEmpty() && (task = this.submissionQueue.poll()) != null) {
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueuedWorkerTasks() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                t.cancelTasks();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinWorkerThread t = ws[i];
                if (t == null) continue;
                RunState rs = t.getRunState();
                rs.transitionToStopping();
            }
        }
        finally {
            lock.unlock();
        }
        this.poolBarrier.poolSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptUnterminatedWorkers() {
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            for (int i = 0; i < ws.length; ++i) {
                RunState rs;
                ForkJoinWorkerThread t = ws[i];
                if (t == null || (rs = t.getRunState()).isTerminated()) continue;
                try {
                    t.interrupt();
                    continue;
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean isQuiescent() {
        return this.activeWorkerCounter.get() == 0;
    }

    public int getActiveThreadCount() {
        return this.activeWorkerCounter.get();
    }

    public int getIdleThreadCount() {
        return this.poolSize - this.activeWorkerCounter.get();
    }

    public long getStealCount() {
        long sum = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        for (int i = 0; i < ws.length; ++i) {
            ForkJoinWorkerThread t = ws[i];
            if (t == null) continue;
            sum += t.getWorkerStealCount();
        }
        return sum;
    }

    public long getTotalPerThreadQueueSize() {
        long count = 0L;
        ForkJoinWorkerThread[] ws = this.workers;
        for (int i = 0; i < ws.length; ++i) {
            ForkJoinWorkerThread t = ws[i];
            if (t == null) continue;
            count += (long)t.getQueueSize();
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    public int getActiveSubmissionCount() {
        return this.runningSubmissions.get();
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    final ForkJoinWorkerThread[] getWorkers() {
        return this.workers;
    }

    final SubmissionQueue getSubmissionQueue() {
        return this.submissionQueue;
    }

    final AtomicInteger getActiveWorkerCounter() {
        return this.activeWorkerCounter;
    }

    final PoolBarrier getPoolBarrier() {
        return this.poolBarrier;
    }

    final void submissionStarting() {
        this.runningSubmissions.incrementAndGet();
    }

    final void submissionCompleted() {
        if (this.runningSubmissions.decrementAndGet() == 0 && this.runState.isAtLeastShutdown()) {
            this.tryTerminateOnShutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubmissionQueue {
        private volatile SQNode head;
        private volatile SQNode tail;
        private static final AtomicReferenceFieldUpdater<SubmissionQueue, SQNode> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(SubmissionQueue.class, SQNode.class, "tail");
        private static final AtomicReferenceFieldUpdater<SubmissionQueue, SQNode> headUpdater = AtomicReferenceFieldUpdater.newUpdater(SubmissionQueue.class, SQNode.class, "head");

        SubmissionQueue() {
            SQNode dummy;
            this.head = dummy = new SQNode(null);
            this.tail = dummy;
        }

        private boolean casTail(SQNode cmp, SQNode val) {
            return tailUpdater.compareAndSet(this, cmp, val);
        }

        private boolean casHead(SQNode cmp, SQNode val) {
            return headUpdater.compareAndSet(this, cmp, val);
        }

        boolean isApparentlyNonEmpty() {
            SQNode h = this.head;
            SQNode t = this.tail;
            return h != t;
        }

        boolean isEmpty() {
            while (true) {
                SQNode h = this.head;
                SQNode t = this.tail;
                SQNode f = (SQNode)h.get();
                if (h != this.head) continue;
                if (f == null) {
                    return true;
                }
                if (h != t) {
                    return false;
                }
                this.casTail(t, f);
            }
        }

        void add(Submission<?> x) {
            SQNode t;
            SQNode n = new SQNode(x);
            while (true) {
                t = this.tail;
                SQNode s = (SQNode)t.get();
                if (t != this.tail) continue;
                if (s != null) {
                    this.casTail(t, s);
                    continue;
                }
                if (t.compareAndSet(s, n)) break;
            }
            this.casTail(t, n);
        }

        Submission<?> poll() {
            SQNode f;
            while (true) {
                SQNode h = this.head;
                SQNode t = this.tail;
                f = (SQNode)h.get();
                if (h != this.head) continue;
                if (f == null) {
                    return null;
                }
                if (h == t) {
                    this.casTail(t, f);
                    continue;
                }
                if (this.casHead(h, f)) break;
            }
            Submission<?> x = f.submission;
            f.submission = null;
            x.setStolen();
            return x;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class SQNode
        extends AtomicReference<SQNode> {
            Submission<?> submission;

            SQNode(Submission<?> s) {
                this.submission = s;
            }
        }
    }

    public static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

