/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.commons.AbstractInjectableGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.springframework.util.AntPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsControllerClass
extends AbstractInjectableGrailsClass
implements GrailsControllerClass {
    public static final String CONTROLLER = "Controller";
    private static final String SLASH = "/";
    private static final String DEFAULT_CLOSURE_PROPERTY = "defaultAction";
    private static final String ALLOWED_HTTP_METHODS_PROPERTY = "allowedMethods";
    private static final String EXCEPT = "except";
    private static final String ONLY = "only";
    private static final String FLOW_SUFFIX = "Flow";
    private static final String ACTION = "action";
    private Map<String, String> uri2viewMap = new HashMap<String, String>();
    private Map<String, String> uri2closureMap = new HashMap<String, String>();
    private Map<String, String> viewNames = new HashMap<String, String>();
    private String[] uris;
    private String uri;
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private final Set commandObjectActions = new HashSet();
    private final Set commandObjectClasses = new HashSet();
    private Map<String, PropertyDescriptor> flows = new HashMap<String, PropertyDescriptor>();
    private String defaultActionName;
    private String controllerPath;

    @Override
    public void setDefaultActionName(String defaultActionName) {
        this.defaultActionName = defaultActionName;
        this.configureDefaultActionIfSet();
        this.configureURIsForCurrentState();
    }

    public DefaultGrailsControllerClass(Class<?> clazz) {
        super(clazz, CONTROLLER);
        this.uri = SLASH + GrailsNameUtils.getPropertyNameRepresentation((String)this.getName());
        this.defaultActionName = this.getStaticPropertyValue(DEFAULT_CLOSURE_PROPERTY, String.class);
        if (this.defaultActionName == null) {
            this.defaultActionName = "index";
        }
        ArrayList<String> closureNames = new ArrayList<String>();
        this.controllerPath = this.uri + SLASH;
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            Class<?> propertyType;
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null || Modifier.isStatic(readMethod.getModifiers()) || (propertyType = propertyDescriptor.getPropertyType()) != Object.class && propertyType != Closure.class) continue;
            String closureName = propertyDescriptor.getName();
            if (closureName.endsWith(FLOW_SUFFIX)) {
                String flowId = closureName.substring(0, closureName.length() - FLOW_SUFFIX.length());
                this.flows.put(flowId, propertyDescriptor);
                closureName = flowId;
            }
            closureNames.add(closureName);
            this.configureMappingForClosureProperty(closureName);
        }
        if (!this.isReadableProperty(this.defaultActionName) && closureNames.size() == 1) {
            this.defaultActionName = (String)closureNames.iterator().next();
        }
        this.configureDefaultActionIfSet();
        this.configureURIsForCurrentState();
    }

    private void configureURIsForCurrentState() {
        this.uris = this.uri2closureMap.keySet().toArray(new String[this.uri2closureMap.keySet().size()]);
    }

    private void configureDefaultActionIfSet() {
        if (this.defaultActionName == null) {
            return;
        }
        this.uri2closureMap.put(this.uri, this.defaultActionName);
        this.uri2closureMap.put(this.controllerPath, this.defaultActionName);
        this.uri2viewMap.put(this.controllerPath, this.controllerPath + this.defaultActionName);
        this.uri2viewMap.put(this.uri, this.controllerPath + this.defaultActionName);
        this.viewNames.put(this.defaultActionName, this.controllerPath + this.defaultActionName);
    }

    private void configureMappingForClosureProperty(String closureName) {
        String tmpUri = this.controllerPath + closureName;
        this.uri2closureMap.put(tmpUri, closureName);
        this.uri2closureMap.put(tmpUri + SLASH + "**", closureName);
        this.uri2viewMap.put(tmpUri, tmpUri);
        this.viewNames.put(closureName, tmpUri);
    }

    @Override
    public String[] getURIs() {
        return this.uris;
    }

    @Override
    public boolean mapsToURI(String uri) {
        for (int i = 0; i < this.uris.length; ++i) {
            if (!this.pathMatcher.match(this.uris[i], uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getViewByURI(String uri) {
        return this.uri2viewMap.get(uri);
    }

    @Override
    public String getClosurePropertyName(String uri) {
        return this.uri2closureMap.get(uri);
    }

    @Override
    public String getViewByName(String viewName) {
        if (this.viewNames.containsKey(viewName)) {
            return this.viewNames.get(viewName);
        }
        return this.uri + SLASH + viewName;
    }

    @Override
    public boolean isInterceptedBefore(GroovyObject controller, String action) {
        return controller.getMetaClass().hasProperty((Object)controller, "beforeInterceptor") != null && this.isIntercepted(controller.getProperty("beforeInterceptor"), action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIntercepted(Object bip, String action) {
        if (bip instanceof Map) {
            Map bipMap = (Map)bip;
            if (bipMap.containsKey(EXCEPT)) {
                Object excepts = bipMap.get(EXCEPT);
                if (!(excepts instanceof String ? !excepts.equals(action) : excepts instanceof List && !((List)excepts).contains(action))) return false;
                return true;
            }
            if (!bipMap.containsKey(ONLY)) return true;
            Object onlys = bipMap.get(ONLY);
            if (!(onlys instanceof String ? onlys.equals(action) : onlys instanceof List && ((List)onlys).contains(action))) return false;
            return true;
        }
        if (!(bip instanceof Closure)) return false;
        return true;
    }

    @Override
    public boolean isHttpMethodAllowedForAction(GroovyObject controller, String httpMethod, String actionName) {
        boolean isAllowed = true;
        Object methodRestrictionsProperty = null;
        MetaProperty metaProp = controller.getMetaClass().getMetaProperty(ALLOWED_HTTP_METHODS_PROPERTY);
        if (metaProp != null) {
            methodRestrictionsProperty = metaProp.getProperty((Object)controller);
        }
        if (methodRestrictionsProperty instanceof Map) {
            Map map = (Map)methodRestrictionsProperty;
            Object value = map.get(actionName);
            if (value instanceof List) {
                List listOfMethods = (List)value;
                isAllowed = listOfMethods.contains(httpMethod);
            } else if (value instanceof String) {
                isAllowed = value.equals(httpMethod);
            }
        }
        return isAllowed;
    }

    @Override
    public boolean isInterceptedAfter(GroovyObject controller, String action) {
        return controller.getMetaClass().hasProperty((Object)controller, "afterInterceptor") != null && this.isIntercepted(controller.getProperty("afterInterceptor"), action);
    }

    @Override
    public Closure getBeforeInterceptor(GroovyObject controller) {
        if (this.isReadableProperty("beforeInterceptor")) {
            return this.getInterceptor(controller.getProperty("beforeInterceptor"));
        }
        return null;
    }

    @Override
    public Closure getAfterInterceptor(GroovyObject controller) {
        if (this.isReadableProperty("afterInterceptor")) {
            return this.getInterceptor(controller.getProperty("afterInterceptor"));
        }
        return null;
    }

    private Closure getInterceptor(Object ip) {
        if (ip instanceof Map) {
            Map ipMap = (Map)ip;
            if (ipMap.containsKey(ACTION)) {
                return (Closure)ipMap.get(ACTION);
            }
        } else if (ip instanceof Closure) {
            return (Closure)ip;
        }
        return null;
    }

    @Override
    @Deprecated
    public Set getCommandObjectActions() {
        return this.commandObjectActions;
    }

    @Override
    @Deprecated
    public Set getCommandObjectClasses() {
        return Collections.unmodifiableSet(this.commandObjectClasses);
    }

    @Override
    public Map<String, Closure> getFlows() {
        HashMap<String, Closure> closureFlows = new HashMap<String, Closure>();
        for (String name : this.flows.keySet()) {
            Closure c = this.getPropertyValue(name + FLOW_SUFFIX, Closure.class);
            if (c == null) continue;
            closureFlows.put(name, c);
        }
        return closureFlows;
    }

    @Override
    public boolean isFlowAction(String actionName) {
        return this.flows.containsKey(actionName);
    }

    @Override
    public String getDefaultAction() {
        return this.defaultActionName;
    }

    @Override
    public void registerMapping(String actionName) {
        this.configureMappingForClosureProperty(actionName);
        this.configureURIsForCurrentState();
    }
}

