/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata
extends Properties {
    private static final long serialVersionUID = -582452926111226898L;
    public static final String FILE = "application.properties";
    public static final String APPLICATION_VERSION = "app.version";
    public static final String APPLICATION_NAME = "app.name";
    public static final String APPLICATION_GRAILS_VERSION = "app.grails.version";
    public static final String SERVLET_VERSION = "app.servlet.version";
    public static final String WAR_DEPLOYED = "grails.war.deployed";
    public static final String DEFAULT_SERVLET_VERSION = "2.4";
    private static Reference<Metadata> metadata = new SoftReference<Metadata>(new Metadata());
    private boolean initialized;
    private File metadataFile;

    private Metadata() {
    }

    private Metadata(File f) {
        this.metadataFile = f;
    }

    public static void reset() {
        Metadata m = metadata.get();
        if (m != null) {
            m.clear();
            m.initialized = false;
        }
    }

    public static Metadata getCurrent() {
        Metadata m = metadata.get();
        if (m == null) {
            metadata = new SoftReference<Metadata>(new Metadata());
            m = metadata.get();
        }
        if (!m.initialized) {
            InputStream input;
            block7: {
                input = null;
                try {
                    input = Thread.currentThread().getContextClassLoader().getResourceAsStream(FILE);
                    if (input == null) {
                        input = Metadata.class.getClassLoader().getResourceAsStream(FILE);
                    }
                    if (input == null) break block7;
                    m.load(input);
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        Metadata.closeQuietly(input);
                        m.initialized = true;
                        throw throwable;
                    }
                }
            }
            Metadata.closeQuietly(input);
            m.initialized = true;
        }
        return m;
    }

    public static Metadata getInstance(InputStream inputStream) {
        Metadata m = new Metadata();
        metadata = new FinalReference<Metadata>(m);
        try {
            m.load(inputStream);
            m.initialized = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
        }
        return m;
    }

    public static Metadata getInstance(File file) {
        Metadata m = new Metadata(file);
        metadata = new FinalReference<Metadata>(m);
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                m.load(input);
                m.initialized = true;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Cannot load application metadata:" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(input);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(input);
        }
        return m;
    }

    public static Metadata reload() {
        File f = Metadata.getCurrent().metadataFile;
        if (f != null) {
            return Metadata.getInstance(f);
        }
        return Metadata.getCurrent();
    }

    public String getApplicationVersion() {
        return (String)this.get(APPLICATION_VERSION);
    }

    public String getGrailsVersion() {
        return (String)this.get(APPLICATION_GRAILS_VERSION);
    }

    public String getEnvironment() {
        return (String)this.get(Environment.KEY);
    }

    public String getApplicationName() {
        return (String)this.get(APPLICATION_NAME);
    }

    public Map<String, String> getInstalledPlugins() {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            if (!key.startsWith("plugins.") || val == null) continue;
            newMap.put(key.substring(8), val.toString());
        }
        return newMap;
    }

    public String getServletVersion() {
        String servletVersion = (String)this.get(SERVLET_VERSION);
        if (servletVersion == null) {
            return DEFAULT_SERVLET_VERSION;
        }
        return servletVersion;
    }

    public void persist() {
        if (this.propertiesHaveNotChanged()) {
            return;
        }
        if (this.metadataFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.metadataFile);
                this.store(out, "Grails Metadata file");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Error persisting metadata to file [" + this.metadataFile + "]: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Metadata.closeQuietly(out);
                    throw throwable;
                }
            }
            Metadata.closeQuietly(out);
        }
    }

    public boolean propertiesHaveNotChanged() {
        Metadata transientMetadata = Metadata.getCurrent();
        Metadata allStringValuesMetadata = new Metadata();
        Metadata transientMap = transientMetadata;
        for (Map.Entry entry : transientMap.entrySet()) {
            if (entry.getValue() == null) continue;
            allStringValuesMetadata.put(entry.getKey().toString(), entry.getValue().toString());
        }
        Metadata persistedMetadata = Metadata.reload();
        boolean result = allStringValuesMetadata.equals(persistedMetadata);
        metadata = new SoftReference<Metadata>(transientMetadata);
        return result;
    }

    @Override
    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    public boolean isWarDeployed() {
        Object val = this.get(WAR_DEPLOYED);
        return val != null && val.equals("true");
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FinalReference<T>
    extends SoftReference<T> {
        private T ref;

        public FinalReference(T t) {
            super(t);
            this.ref = t;
        }

        @Override
        public T get() {
            return this.ref;
        }
    }
}

