/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.spring.BeanBuilder;
import grails.util.GrailsUtil;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.DefaultRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.GrailsApplicationContext;
import org.codehaus.groovy.grails.commons.spring.GrailsContextEvent;
import org.codehaus.groovy.grails.commons.spring.ReloadAwareAutowireCapableBeanFactory;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.WebRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.ConfigurableLocalSessionFactoryBean;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

public class GrailsRuntimeConfigurator
implements ApplicationContextAware {
    public static final String BEAN_ID = "grailsConfigurator";
    public static final String GRAILS_URL_MAPPINGS = "grailsUrlMappings";
    public static final String SPRING_RESOURCES_XML = "/WEB-INF/spring/resources.xml";
    public static final String SPRING_RESOURCES_GROOVY = "/WEB-INF/spring/resources.groovy";
    public static final String SPRING_RESOURCES_CLASS = "resources";
    public static final String OPEN_SESSION_IN_VIEW_INTERCEPTOR_BEAN = "openSessionInViewInterceptor";
    public static final String TRANSACTION_MANAGER_BEAN = "transactionManager";
    public static final String HIBERNATE_PROPERTIES_BEAN = "hibernateProperties";
    public static final String DIALECT_DETECTOR_BEAN = "dialectDetector";
    public static final String SESSION_FACTORY_BEAN = "sessionFactory";
    public static final String DATA_SOURCE_BEAN = "dataSource";
    public static final String MESSAGE_SOURCE_BEAN = "messageSource";
    public static final String MULTIPART_RESOLVER_BEAN = "multipartResolver";
    public static final String EXCEPTION_HANDLER_BEAN = "exceptionHandler";
    public static final String CUSTOM_EDITORS_BEAN = "customEditors";
    public static final String CLASS_EDITOR_BEAN = "classEditor";
    public static final String CLASS_LOADER_BEAN = "classLoader";
    private static final Log LOG = LogFactory.getLog(GrailsRuntimeConfigurator.class);
    private GrailsApplication application;
    private ApplicationContext parent;
    private GrailsPluginManager pluginManager;
    private static final String DEVELOPMENT_SPRING_RESOURCES_XML = "file:./grails-app/conf/spring/resources.xml";
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    public GrailsRuntimeConfigurator(GrailsApplication application) {
        this(application, null);
    }

    public GrailsRuntimeConfigurator(GrailsApplication application, ApplicationContext parent) {
        this.application = application;
        this.parent = parent;
        if (parent != null) {
            parent.containsBean(DATA_SOURCE_BEAN);
        }
        this.pluginManager = PluginManagerHolder.getPluginManager();
        if (this.pluginManager == null) {
            this.pluginManager = new DefaultGrailsPluginManager("**/plugins/*/**GrailsPlugin.groovy", application);
            PluginManagerHolder.setPluginManager((GrailsPluginManager)this.pluginManager);
        } else {
            LOG.debug((Object)"Retrieved thread-bound PluginManager instance");
            this.pluginManager.setApplication(application);
        }
    }

    public WebApplicationContext configure() {
        return this.configure(null);
    }

    public WebApplicationContext configure(ServletContext context) {
        return this.configure(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApplicationContext configure(ServletContext context, boolean loadExternalBeans) {
        WebApplicationContext ctx;
        Assert.notNull((Object)this.application);
        try {
            WebRuntimeSpringConfiguration springConfig = this.createWebRuntimeSpringConfiguration(this.application, this.parent, this.application.getClassLoader());
            springConfig.setBeanFactory((ListableBeanFactory)new ReloadAwareAutowireCapableBeanFactory());
            if (context != null) {
                springConfig.setServletContext(context);
                this.pluginManager.setServletContext(context);
            }
            if (!this.pluginManager.isInitialised()) {
                this.pluginManager.loadPlugins();
            }
            if (!this.application.isInitialised()) {
                this.pluginManager.doArtefactConfiguration();
                this.application.initialise();
            }
            this.pluginManager.registerProvidedArtefacts(this.application);
            this.registerParentBeanFactoryPostProcessors(springConfig);
            this.pluginManager.doRuntimeConfiguration((RuntimeSpringConfiguration)springConfig);
            LOG.debug((Object)"[RuntimeConfiguration] Processing additional external configurations");
            if (loadExternalBeans) {
                this.doPostResourceConfiguration(this.application, springConfig);
            }
            this.reset();
            ctx = (WebApplicationContext)springConfig.getApplicationContext();
            this.application.setMainContext((ApplicationContext)ctx);
            this.pluginManager.setApplicationContext((ApplicationContext)ctx);
            this.pluginManager.doDynamicMethods();
            ctx.publishEvent((ApplicationEvent)new GrailsContextEvent(ctx, 0));
            this.performPostProcessing(ctx);
            this.application.refreshConstraints();
        }
        finally {
            ClassPropertyFetcher.clearClassPropertyFetcherCache();
        }
        return ctx;
    }

    protected WebRuntimeSpringConfiguration createWebRuntimeSpringConfiguration(GrailsApplication app, ApplicationContext parentCtx, ClassLoader classLoader) {
        return new WebRuntimeSpringConfiguration(parentCtx, classLoader);
    }

    private void registerParentBeanFactoryPostProcessors(WebRuntimeSpringConfiguration springConfig) {
        if (this.parent == null) {
            return;
        }
        Map parentPostProcessors = this.parent.getBeansOfType(BeanFactoryPostProcessor.class);
        for (Object o : parentPostProcessors.values()) {
            BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)o;
            ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor(postProcessor);
        }
    }

    public void reconfigure(GrailsApplicationContext current, ServletContext servletContext, boolean loadExternalBeans) {
        DefaultRuntimeSpringConfiguration springConfig = this.parent != null ? new DefaultRuntimeSpringConfiguration(this.parent) : new DefaultRuntimeSpringConfiguration();
        Assert.state((boolean)this.pluginManager.isInitialised(), (String)"Cannot re-configure Grails application when it hasn't even been configured yet!");
        this.pluginManager.doRuntimeConfiguration((RuntimeSpringConfiguration)springConfig);
        List<String> beanNames = springConfig.getBeanNames();
        Iterator<String> i$ = beanNames.iterator();
        while (i$.hasNext()) {
            String beanName;
            String name = beanName = i$.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Re-creating bean definition [" + name + "]"));
            }
            current.registerBeanDefinition(name, (BeanDefinition)springConfig.createBeanDefinition(name));
            current.getBean(name);
        }
        this.pluginManager.doDynamicMethods();
        this.pluginManager.doPostProcessing((ApplicationContext)current);
        if (loadExternalBeans) {
            this.doPostResourceConfiguration(this.application, springConfig);
        }
        this.reset();
    }

    private void performPostProcessing(WebApplicationContext ctx) {
        this.pluginManager.doPostProcessing((ApplicationContext)ctx);
    }

    public WebApplicationContext configureDomainOnly() {
        WebRuntimeSpringConfiguration springConfig = new WebRuntimeSpringConfiguration(this.parent, this.application.getClassLoader());
        springConfig.setServletContext((ServletContext)new MockServletContext());
        if (!this.pluginManager.isInitialised()) {
            this.pluginManager.loadPlugins();
        }
        if (this.pluginManager.hasGrailsPlugin("hibernate")) {
            this.pluginManager.doRuntimeConfiguration("hibernate", (RuntimeSpringConfiguration)springConfig);
        }
        WebApplicationContext ctx = (WebApplicationContext)springConfig.getApplicationContext();
        this.performPostProcessing(ctx);
        this.application.refreshConstraints();
        return ctx;
    }

    private void doPostResourceConfiguration(GrailsApplication app, RuntimeSpringConfiguration springConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Resource springResources;
            if (app.isWarDeployed()) {
                springResources = this.parent.getResource(SPRING_RESOURCES_XML);
            } else {
                PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
                springResources = patternResolver.getResource(DEVELOPMENT_SPRING_RESOURCES_XML);
            }
            if (springResources != null && springResources.exists()) {
                LOG.debug((Object)("[RuntimeConfiguration] Configuring additional beans from " + springResources.getURL()));
                XmlBeanFactory xmlBf = new XmlBeanFactory(springResources);
                xmlBf.setBeanClassLoader(classLoader);
                String[] beanNames = xmlBf.getBeanDefinitionNames();
                LOG.debug((Object)("[RuntimeConfiguration] Found [" + beanNames.length + "] beans to configure"));
                for (String beanName : beanNames) {
                    String[] aliases;
                    Class beanClass;
                    BeanDefinition bd = xmlBf.getBeanDefinition(beanName);
                    String beanClassName = bd.getBeanClassName();
                    Class clazz = beanClass = beanClassName == null ? null : ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader);
                    if (SESSION_FACTORY_BEAN.equals(beanName)) {
                        Class<ConfigurableLocalSessionFactoryBean> configurableLocalSessionFactoryBeanClass = ConfigurableLocalSessionFactoryBean.class;
                        if (beanClass == null || !configurableLocalSessionFactoryBeanClass.isAssignableFrom(beanClass)) {
                            LOG.warn((Object)("[RuntimeConfiguration] Found custom Hibernate SessionFactory bean defined in " + springResources.getURL() + ". The bean will not be configured as Grails needs to use its own specialized Hibernate SessionFactoryBean" + " in order to inject dynamic bahavior into domain classes." + " Use specialized Hibernate SessionFactoryBean '" + configurableLocalSessionFactoryBeanClass + "' for custom Hibernate SessionFactory bean defined in '" + springResources.getURL() + "' instead of '" + beanClassName + "' in order to configure custom Hibernate SessionFactory bean."));
                            continue;
                        }
                    }
                    springConfig.addBeanDefinition(beanName, bd);
                    for (String alias : aliases = xmlBf.getAliases(beanName)) {
                        springConfig.addAlias(alias, beanName);
                    }
                    if (beanClass == null || !BeanFactoryPostProcessor.class.isAssignableFrom(beanClass)) continue;
                    ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)xmlBf.getBean(beanName));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[RuntimeConfiguration] /WEB-INF/spring/resources.xml not found. Skipping configuration.");
            }
            GrailsRuntimeConfigurator.loadSpringGroovyResources(springConfig, classLoader);
        }
        catch (Exception ex) {
            LOG.warn((Object)"[RuntimeConfiguration] Unable to perform post initialization config: /WEB-INF/spring/resources.xml", (Throwable)ex);
        }
    }

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, ClassLoader classLoader, GenericApplicationContext context) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
        if (context != null) {
            springGroovyResourcesBeanBuilder.registerBeans((BeanDefinitionRegistry)context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, ClassLoader classLoader) {
        if (springGroovyResourcesBeanBuilder == null) {
            try {
                Class groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName((String)SPRING_RESOURCES_CLASS, (ClassLoader)classLoader);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (groovySpringResourcesClass != null) {
                    springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, Thread.currentThread().getContextClassLoader());
                    Script script = (Script)groovySpringResourcesClass.newInstance();
                    script.run();
                    Object beans = script.getProperty("beans");
                    springGroovyResourcesBeanBuilder.beans((Closure)beans);
                }
            }
            catch (Exception ex) {
                GrailsUtil.deepSanitize((Throwable)ex);
                LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from resources.groovy", (Throwable)ex);
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, ClassLoader classLoader) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, ClassLoader classLoader, GenericApplicationContext context) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
        GrailsRuntimeConfigurator.doLoadSpringGroovyResources(config, classLoader, context);
    }

    public void setLoadExternalPersistenceConfig(boolean b) {
    }

    public void setPluginManager(GrailsPluginManager manager) {
        this.pluginManager = manager;
    }

    public GrailsPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.parent = applicationContext;
    }

    public void reset() {
        springGroovyResourcesBeanBuilder = null;
    }
}

