/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote.netty;

import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.netty.NettyHandler;
import groovyx.gpars.remote.netty.NettyTransportProvider;
import groovyx.gpars.serial.SerialMsg;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class NettyRemoteConnection
extends RemoteConnection {
    private final NettyHandler handler;
    private final MyChannelFutureListener writeListener = new MyChannelFutureListener();

    public NettyRemoteConnection(NettyTransportProvider provider, NettyHandler netHandler) {
        super(provider);
        this.handler = netHandler;
    }

    public void write(SerialMsg msg) {
        if (this.handler.getChannel().isConnected() && this.handler.getChannel().isOpen()) {
            this.writeListener.incrementAndGet();
            this.handler.getChannel().write((Object)msg).addListener((ChannelFutureListener)this.writeListener);
        }
    }

    public void disconnect() {
        this.writeListener.incrementAndGet();
        this.writeListener.handler = this.handler;
        try {
            this.writeListener.operationComplete(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class MyChannelFutureListener
    extends AtomicInteger
    implements ChannelFutureListener {
        private static final long serialVersionUID = -3054880716233778157L;
        public volatile NettyHandler handler;

        private MyChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (this.decrementAndGet() == 0 && this.handler != null) {
                final CountDownLatch cdl = new CountDownLatch(1);
                this.handler.getChannel().close().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        cdl.countDown();
                    }
                });
                try {
                    cdl.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

