/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.DefaultPool;
import groovyx.gpars.util.PoolUtils;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ResizeablePool
extends DefaultPool {
    private static final long KEEP_ALIVE_TIME = 10L;

    public ResizeablePool(boolean daemon) {
        this(daemon, PoolUtils.retrieveDefaultPoolSize());
    }

    public ResizeablePool(boolean daemon, int poolSize) {
        super(ResizeablePool.createResizeablePool(daemon, poolSize));
    }

    private static ThreadPoolExecutor createResizeablePool(final boolean daemon, int poolSize) {
        assert (poolSize > 0);
        return new ThreadPoolExecutor(poolSize, 1000, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, DefaultPool.createThreadName());
                thread.setDaemon(daemon);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println();
                        e.printStackTrace(System.err);
                    }
                });
                return thread;
            }
        }, new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                int currentPoolSize = executor.getPoolSize();
                int maximumPoolSize = executor.getMaximumPoolSize();
                throw new IllegalStateException("The thread pool executor cannot run the task. The upper limit of the thread pool size has probably been reached. Current pool size: " + currentPoolSize + " Maximum pool size: " + maximumPoolSize);
            }
        });
    }
}

