/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.serial;

import groovyx.gpars.serial.DefaultRemoteHandle;
import groovyx.gpars.serial.LocalHandle;
import groovyx.gpars.serial.RemoteHandle;
import groovyx.gpars.serial.RemoteSerialized;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import java.io.ObjectStreamException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WithSerialId
implements Serializable {
    public volatile SerialHandle serialHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SerialHandle getOrCreateSerialHandle() {
        if (this.serialHandle == null) {
            WithSerialId withSerialId = this;
            synchronized (withSerialId) {
                if (this.serialHandle == null) {
                    this.serialHandle = SerialHandle.create(this, null);
                }
            }
        }
        return this.serialHandle;
    }

    public <T extends RemoteSerialized> Class<T> getRemoteClass() {
        throw new UnsupportedOperationException();
    }

    protected final Object writeReplace() throws ObjectStreamException {
        SerialHandle handle = this.getOrCreateSerialHandle();
        if (this instanceof RemoteSerialized) {
            return new LocalHandle(handle.getSerialId());
        }
        SerialContext host = SerialContext.get();
        handle.subscribe(host);
        return this.createRemoteHandle(handle, host);
    }

    protected RemoteHandle createRemoteHandle(SerialHandle handle, SerialContext host) {
        return new DefaultRemoteHandle(handle.getSerialId(), host.getHostId(), this.getRemoteClass());
    }
}

