/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.lang.Closure;
import groovy.time.Duration;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorGroup;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.ActorException;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.actor.impl.ReceivingMessageStream;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class SequentialProcessingActor
extends Actor
implements Runnable {
    protected volatile ActorGroup actorGroup;
    protected Runnable loopCode;
    private volatile Reaction reaction;
    private volatile Node inputQueue;
    private Node outputQueue;
    private volatile int count;
    private static final AtomicReferenceFieldUpdater<SequentialProcessingActor, Node> inputQueueUpdater = AtomicReferenceFieldUpdater.newUpdater(SequentialProcessingActor.class, Node.class, "inputQueue");
    private static final AtomicIntegerFieldUpdater<SequentialProcessingActor> countUpdater = AtomicIntegerFieldUpdater.newUpdater(SequentialProcessingActor.class, "count");
    private volatile Thread waitingThread;
    private volatile Thread currentThread;
    private static final ActorMessage startMessage = new ActorMessage<String>("startMessage", null);
    private static final ActorMessage stopMessage = new ActorMessage<String>("stopMessage", null);
    private static final ActorMessage loopMessage = new ActorMessage<String>("loopMessage", null);
    private static final ActorMessage terminateMessage = new ActorMessage<String>("terminateMessage", null);
    protected static final int S_ACTIVE_MASK = 1;
    protected static final int S_FINISHING_MASK = 2;
    protected static final int S_FINISHED_MASK = 4;
    protected static final int S_STOP_TERMINATE_MASK = 8;
    protected static final int S_NOT_STARTED = 0;
    protected static final int S_RUNNING = 1;
    protected static final int S_STOPPING = 11;
    protected static final int S_TERMINATING = 3;
    protected static final int S_STOPPED = 12;
    protected static final int S_TERMINATED = 4;
    protected volatile int stopFlag = 0;
    protected static final AtomicIntegerFieldUpdater<SequentialProcessingActor> stopFlagUpdater = AtomicIntegerFieldUpdater.newUpdater(SequentialProcessingActor.class, "stopFlag");
    private static final Timer timer = new Timer(true);

    public final boolean isActorThread() {
        return Thread.currentThread() == this.currentThread;
    }

    public final boolean isActive() {
        return (this.stopFlag & 1) != 0;
    }

    private ActorMessage getMessage() {
        assert (this.isActorThread());
        this.transferQueues();
        ActorMessage toProcess = this.outputQueue.msg;
        this.outputQueue = this.outputQueue.next;
        this.throwIfNeeded(toProcess);
        return toProcess;
    }

    private void throwIfNeeded(ActorMessage toProcess) {
        if (toProcess == stopMessage) {
            this.stopFlag = 11;
            throw ActorException.STOP;
        }
        if (toProcess == terminateMessage) {
            this.stopFlag = 3;
            throw ActorException.TERMINATE;
        }
    }

    protected final ActorMessage pollMessage() {
        assert (this.isActorThread());
        this.transferQueues();
        ActorMessage toProcess = null;
        if (this.outputQueue != null) {
            toProcess = this.outputQueue.msg;
            this.outputQueue = this.outputQueue.next;
        }
        return toProcess;
    }

    protected final ActorMessage takeMessage() throws InterruptedException {
        ActorMessage message;
        assert (this.isActorThread());
        while ((message = this.awaitNextMessage(0L)) == null) {
        }
        return message;
    }

    protected ActorMessage takeMessage(long timeout, TimeUnit timeUnit) throws InterruptedException {
        assert (this.isActorThread());
        long endTime = System.nanoTime() + timeUnit.toNanos(timeout);
        do {
            ActorMessage message;
            if ((message = this.awaitNextMessage(endTime)) == null) continue;
            return message;
        } while (System.nanoTime() < endTime);
        return null;
    }

    private ActorMessage awaitNextMessage(long endTime) throws InterruptedException {
        this.transferQueues();
        this.waitingThread = Thread.currentThread();
        if (this.outputQueue != null) {
            return this.retrieveNextMessage();
        }
        if (endTime == 0L) {
            LockSupport.park();
        } else {
            LockSupport.parkNanos(endTime - System.nanoTime());
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        return null;
    }

    private ActorMessage retrieveNextMessage() {
        ActorMessage toProcess = this.outputQueue.msg;
        this.outputQueue = this.outputQueue.next;
        countUpdater.decrementAndGet(this);
        this.throwIfNeeded(toProcess);
        return toProcess;
    }

    private void transferQueues() {
        if (this.outputQueue == null) {
            Node node = inputQueueUpdater.getAndSet(this, null);
            while (node != null) {
                Node next = node.next;
                node.next = this.outputQueue;
                this.outputQueue = node;
                node = next;
            }
        }
    }

    protected SequentialProcessingActor() {
        this.setActorGroup(Actors.defaultPooledActorGroup);
    }

    public final void setActorGroup(ActorGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Cannot set actor's group to null.");
        }
        if (this.stopFlag != 0) {
            throw new IllegalStateException("Cannot reset actor's group after it was started.");
        }
        this.actorGroup = group;
    }

    public ActorGroup getActorGroup() {
        return this.actorGroup;
    }

    public final MessageStream send(Object message) {
        block3: {
            block2: {
                Node prev;
                if (this.stopFlag != 1 && message != terminateMessage && message != stopMessage) {
                    throw new IllegalStateException("The actor cannot accept messages at this point.");
                }
                ActorMessage actorMessage = message instanceof ActorMessage ? (ActorMessage)message : ActorMessage.build(message);
                Node toAdd = new Node(actorMessage);
                do {
                    toAdd.next = prev = this.inputQueue;
                } while (!inputQueueUpdater.compareAndSet(this, prev, toAdd));
                int cnt = countUpdater.getAndIncrement(this);
                if (cnt != 0) break block2;
                if (this.stopFlag == 12 || this.stopFlag == 4) break block3;
                this.schedule();
                break block3;
            }
            Thread w = this.waitingThread;
            if (w == null) break block3;
            this.waitingThread = null;
            LockSupport.unpark(w);
        }
        return this;
    }

    private void schedule() {
        this.actorGroup.getThreadPool().execute(this);
    }

    protected void scheduleLoop() {
        if (this.stopFlag == 3) {
            throw ActorException.TERMINATE;
        }
        this.transferQueues();
        if (this.outputQueue != null && this.outputQueue.msg == stopMessage) {
            throw ActorException.STOP;
        }
        countUpdater.getAndIncrement(this);
        Node node = new Node(loopMessage);
        node.next = this.outputQueue;
        this.outputQueue = node;
        throw ActorException.CONTINUE;
    }

    private void handleStart() {
        this.doOnStart();
    }

    protected abstract void doOnStart();

    private void handleTimeout() {
        this.doOnTimeout();
    }

    protected abstract void doOnTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTermination() {
        if (this.stopFlag == 11) {
            this.stopFlag = 12;
        } else if (this.stopFlag == 3) {
            this.stopFlag = 4;
        } else {
            throw new IllegalStateException("Messed up actors state detected when terminating: " + this.stopFlag);
        }
        try {
            this.doOnTermination();
        }
        finally {
            this.getJoinLatch().bind(null);
        }
    }

    protected abstract void doOnTermination();

    private void handleException(Throwable exception) {
        this.doOnException(exception);
    }

    protected abstract void doOnException(Throwable var1);

    private void handleInterrupt(InterruptedException exception) {
        Thread.interrupted();
        this.doOnInterrupt(exception);
    }

    protected void doOnInterrupt(InterruptedException exception) {
    }

    public final SequentialProcessingActor start() {
        if (!stopFlagUpdater.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("Actor has already been started.");
        }
        this.send(startMessage);
        return this;
    }

    public final Actor stop() {
        if (stopFlagUpdater.compareAndSet(this, 1, 11)) {
            this.send(stopMessage);
        }
        return this;
    }

    public final Actor terminate() {
        int flag;
        while (((flag = this.stopFlag) & 4) == 0 && flag != 3) {
            if (!stopFlagUpdater.compareAndSet(this, flag, 3)) continue;
            if (this.isActorThread()) {
                throw ActorException.TERMINATE;
            }
            if (this.currentThread != null) {
                this.currentThread.interrupt();
                break;
            }
            this.send(terminateMessage);
            break;
        }
        return this;
    }

    protected final void react(Duration duration, Closure code) {
        this.react(duration.toMilliseconds(), code);
    }

    protected final void react(Closure code) {
        this.react(-1L, code);
    }

    protected final void react(long timeout, TimeUnit timeUnit, Closure code) {
        this.react(timeUnit.toMillis(timeout), code);
    }

    protected final void react(long timeout, Closure code) {
        if (!this.isActorThread()) {
            throw new IllegalStateException("Cannot call react from thread which is not owned by the actor");
        }
        this.getSenders().clear();
        int maxNumberOfParameters = code.getMaximumNumberOfParameters();
        code.setResolveStrategy(1);
        code.setDelegate((Object)this);
        if (maxNumberOfParameters > 1) {
            throw new IllegalArgumentException("Actor cannot process a multi-argument closures passed to react().");
        }
        assert (this.reaction == null);
        assert (maxNumberOfParameters <= 1);
        Reaction reactCode = new Reaction(this, maxNumberOfParameters == 1, code);
        if (timeout >= 0L) {
            reactCode.setTimeout(timeout);
        }
        this.reaction = reactCode;
        throw ActorException.CONTINUE;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void loop(final Runnable code) {
        if (this.loopCode != null) {
            throw new IllegalStateException("The loop method must be only called once");
        }
        if (code instanceof Closure) {
            ((Closure)code).setResolveStrategy(1);
            ((Closure)code).setDelegate((Object)this);
        }
        this.loopCode = new Runnable(){

            public void run() {
                SequentialProcessingActor.this.getSenders().clear();
                SequentialProcessingActor.this.obj2Sender.clear();
                if (code instanceof Closure) {
                    GroovyCategorySupport.use(Arrays.asList(ReceivingMessageStream.ReplyCategory.class), (Closure)((Closure)code));
                } else {
                    code.run();
                }
                SequentialProcessingActor.this.doLoopCall();
            }
        };
        this.loopCode.run();
    }

    private void doLoopCall() {
        this.checkStopTerminate();
        if (this.loopCode == null) {
            this.stopFlag = 11;
            throw ActorException.STOP;
        }
        this.scheduleLoop();
    }

    protected final void checkStopTerminate() {
        if (this.stopFlag != 1) {
            if (this.stopFlag == 3) {
                throw ActorException.TERMINATE;
            }
            if (this.stopFlag != 11) {
                throw new IllegalStateException("Should not reach here");
            }
        }
    }

    void runReaction(ActorMessage message, Closure code) {
        assert (message != null);
        if (message.getPayLoad() == ActorException.TIMEOUT) {
            throw ActorException.TIMEOUT;
        }
        this.getSenders().add(message.getSender());
        this.obj2Sender.put(message.getPayLoad(), message.getSender());
        GroovyCategorySupport.use(Arrays.asList(ReceivingMessageStream.ReplyCategory.class), (Closure)code);
        this.doLoopCall();
    }

    private static final class Reaction {
        private final boolean codeNeedsArgument;
        private final AtomicBoolean isReady = new AtomicBoolean(false);
        private final Closure code;
        private final SequentialProcessingActor actor;

        Reaction(SequentialProcessingActor actor, boolean codeNeedsArgument, Closure code) {
            this.actor = actor;
            this.code = code;
            this.codeNeedsArgument = codeNeedsArgument;
        }

        public boolean isReady() {
            return this.isReady.get();
        }

        public void offer(ActorMessage actorMessage) {
            boolean readyFlag = this.isReady.getAndSet(true);
            assert (!readyFlag);
            this.actor.reaction = null;
            if (this.codeNeedsArgument) {
                this.actor.runReaction(actorMessage, (Closure)new CurriedClosure(this.code, new Object[]{actorMessage.getPayLoad()}));
            } else {
                this.actor.runReaction(actorMessage, this.code);
            }
        }

        public void setTimeout(long timeout) {
            timer.schedule(new TimerTask(){

                public void run() {
                    if (!Reaction.this.isReady()) {
                        Reaction.this.actor.send(new ActorMessage<ActorException>(ActorException.TIMEOUT, null));
                    }
                }
            }, timeout);
        }
    }

    private static class Node {
        volatile Node next;
        final ActorMessage msg;

        Node(ActorMessage actorMessage) {
            this.msg = actorMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultiMessageReaction
    extends Closure
    implements GeneratedClosure {
        private static final long serialVersionUID = -4047888721838663324L;
        private final Closure code;
        private final int maxNumberOfParameters;
        private final long timeout;
        private final List<MessageStream> localSenders;

        private MultiMessageReaction(Closure code, int maxNumberOfParameters, long timeout, List<MessageStream> localSenders) {
            super(code.getThisObject());
            this.code = code;
            this.maxNumberOfParameters = maxNumberOfParameters;
            this.timeout = timeout;
            this.localSenders = localSenders;
        }

        public int getMaximumNumberOfParameters() {
            return 1;
        }

        public Class[] getParameterTypes() {
            return new Class[]{Object.class};
        }

        public Object doCall(Object args) {
            this.localSenders.add((MessageStream)InvokerHelper.invokeMethod((Object)args, (String)"getSender", null));
            int newNumberOfParameters = this.maxNumberOfParameters - 1;
            if (newNumberOfParameters <= 0) {
                SequentialProcessingActor.this.getSenders().clear();
                SequentialProcessingActor.this.getSenders().addAll(this.localSenders);
                InvokerHelper.invokeClosure((Object)this.code.curry(new Object[]{args}), null);
            } else {
                SequentialProcessingActor.this.react(this.timeout, (Closure)new MultiMessageReaction(this.code.curry(new Object[]{args}), newNumberOfParameters, this.timeout, this.localSenders));
            }
            return null;
        }
    }
}

