/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.serial;

import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.groovy.util.ManagedReference;
import org.codehaus.groovy.util.ReferenceBundle;
import org.codehaus.groovy.util.ReferenceManager;
import org.codehaus.groovy.util.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialHandle
extends ManagedReference<WithSerialId> {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final ReferenceManager manager = ReferenceManager.createThreadedManager((ReferenceQueue)queue);
    private static final ReferenceBundle bundle = new ReferenceBundle(manager, ReferenceType.WEAK);
    protected final UUID serialId;
    protected final SerialContext context = SerialContext.get();
    private volatile Object subscribers;
    private volatile WithSerialId anchor;

    private SerialHandle(WithSerialId value, UUID id) {
        super(bundle, (Object)value);
        this.serialId = id == null ? UUID.randomUUID() : id;
        this.context.add(this);
    }

    public UUID getSerialId() {
        return this.serialId;
    }

    public void finalizeReference() {
        this.context.finalizeHandle(this);
        super.finalizeReference();
    }

    public Object getSubscribers() {
        return this.subscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(SerialContext context) {
        SerialHandle serialHandle = this;
        synchronized (serialHandle) {
            if (this.subscribers == null) {
                this.subscribers = context;
            } else if (this.subscribers instanceof SerialContext) {
                if (this.subscribers != context) {
                    ArrayList<SerialContext> list = new ArrayList<SerialContext>(2);
                    list.add((SerialContext)this.subscribers);
                    list.add(context);
                    this.subscribers = list;
                }
            } else {
                List list = (List)this.subscribers;
                for (SerialContext remoteHost : list) {
                    if (remoteHost != context) continue;
                    return;
                }
                list.add(context);
            }
            this.anchor = (WithSerialId)this.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(SerialContext context) {
        SerialHandle serialHandle = this;
        synchronized (serialHandle) {
            if (this.subscribers != null) {
                if (this.subscribers instanceof SerialContext) {
                    if (this.subscribers == context) {
                        this.subscribers = null;
                    }
                } else {
                    List list = (List)this.subscribers;
                    list.remove(context);
                    if (list.size() == 1) {
                        this.subscribers = list.get(0);
                    }
                }
            }
            if (this.subscribers == null) {
                this.anchor = null;
            }
        }
    }

    public static SerialHandle create(WithSerialId obj, UUID id) {
        if (id == null) {
            return new LocalSerialHandle(obj, UUID.randomUUID());
        }
        return new RemoteSerialHandle(obj, id);
    }

    private static class RemoteSerialHandle
    extends SerialHandle {
        private RemoteSerialHandle(WithSerialId obj, UUID uuid) {
            super(obj, uuid);
        }

        public void finalizeReference() {
            super.finalizeReference();
            this.context.write(new ReleaseHandle(this.serialId));
        }

        public static class ReleaseHandle
        extends SerialMsg {
            private static final long serialVersionUID = -951052191389868427L;
            private final UUID serialId;

            public ReleaseHandle(UUID serialId) {
                this.serialId = serialId;
            }

            public void execute(RemoteConnection conn) {
                RemoteHost remoteHost = conn.getHost();
                SerialHandle handle = remoteHost.get(this.serialId);
                if (handle instanceof LocalSerialHandle) {
                    handle.unsubscribe(remoteHost);
                }
            }
        }
    }

    private static class LocalSerialHandle
    extends SerialHandle {
        public LocalSerialHandle(WithSerialId obj, UUID uuid) {
            super(obj, uuid);
        }
    }
}

