/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import jsr166y.forkjoin.ForkJoinWorkerThread;

final class PoolBarrier {
    final AtomicReference<EQNode> head = new AtomicReference();
    final AtomicLong counter = new AtomicLong();

    PoolBarrier() {
    }

    long getCount() {
        return this.counter.get();
    }

    long sync(ForkJoinWorkerThread thread, long count) {
        long current = this.counter.get();
        if (current == count) {
            this.enqAndWait(thread, count);
        }
        if (this.head.get() != null) {
            this.releaseAll();
        }
        return current;
    }

    void signal() {
        AtomicLong counter = this.counter;
        long c = counter.get();
        counter.compareAndSet(c, c + 1L);
        AtomicReference<EQNode> head = this.head;
        EQNode h = head.get();
        if (h != null) {
            ForkJoinWorkerThread t;
            if (head.compareAndSet(h, h.next) && (t = h.thread) != null) {
                h.thread = null;
                LockSupport.unpark(t);
            } else if (head.get() != null) {
                this.releaseAll();
            }
        }
    }

    void poolSignal() {
        this.counter.incrementAndGet();
        this.releaseAll();
    }

    private void enqAndWait(ForkJoinWorkerThread thread, long count) {
        block2: {
            EQNode h;
            EQNode node = new EQNode(thread, count);
            AtomicReference<EQNode> head = this.head;
            AtomicLong counter = this.counter;
            do {
                node.next = h = head.get();
                if (h != null && h.count != count || counter.get() != count) break block2;
            } while (!head.compareAndSet(h, node));
            while (!thread.isInterrupted() && node.thread != null && counter.get() == count) {
                LockSupport.park();
            }
            node.thread = null;
        }
    }

    private void releaseAll() {
        EQNode p;
        AtomicReference<EQNode> head = this.head;
        while ((p = head.get()) != null) {
            if (!head.compareAndSet(p, null)) continue;
            do {
                ForkJoinWorkerThread t;
                if ((t = p.thread) == null) continue;
                p.thread = null;
                LockSupport.unpark(t);
            } while ((p = p.next) != null);
            break;
        }
    }

    static final class EQNode {
        EQNode next;
        volatile ForkJoinWorkerThread thread;
        final long count;

        EQNode(ForkJoinWorkerThread t, long c) {
            this.thread = t;
            this.count = c;
        }
    }
}

