/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Submission<V>
extends ForkJoinTask<V>
implements Future<V> {
    static final int INITIAL = 0;
    static final int RUNNING = 1;
    static final int DONE = 2;
    private final ForkJoinTask<V> task;
    private final ForkJoinPool pool;
    private final Sync sync;
    private volatile V result;

    Submission(ForkJoinTask<V> t, ForkJoinPool p) {
        t.setStolen();
        this.task = t;
        this.pool = p;
        this.sync = new Sync();
    }

    private void complete() {
        if (this.sync.transitionToDone() == 1) {
            this.pool.submissionCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V compute() {
        try {
            V ret = null;
            if (this.sync.transitionToRunning()) {
                this.pool.submissionStarting();
                ret = this.task.forkJoin();
            }
            V v = ret;
            return v;
        }
        finally {
            this.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        try {
            if (this.getException() == null && !this.sync.isDone()) {
                this.setDoneExceptionally(new CancellationException());
                this.task.cancel();
            }
        }
        finally {
            this.complete();
        }
    }

    @Override
    public boolean cancel(boolean ignore) {
        this.cancel();
        return this.isCancelled();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
        }
        this.sync.acquireSharedInterruptibly(1);
        return this.task.reportAsFutureResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            if (!((ForkJoinWorkerThread)t).doTimedJoinTask(this, nanos)) {
                throw new TimeoutException();
            }
            this.sync.acquireSharedInterruptibly(1);
        } else if (!this.sync.tryAcquireSharedNanos(1, nanos)) {
            throw new TimeoutException();
        }
        return this.task.reportAsFutureResult();
    }

    public V awaitInvoke() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
        }
        this.sync.acquireShared(1);
        return this.task.reportAsForkJoinResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(V result) {
        try {
            this.result = result;
            this.setDone();
        }
        finally {
            this.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishExceptionally(Throwable ex) {
        try {
            this.setDoneExceptionally(ex);
            this.task.setDoneExceptionally(ex);
        }
        finally {
            this.complete();
        }
    }

    @Override
    public V forkJoin() {
        Throwable ex;
        V v = null;
        if (this.exception == null) {
            try {
                V v2 = this.compute();
                v = v2;
                this.result = v2;
            }
            catch (Throwable rex) {
                this.finishExceptionally(rex);
            }
        }
        if ((ex = this.setDone()) != null) {
            Submission.rethrowException(ex);
        }
        return v;
    }

    @Override
    public Throwable exec() {
        if (this.exception == null) {
            try {
                this.result = this.compute();
            }
            catch (Throwable rex) {
                return this.setDoneExceptionally(rex);
            }
        }
        return this.setDone();
    }

    @Override
    public V rawResult() {
        return this.result;
    }

    @Override
    public void reinitialize() {
        this.result = null;
        this.sync.reset();
        super.reinitialize();
    }

    static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync() {
        }

        public int tryAcquireShared(int acquires) {
            return this.getState() == 2 ? 1 : -1;
        }

        public boolean tryReleaseShared(int releases) {
            return true;
        }

        public void reset() {
            this.setState(0);
        }

        public boolean isDone() {
            return this.getState() == 2;
        }

        public boolean transitionToRunning() {
            return this.compareAndSetState(0, 1);
        }

        public int transitionToDone() {
            int c;
            while ((c = this.getState()) != 2 && !this.compareAndSetState(c, 2)) {
            }
            this.releaseShared(0);
            return c;
        }
    }
}

