/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUrlMappingData
implements UrlMappingData {
    private static final String CAPTURED_WILDCARD = "(*)";
    private static final String CAPTURED_DOUBLE_WILDCARD = "(**)";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private final String urlPattern;
    private final String[] logicalUrls;
    private String[] tokens;
    private List<Boolean> optionalTokens = new ArrayList<Boolean>();

    public DefaultUrlMappingData(String urlPattern) {
        Assert.hasLength((String)urlPattern, (String)"Argument [urlPattern] cannot be null or blank");
        Assert.isTrue((boolean)urlPattern.startsWith(SLASH), (String)"Argument [urlPattern] is not a valid URL. It must start with '/' !");
        this.urlPattern = StringUtils.replace((String)urlPattern, (String)"(*)**", (String)CAPTURED_DOUBLE_WILDCARD);
        this.tokens = this.urlPattern.substring(1).split(SLASH);
        ArrayList<String> urls = new ArrayList<String>();
        this.parseUrls(urls);
        this.logicalUrls = urls.toArray(new String[urls.size()]);
    }

    private void parseUrls(List<String> urls) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.tokens.length; ++i) {
            String token = this.tokens[i].trim();
            if (token.equals(SLASH)) continue;
            boolean isOptional = false;
            if (token.endsWith(QUESTION_MARK)) {
                urls.add(buf.toString());
                this.tokens[i] = token.substring(0, token.length() - 1);
                buf.append(SLASH).append(this.tokens[i]);
                isOptional = true;
            } else {
                buf.append(SLASH).append(token);
            }
            if (CAPTURED_WILDCARD.equals(this.tokens[i])) {
                if (isOptional) {
                    this.optionalTokens.add(Boolean.TRUE);
                } else {
                    this.optionalTokens.add(Boolean.FALSE);
                }
            }
            if (!CAPTURED_DOUBLE_WILDCARD.equals(this.tokens[i])) continue;
            this.optionalTokens.add(Boolean.TRUE);
        }
        urls.add(buf.toString());
        Collections.reverse(urls);
    }

    @Override
    public String[] getTokens() {
        return this.tokens;
    }

    @Override
    public String[] getLogicalUrls() {
        return this.logicalUrls;
    }

    @Override
    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public boolean isOptional(int index) {
        if (index >= this.optionalTokens.size()) {
            return true;
        }
        return this.optionalTokens.get(index).equals(Boolean.TRUE);
    }
}

