/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsUtil;
import groovy.lang.GroovyClassLoader;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.support.ResourceAwareTemplateEngine;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.ServletContextResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPagesTemplateEngine
extends ResourceAwareTemplateEngine
implements ApplicationContextAware,
ServletContextAware,
InitializingBean {
    public static final String CONFIG_PROPERTY_DISABLE_CACHING_RESOURCES = "grails.gsp.disable.caching.resources";
    public static final String CONFIG_PROPERTY_GSP_ENABLE_RELOAD = "grails.gsp.enable.reload";
    private static final String GENERATED_GSP_NAME_PREFIX = "gsp_script_";
    private static final Log LOG;
    private Map<String, GroovyPageMetaInfo> pageCache = new ConcurrentHashMap<String, GroovyPageMetaInfo>();
    private ClassLoader classLoader;
    private int scriptNameCount;
    private ResourceLoader resourceLoader;
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    public static final String RESOURCE_LOADER_BEAN_ID = "groovyPagesResourceLoader";
    private boolean reloadEnabled;
    private ServletContextResourceLoader servletContextLoader;
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private Map<String, String> precompiledGspMap;
    private Map<String, GroovyPageMetaInfo> precompiledCache = new ConcurrentHashMap<String, GroovyPageMetaInfo>();
    private boolean cacheResources = true;
    private boolean resourceLoaderDefined = false;
    private static File dumpLineNumbersTo;

    public GroovyPagesTemplateEngine() {
    }

    public GroovyPagesTemplateEngine(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"Argument [servletContext] cannot be null");
        this.resourceLoader = new ServletContextResourceLoader(servletContext);
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
    }

    public void afterPropertiesSet() {
        if (this.classLoader == null) {
            this.classLoader = this.initGroovyClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    private GroovyClassLoader initGroovyClassLoader(ClassLoader parent) {
        CompilerConfiguration compConfig = new CompilerConfiguration();
        compConfig.setSourceEncoding("UTF-8");
        return new GroovyClassLoader(parent, compConfig);
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoaderDefined = resourceLoader != null;
        this.resourceLoader = resourceLoader;
    }

    public int[] calculateLineNumbersForPage(ServletContext context, String url) {
        try {
            Template t = this.createTemplate(url);
            if (t instanceof GroovyPageTemplate) {
                return ((GroovyPageTemplate)t).getMetaInfo().getLineNumbers();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception retrieving line numbers from GSP: " + url + ", message: " + e.getMessage()));
            LOG.debug((Object)"Full stack trace of error", (Throwable)e);
        }
        return new int[0];
    }

    public Template createTemplate(Resource resource) {
        return this.createTemplate(resource, this.cacheResources);
    }

    public Template createTemplate(Resource resource, boolean cacheable) {
        if (resource == null) {
            GrailsWebRequest webRequest = this.getWebRequest();
            throw new GroovyPagesException("No Groovy page found for URI: " + this.getCurrentRequestUri(webRequest.getCurrentRequest()));
        }
        String name = cacheable ? this.establishPageName(resource, this.getPathForResource(resource)) : this.establishPageName(resource, null);
        if (!this.isReloadEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating template using resource " + resource), (Throwable)new Exception("Creating template using resource " + resource));
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Creating template using resource " + resource));
            }
        }
        if (cacheable && this.pageCache.containsKey(name)) {
            GroovyPageMetaInfo meta = this.pageCache.get(name);
            if (this.isGroovyPageReloadable(resource, meta)) {
                try {
                    return this.createTemplateWithResource(resource, cacheable);
                }
                catch (IOException e) {
                    throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
                }
            }
            return new GroovyPageTemplate(meta);
        }
        try {
            return this.createTemplateWithResource(resource, cacheable);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
        }
    }

    public Template createTemplate(String uri) {
        return this.createTemplateForUri(uri);
    }

    private boolean isPrecompiledAvailable() {
        return this.precompiledGspMap != null && this.precompiledGspMap.size() > 0 && !GrailsUtil.isDevelopmentEnv();
    }

    private GroovyPageTemplate createTemplateFromPrecompiled(String uri) {
        if (this.isPrecompiledAvailable()) {
            GroovyPageTemplate t = this.createTemplateFromPrecompiled(uri, uri);
            if (t == null) {
                t = this.createTemplateFromPrecompiled(uri, "/WEB-INF" + uri);
            }
            if (t == null) {
                t = this.createTemplateFromPrecompiled(uri, this.getUriWithinGrailsViews(uri));
            }
            return t;
        }
        return null;
    }

    private GroovyPageTemplate createTemplateFromPrecompiled(final String originalUri, String uri) {
        GroovyPageMetaInfo meta = this.precompiledCache.get(uri);
        if (meta == null && (meta = this.loadPrecompiledGsp(uri)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding GSP class GroovyPageMetaInfo in cache for uri " + uri + " classname is " + meta.getPageClass().getName()));
            }
            this.precompiledCache.put(uri, meta);
            this.precompiledCache.put(originalUri, meta);
        }
        if (meta != null) {
            if (this.isReloadEnabled() && meta.shouldReload(new PrivilegedAction<Resource>(){

                @Override
                public Resource run() {
                    return GroovyPagesTemplateEngine.this.getResourceForUri(originalUri);
                }
            })) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Precompiled GSP for uri " + originalUri + " is newer in reload location. Ignoring the precompiled GSP."));
                }
                Iterator<Map.Entry<String, GroovyPageMetaInfo>> it = this.precompiledCache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, GroovyPageMetaInfo> entry = it.next();
                    if (entry.getValue() != meta) continue;
                    this.precompiledGspMap.remove(entry.getKey());
                    it.remove();
                }
                return null;
            }
            return new GroovyPageTemplate(meta);
        }
        return null;
    }

    private GroovyPageMetaInfo loadPrecompiledGsp(String uri) {
        GroovyPageMetaInfo meta = null;
        String gspClassName = this.precompiledGspMap.get(uri);
        if (gspClassName != null) {
            Class<?> gspClass = null;
            try {
                gspClass = Class.forName(gspClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Cannot load class " + gspClassName + ". Resuming on non-precompiled implementation."), (Throwable)e);
            }
            if (gspClass != null) {
                meta = new GroovyPageMetaInfo(gspClass);
                meta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
                meta.setTagLibraryLookup(this.tagLibraryLookup);
            }
        }
        return meta;
    }

    public Template createTemplateForUri(String uri) {
        return this.createTemplateForUri(new String[]{uri});
    }

    public Template createTemplateForUri(String[] uri) {
        if (this.isPrecompiledAvailable()) {
            for (String anUri : uri) {
                GroovyPageTemplate t = this.createTemplateFromPrecompiled(anUri);
                if (t == null) continue;
                return t;
            }
        }
        Resource resource = null;
        for (String anUri : uri) {
            Resource r = this.getResourceForUri(anUri);
            if (!r.exists()) continue;
            resource = r;
            break;
        }
        if (resource != null) {
            if (this.isPrecompiledAvailable() && !this.isReloadEnabled() && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Precompiled GSP not found for uri: " + Arrays.asList(uri) + ". Using resource " + resource));
            }
            return this.createTemplate(resource, true);
        }
        return null;
    }

    public Template createTemplate(String txt, String pageName) throws IOException {
        Assert.hasLength((String)txt, (String)"Argument [txt] cannot be null or blank");
        Assert.hasLength((String)pageName, (String)"Argument [pageName] cannot be null or blank");
        return this.createTemplate((Resource)new ByteArrayResource(txt.getBytes("UTF-8"), pageName), pageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplate(Resource resource, String pageName) throws IOException {
        Template template;
        InputStream in = resource.getInputStream();
        try {
            template = this.createTemplate(in, resource, pageName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return template;
    }

    public Template createTemplate() {
        GrailsWebRequest webRequest = this.getWebRequest();
        String uri = this.getCurrentRequestUri(webRequest.getCurrentRequest());
        return this.createTemplate(uri);
    }

    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new FileSystemResource(file));
    }

    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new UrlResource(url));
    }

    public Template createTemplate(InputStream inputStream) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, null, null);
        return new GroovyPageTemplate(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplateWithResource(Resource resource, boolean cacheable) throws IOException {
        InputStream in;
        block3: {
            Template template;
            in = resource.getInputStream();
            try {
                if (!cacheable) break block3;
                template = this.createTemplate(in, resource, this.getPathForResource(resource));
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return template;
        }
        Template template = this.createTemplate(in, resource, null);
        Object var6_7 = null;
        in.close();
        return template;
    }

    protected Template createTemplate(InputStream inputStream, Resource resource, String pageName) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, resource, pageName);
        return new GroovyPageTemplate(metaInfo);
    }

    private boolean isGroovyPageReloadable(final Resource resource, GroovyPageMetaInfo meta) {
        return this.isReloadEnabled() && meta.shouldReload(new PrivilegedAction<Resource>(){

            @Override
            public Resource run() {
                return resource;
            }
        });
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean b) {
        this.reloadEnabled = b;
    }

    private Resource getResourceForUri(String uri) {
        String pluginUri;
        Resource r = this.getResourceWithinContext(uri);
        if (!(r != null && r.exists() || (r = this.getResourceWithinContext(pluginUri = "/WEB-INF" + uri)) != null && r.exists())) {
            uri = this.getUriWithinGrailsViews(uri);
            return this.getResourceWithinContext(uri);
        }
        return r;
    }

    private Resource getResourceWithinContext(String uri) {
        Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"TemplateEngine not initialised correctly, no [resourceLoader] specified!");
        if (this.resourceLoaderDefined) {
            return this.resourceLoader.getResource(uri);
        }
        Resource r = this.servletContextLoader.getResource(uri);
        if (r.exists()) {
            return r;
        }
        return this.resourceLoader.getResource(uri);
    }

    protected GroovyPageMetaInfo buildPageMetaInfo(InputStream inputStream, Resource res, String pageName) {
        GroovyPageParser parser;
        String name = this.establishPageName(res, pageName);
        String path = this.getPathForResource(res);
        try {
            parser = new GroovyPageParser(name, path, path, inputStream);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O parsing Groovy page [" + (res != null ? res.getDescription() : name) + "]: " + e.getMessage(), e);
        }
        InputStream in = parser.parse();
        GroovyPageMetaInfo metaInfo = this.createPageMetaInfo(parser, in);
        metaInfo.applyLastModifiedFromResource(res);
        try {
            metaInfo.setPageClass(this.compileGroovyPage(in, name, path, metaInfo));
            metaInfo.setHtmlParts(parser.getHtmlPartsArray());
        }
        catch (GroovyPagesException e) {
            metaInfo.setCompilationException(e);
        }
        if (!name.startsWith(GENERATED_GSP_NAME_PREFIX)) {
            this.pageCache.put(name, metaInfo);
        }
        return metaInfo;
    }

    private String getPathForResource(Resource res) {
        if (res == null) {
            return "";
        }
        String path = null;
        try {
            File file = res.getFile();
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null) {
            return path;
        }
        if (res.getDescription() != null) {
            return res.getDescription();
        }
        return "";
    }

    private Class<?> compileGroovyPage(InputStream in, String name, String pageName, GroovyPageMetaInfo metaInfo) {
        Class scriptClass;
        GroovyClassLoader groovyClassLoader = this.findOrInitGroovyClassLoader();
        try {
            scriptClass = groovyClassLoader.parseClass(DefaultGroovyMethods.getText((InputStream)in, (String)"UTF-8"), name);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation error compiling GSP [" + name + "]:" + e.getMessage()), (Throwable)e);
            int lineNumber = GrailsExceptionResolver.extractLineNumber(e);
            int[] lineMappings = metaInfo.getLineNumbers();
            if (lineNumber > 0 && lineNumber < lineMappings.length) {
                lineNumber = lineMappings[lineNumber - 1];
            }
            throw new GroovyPagesException("Could not parse script [" + name + "]: " + e.getMessage(), e, lineNumber, pageName);
        }
        catch (IOException e) {
            throw new GroovyPagesException("IO exception parsing script [" + name + "]: " + e.getMessage(), e);
        }
        return scriptClass;
    }

    private synchronized GroovyClassLoader findOrInitGroovyClassLoader() {
        if (!(this.classLoader instanceof GroovyClassLoader)) {
            this.classLoader = this.initGroovyClassLoader(this.classLoader);
        }
        return (GroovyClassLoader)this.classLoader;
    }

    private GroovyPageMetaInfo createPageMetaInfo(GroovyPageParser parse, InputStream in) {
        GroovyPageMetaInfo pageMeta;
        block4: {
            pageMeta = new GroovyPageMetaInfo();
            pageMeta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
            pageMeta.setTagLibraryLookup(this.tagLibraryLookup);
            pageMeta.setContentType(parse.getContentType());
            pageMeta.setLineNumbers(parse.getLineNumberMatrix());
            pageMeta.setJspTags(parse.getJspTags());
            pageMeta.setCodecName(parse.getDefaultCodecDirectiveValue());
            pageMeta.initCodec();
            if (GrailsUtil.isDevelopmentEnv()) {
                pageMeta.setGroovySource(in);
            }
            if (dumpLineNumbersTo != null) {
                String fileName = parse.getClassName() + "_linenumbers.data";
                File file = new File(dumpLineNumbersTo, fileName);
                try {
                    parse.writeLineNumbers(file);
                }
                catch (IOException ignored) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }
        return pageMeta;
    }

    private GrailsWebRequest getWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    protected String establishPageName(Resource res, String pageName) {
        if (res == null) {
            return this.generateTemplateName();
        }
        try {
            String name;
            String string = name = pageName != null ? pageName : res.getURL().getPath();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return name.replaceAll("[^\\w\\d]", "_");
        }
        catch (IllegalStateException e) {
            return this.generateTemplateName();
        }
        catch (IOException ioex) {
            return this.generateTemplateName();
        }
    }

    private synchronized String generateTemplateName() {
        return GENERATED_GSP_NAME_PREFIX + ++this.scriptNameCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.resourceLoader == null) {
            this.resourceLoader = applicationContext;
        }
    }

    protected String getCurrentRequestUri(HttpServletRequest request) {
        Object includePath = request.getAttribute("javax.servlet.include.servlet_path");
        if (includePath != null) {
            return (String)includePath;
        }
        return request.getServletPath();
    }

    protected String getUriWithinGrailsViews(String relativeUri) {
        StringBuilder buf = new StringBuilder();
        if (relativeUri.startsWith("/")) {
            relativeUri = relativeUri.substring(1);
        }
        String[] tokens = relativeUri.indexOf(47) > -1 ? relativeUri.split("/") : new String[]{relativeUri};
        buf.append("/WEB-INF/grails-app/views");
        for (String token : tokens) {
            buf.append('/').append(token);
        }
        if (!relativeUri.endsWith(".gsp")) {
            buf.append(".gsp");
        }
        return buf.toString();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
        if (this.resourceLoader == null) {
            this.resourceLoader = new ServletContextResourceLoader(servletContext);
        }
    }

    public void clearPageCache() {
        this.pageCache.clear();
        this.precompiledCache.clear();
    }

    public Map<String, String> getPrecompiledGspMap() {
        return this.precompiledGspMap;
    }

    public void setPrecompiledGspMap(Map<String, String> precompiledGspMap) {
        this.precompiledGspMap = precompiledGspMap;
    }

    public boolean isCacheResources() {
        return this.cacheResources;
    }

    public void setCacheResources(boolean cacheResources) {
        this.cacheResources = cacheResources;
    }

    static {
        File dir;
        LOG = LogFactory.getLog(GroovyPagesTemplateEngine.class);
        String dirPath = System.getProperty("grails.dump.gsp.line.numbers.to.dir");
        if (dirPath != null && ((dir = new File(dirPath)).exists() || dir.mkdirs())) {
            dumpLineNumbersTo = dir;
        }
    }
}

