/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.Writable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecPrintWriter
extends GrailsPrintWriter {
    Method encodeMethod;
    Class<?> encodeParamType;

    public CodecPrintWriter(Writer out, Class<?> codecClass) {
        super(out);
        this.allowUnwrappingOut = false;
        this.initEncode(codecClass);
    }

    private void initEncode(Class<?> codecClass) {
        this.encodeMethod = ReflectionUtils.findMethod(codecClass, (String)"encode", (Class[])null);
        ReflectionUtils.makeAccessible((Method)this.encodeMethod);
        this.encodeParamType = this.encodeMethod.getParameterTypes()[0];
    }

    private Object encodeObject(Object o) {
        try {
            if (!this.encodeParamType.isInstance(o)) {
                o = String.valueOf(o);
            }
            return ReflectionUtils.invokeMethod((Method)this.encodeMethod, null, (Object[])new Object[]{o});
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling encode method " + this.encodeMethod, e);
        }
    }

    @Override
    public void print(Object obj) {
        this.encodeAndPrint(obj);
    }

    private void encodeAndPrint(Object obj) {
        if (this.trouble || obj == null) {
            this.usageFlag = true;
            return;
        }
        Object encoded = this.encodeObject(obj);
        if (encoded instanceof StreamCharBuffer) {
            super.write((StreamCharBuffer)encoded);
        } else if (encoded instanceof Writable) {
            super.write((Writable)encoded);
        } else if (obj instanceof CharSequence) {
            try {
                this.usageFlag = true;
                this.out.append((CharSequence)encoded);
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        } else {
            super.write(String.valueOf(encoded));
        }
    }

    @Override
    public void print(String s) {
        this.encodeAndPrint(s);
    }

    @Override
    public void write(String s) {
        this.encodeAndPrint(s);
    }

    @Override
    public void write(int c) {
        this.encodeAndPrint(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.encodeAndPrint(new String(buf, off, len));
    }

    @Override
    public void write(String s, int off, int len) {
        this.encodeAndPrint(s.substring(off, off + len));
    }

    @Override
    public void write(char[] buf) {
        this.encodeAndPrint(new String(buf));
    }

    @Override
    public void print(boolean b) {
        if (b) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void println() {
        this.usageFlag = true;
        this.write(CRLF);
    }

    @Override
    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println(int i) {
        this.print(i);
        this.println();
    }

    @Override
    public void println(long l) {
        this.print(l);
        this.println();
    }

    @Override
    public void println(float f) {
        this.print(f);
        this.println();
    }

    @Override
    public void println(double d) {
        this.print(d);
        this.println();
    }

    @Override
    public void println(char[] c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    @Override
    public void println(Object o) {
        this.print(o);
        this.println();
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.encodeAndPrint(csq.subSequence(start, end));
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.encodeAndPrint(csq);
        return this;
    }

    @Override
    public GrailsPrintWriter append(Object obj) {
        this.print(obj);
        return this;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void write(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void print(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void append(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void println(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
        this.println();
    }

    @Override
    public GrailsPrintWriter leftShift(StreamCharBuffer otherBuffer) {
        if (otherBuffer != null) {
            this.encodeAndPrint(otherBuffer);
        }
        return this;
    }

    @Override
    public void write(Writable writable) {
        this.usageFlag = true;
        if (this.trouble) {
            return;
        }
        try {
            writable.writeTo((Writer)this);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void print(Writable writable) {
        this.write(writable);
    }

    @Override
    public GrailsPrintWriter leftShift(Writable writable) {
        this.write(writable);
        return this;
    }
}

