/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import grails.util.GrailsUtil;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.orm.hibernate.cfg.CacheConfig;
import org.codehaus.groovy.grails.orm.hibernate.cfg.ColumnConfig;
import org.codehaus.groovy.grails.orm.hibernate.cfg.CompositeIdentity;
import org.codehaus.groovy.grails.orm.hibernate.cfg.HibernateMappingBuilder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Identity;
import org.codehaus.groovy.grails.orm.hibernate.cfg.IdentityEnumType;
import org.codehaus.groovy.grails.orm.hibernate.cfg.JoinTable;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.cfg.NaturalId;
import org.codehaus.groovy.grails.orm.hibernate.cfg.PropertyConfig;
import org.codehaus.groovy.grails.orm.hibernate.persister.entity.GroovyAwareJoinedSubclassEntityPersister;
import org.codehaus.groovy.grails.orm.hibernate.persister.entity.GroovyAwareSingleTableEntityPersister;
import org.codehaus.groovy.grails.orm.hibernate.validation.UniqueConstraint;
import org.codehaus.groovy.grails.plugins.orm.hibernate.HibernatePluginSupport;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsDomainBinder {
    private static final String FOREIGN_KEY_SUFFIX = "_id";
    private static final Log LOG = LogFactory.getLog(GrailsDomainBinder.class);
    private static final String STRING_TYPE = "string";
    private static final String EMPTY_PATH = "";
    private static final char UNDERSCORE = '_';
    private static final String CASCADE_ALL = "all";
    private static final String CASCADE_SAVE_UPDATE = "save-update";
    private static final String CASCADE_NONE = "none";
    private static final String BACKTICK = "`";
    private static final java.util.Map<Class<?>, Mapping> MAPPING_CACHE = new HashMap();
    private static final String ENUM_TYPE_CLASS = "org.hibernate.type.EnumType";
    private static final String ENUM_CLASS_PROP = "enumClass";
    private static final String ENUM_TYPE_PROP = "type";
    private static final String DEFAULT_ENUM_TYPE = "default";
    public static NamingStrategy namingStrategy = ImprovedNamingStrategy.INSTANCE;

    public static void configureNamingStrategy(Object strategy) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> namingStrategyClass = strategy instanceof Class ? (Class<?>)strategy : ApplicationHolder.getApplication().getClassLoader().loadClass(strategy.toString());
        namingStrategy = (NamingStrategy)namingStrategyClass.newInstance();
    }

    private static void bindMapSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map<?, ?> persistentClasses, Map map) {
        GrailsDomainBinder.bindCollectionSecondPass(property, mappings, persistentClasses, (Collection)map);
        SimpleValue value = new SimpleValue(map.getCollectionTable());
        GrailsDomainBinder.bindSimpleValue(GrailsDomainBinder.getIndexColumnType(property, STRING_TYPE), value, true, GrailsDomainBinder.getIndexColumnName(property), mappings);
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null) {
            GrailsDomainBinder.bindColumnConfigToColumn(GrailsDomainBinder.getColumnForSimpleValue(value), GrailsDomainBinder.getSingleColumnConfig(pc.getIndexColumn()));
        }
        if (!value.isTypeSpecified()) {
            throw new MappingException("map index element must specify a type: " + map.getRole());
        }
        map.setIndex((Value)value);
        if (!property.isOneToMany() && !property.isManyToMany()) {
            SimpleValue elt = new SimpleValue(map.getCollectionTable());
            map.setElement((Value)elt);
            String typeName = GrailsDomainBinder.getTypeName(property, GrailsDomainBinder.getPropertyConfig(property), GrailsDomainBinder.getMapping(property.getDomainClass()));
            if (typeName == null) {
                typeName = property.isBasicCollectionType() ? property.getReferencedPropertyType().getName() : Hibernate.STRING.getName();
            }
            GrailsDomainBinder.bindSimpleValue(typeName, elt, false, GrailsDomainBinder.getMapElementName(property), mappings);
            elt.setTypeName(typeName);
            map.setInverse(false);
        } else {
            map.setInverse(false);
        }
    }

    private static ColumnConfig getSingleColumnConfig(PropertyConfig propertyConfig) {
        java.util.List<ColumnConfig> columns;
        if (propertyConfig != null && (columns = propertyConfig.getColumns()) != null && !columns.isEmpty()) {
            return columns.get(0);
        }
        return null;
    }

    private static void bindListSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map<?, ?> persistentClasses, List list) {
        GrailsDomainBinder.bindCollectionSecondPass(property, mappings, persistentClasses, (Collection)list);
        String columnName = GrailsDomainBinder.getIndexColumnName(property);
        SimpleValue iv = new SimpleValue(list.getCollectionTable());
        GrailsDomainBinder.bindSimpleValue("integer", iv, true, columnName, mappings);
        iv.setTypeName("integer");
        list.setIndex((Value)iv);
        list.setBaseIndex(0);
        list.setInverse(false);
        Value v = list.getElement();
        v.createForeignKey();
        if (property.isBidirectional()) {
            String entityName;
            Value element = list.getElement();
            if (element instanceof ManyToOne) {
                ManyToOne manyToOne = (ManyToOne)element;
                entityName = manyToOne.getReferencedEntityName();
            } else {
                entityName = ((OneToMany)element).getReferencedEntityName();
            }
            PersistentClass referenced = mappings.getClass(entityName);
            boolean isManyToMany = property.isManyToMany();
            Class mappedClass = referenced.getMappedClass();
            Mapping m = GrailsDomainBinder.getMapping(mappedClass);
            if (!GrailsDomainBinder.isCompositeIdProperty(m, property.getOtherSide())) {
                Backref prop = new Backref();
                prop.setEntityName(property.getDomainClass().getFullName());
                prop.setName('_' + GrailsDomainBinder.addUnderscore(property.getDomainClass().getShortName(), property.getName()) + "Backref");
                prop.setSelectable(false);
                prop.setUpdateable(false);
                if (isManyToMany) {
                    prop.setInsertable(false);
                }
                prop.setCollectionRole(list.getRole());
                prop.setValue((Value)list.getKey());
                DependantValue value = (DependantValue)prop.getValue();
                if (!property.isCircular()) {
                    value.setNullable(false);
                }
                value.setUpdateable(true);
                prop.setOptional(false);
                referenced.addProperty((Property)prop);
            }
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + property.getName() + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            if (isManyToMany) {
                ib.setInsertable(false);
            }
            ib.setCollectionRole(list.getRole());
            ib.setEntityName(list.getOwner().getEntityName());
            ib.setValue(list.getIndex());
            referenced.addProperty((Property)ib);
        }
    }

    private static void bindCollectionSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map<?, ?> persistentClasses, Collection collection) {
        CacheConfig cacheConfig;
        GrailsDomainClassProperty otherSide;
        GrailsDomainClass referenced;
        PropertyConfig propConfig;
        PersistentClass associatedClass = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        if ((propConfig = GrailsDomainBinder.getPropertyConfig(property)) != null && !StringUtils.isBlank((String)propConfig.getSort())) {
            if (!property.isBidirectional() && property.isOneToMany()) {
                String message = "WARNING: Sorting by a child property does not work with unidirectional one to many relationships due to http://opensource.atlassian.com/projects/hibernate/browse/HHH-4394";
                LOG.warn((Object)message);
            }
            if ((referenced = property.getReferencedDomainClass()) != null) {
                GrailsDomainClassProperty propertyToSortBy = referenced.getPropertyByName(propConfig.getSort());
                String columnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(propertyToSortBy, EMPTY_PATH, null);
                if (propConfig.getOrder() != null) {
                    columnName = columnName + " " + propConfig.getOrder();
                }
                collection.setOrderBy(columnName);
            }
        }
        if (collection.isOneToMany()) {
            OneToMany oneToMany;
            String associatedClassName;
            boolean tablePerSubclass;
            referenced = property.getReferencedDomainClass();
            Mapping m = GrailsDomainBinder.getRootMapping(referenced);
            boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
            if (referenced != null && !referenced.isRoot() && !tablePerSubclass) {
                Mapping rootMapping = GrailsDomainBinder.getRootMapping(referenced);
                String discriminatorColumnName = "class";
                if (rootMapping != null) {
                    ColumnConfig discriminatorColumn = rootMapping.getDiscriminatorColumn();
                    if (discriminatorColumn != null) {
                        discriminatorColumnName = discriminatorColumn.getName();
                    }
                    if (rootMapping.getDiscriminatorMap().get("formula") != null) {
                        discriminatorColumnName = (String)m.getDiscriminatorMap().get("formula");
                    }
                }
                java.util.Set<String> discSet = GrailsDomainBinder.buildDiscriminatorSet(referenced);
                String inclause = StringUtils.join(discSet, (char)',');
                collection.setWhere(discriminatorColumnName + " in (" + inclause + ")");
            }
            if ((associatedClass = (PersistentClass)persistentClasses.get(associatedClassName = (oneToMany = (OneToMany)collection.getElement()).getReferencedEntityName())) == null) {
                throw new MappingException("Association references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(associatedClass);
            if (GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
                collection.setCollectionTable(associatedClass.getTable());
            }
            GrailsDomainBinder.bindCollectionForPropertyConfig(collection, propConfig);
        }
        if (GrailsDomainBinder.isSorted(property)) {
            collection.setSorted(true);
        }
        DependantValue key = GrailsDomainBinder.createPrimaryKeyValue(property, collection, persistentClasses);
        if (property.isBidirectional()) {
            otherSide = property.getOtherSide();
            if (otherSide.isManyToOne() && GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
                GrailsDomainBinder.linkBidirectionalOneToMany(collection, associatedClass, key, otherSide);
            } else if (property.isManyToMany() || java.util.Map.class.isAssignableFrom(property.getType())) {
                GrailsDomainBinder.bindDependentKeyValue(property, key, mappings);
            }
        } else if (GrailsDomainBinder.hasJoinKeyMapping(propConfig)) {
            GrailsDomainBinder.bindSimpleValue("long", (SimpleValue)key, false, propConfig.getJoinTable().getKey().getName(), mappings);
        } else {
            GrailsDomainBinder.bindDependentKeyValue(property, key, mappings);
        }
        collection.setKey((KeyValue)key);
        if (propConfig != null && (cacheConfig = propConfig.getCache()) != null) {
            collection.setCacheConcurrencyStrategy(cacheConfig.getUsage());
        }
        if (property.isManyToMany() || GrailsDomainBinder.isBidirectionalOneToManyMap(property)) {
            otherSide = property.getOtherSide();
            if (property.isBidirectional()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Mapping other side " + otherSide.getDomainClass().getName() + "." + otherSide.getName() + " -> " + collection.getCollectionTable().getName() + " as ManyToOne"));
                }
                ManyToOne element = new ManyToOne(collection.getCollectionTable());
                GrailsDomainBinder.bindManyToMany(otherSide, element, mappings);
                collection.setElement((Value)element);
                GrailsDomainBinder.bindCollectionForPropertyConfig(collection, propConfig);
                if (property.isCircular()) {
                    collection.setInverse(false);
                }
            }
        } else if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) {
            GrailsDomainBinder.bindCollectionWithJoinTable(property, mappings, collection, propConfig);
        } else if (GrailsDomainBinder.isUnidirectionalOneToMany(property)) {
            GrailsDomainBinder.bindUnidirectionalOneToMany(property, mappings, collection);
        }
    }

    private static java.util.Set<String> buildDiscriminatorSet(GrailsDomainClass domainClass) {
        HashSet<String> theSet = new HashSet<String>();
        Mapping mapping = GrailsDomainBinder.getMapping(domainClass);
        String discriminator = domainClass.getFullName();
        if (mapping != null && mapping.getDiscriminator() != null) {
            discriminator = mapping.getDiscriminator();
        }
        Mapping rootMapping = GrailsDomainBinder.getRootMapping(domainClass);
        String quote = "'";
        if (rootMapping != null && rootMapping.getDiscriminatorMap() != null && rootMapping.getDiscriminatorMap().get(ENUM_TYPE_PROP) != null && rootMapping.getDiscriminatorMap().get(ENUM_TYPE_PROP) != STRING_TYPE) {
            quote = EMPTY_PATH;
        }
        theSet.add(quote + discriminator + quote);
        for (GrailsDomainClass subClass : domainClass.getSubClasses()) {
            java.util.Set<String> subSet = GrailsDomainBinder.buildDiscriminatorSet(subClass);
            theSet.addAll(subSet);
        }
        return theSet;
    }

    private static Mapping getRootMapping(GrailsDomainClass referenced) {
        Class superClass;
        if (referenced == null) {
            return null;
        }
        Class current = referenced.getClazz();
        while (!Object.class.equals(superClass = current.getSuperclass())) {
            current = superClass;
        }
        return GrailsDomainBinder.getMapping(current);
    }

    private static boolean isBidirectionalOneToManyMap(GrailsDomainClassProperty property) {
        return java.util.Map.class.isAssignableFrom(property.getType()) && property.isBidirectional();
    }

    private static void bindCollectionWithJoinTable(GrailsDomainClassProperty property, Mappings mappings, Collection collection, PropertyConfig config) {
        SimpleValue element;
        if (property.isBasicCollectionType()) {
            element = new SimpleValue(collection.getCollectionTable());
        } else {
            element = new ManyToOne(collection.getCollectionTable());
            GrailsDomainBinder.bindUnidirectionalOneToManyInverseValues(property, (ManyToOne)element);
        }
        collection.setInverse(false);
        boolean hasJoinColumnMapping = GrailsDomainBinder.hasJoinColumnMapping(config);
        if (property.isBasicCollectionType()) {
            String columnName;
            Class referencedType = property.getReferencedPropertyType();
            String className = referencedType.getName();
            boolean isEnum = GrailsClassUtils.isJdk5Enum((Class)referencedType);
            if (hasJoinColumnMapping) {
                columnName = config.getJoinTable().getColumn().getName();
            } else {
                String string = columnName = isEnum ? namingStrategy.propertyToColumnName(className) : GrailsDomainBinder.addUnderscore(namingStrategy.propertyToColumnName(property.getName()), namingStrategy.propertyToColumnName(className));
            }
            if (isEnum) {
                GrailsDomainBinder.bindEnumType(property, referencedType, element, columnName);
            } else {
                Type type;
                String typeName = GrailsDomainBinder.getTypeName(property, config, GrailsDomainBinder.getMapping(property.getDomainClass()));
                if (typeName == null && (type = TypeFactory.basic((String)className)) != null) {
                    typeName = type.getName();
                }
                if (typeName == null) {
                    throw new MappingException("Type [" + typeName + "] is not a basic type or a domain class and cannot be mapped. Either specify a type within the [mapping] block or use a basic type (String, Integer etc.)");
                }
                GrailsDomainBinder.bindSimpleValue(typeName, element, true, columnName, mappings);
                if (hasJoinColumnMapping) {
                    GrailsDomainBinder.bindColumnConfigToColumn(GrailsDomainBinder.getColumnForSimpleValue(element), config.getJoinTable().getColumn());
                }
            }
        } else {
            GrailsDomainClass domainClass = property.getReferencedDomainClass();
            Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
            if (GrailsDomainBinder.hasCompositeIdentifier(m)) {
                CompositeIdentity ci = (CompositeIdentity)m.getIdentity();
                GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, element, ci, domainClass, EMPTY_PATH);
            } else {
                String columnName = hasJoinColumnMapping ? config.getJoinTable().getColumn().getName() : namingStrategy.propertyToColumnName(domainClass.getPropertyName()) + FOREIGN_KEY_SUFFIX;
                GrailsDomainBinder.bindSimpleValue("long", element, true, columnName, mappings);
            }
        }
        collection.setElement((Value)element);
        GrailsDomainBinder.bindCollectionForPropertyConfig(collection, config);
    }

    private static String addUnderscore(String s1, String s2) {
        return GrailsDomainBinder.removeBackticks(s1) + '_' + GrailsDomainBinder.removeBackticks(s2);
    }

    private static String removeBackticks(String s) {
        return s.startsWith(BACKTICK) && s.endsWith(BACKTICK) ? s.substring(1, s.length() - 1) : s;
    }

    private static Column getColumnForSimpleValue(SimpleValue element) {
        return (Column)element.getColumnIterator().next();
    }

    private static String getTypeName(GrailsDomainClassProperty property, PropertyConfig config, Mapping mapping) {
        String typeName = null;
        if (config != null && config.getType() != null) {
            Object typeObj = config.getType();
            typeName = typeObj instanceof Class ? ((Class)typeObj).getName() : typeObj.toString();
        } else if (mapping != null) {
            typeName = mapping.getTypeName(property.getType());
        }
        return typeName;
    }

    private static void bindColumnConfigToColumn(Column column, ColumnConfig columnConfig) {
        if (columnConfig != null) {
            column.setLength(columnConfig.getLength());
            column.setPrecision(columnConfig.getPrecision());
            column.setSqlType(columnConfig.getSqlType());
            column.setUnique(columnConfig.getUnique());
            column.setScale(columnConfig.getScale());
        }
    }

    private static boolean hasJoinColumnMapping(PropertyConfig config) {
        return config != null && config.getJoinTable() != null && config.getJoinTable().getColumn() != null;
    }

    private static boolean shouldCollectionBindWithJoinColumn(GrailsDomainClassProperty property) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        JoinTable jt = config != null ? config.getJoinTable() : new JoinTable();
        return (GrailsDomainBinder.isUnidirectionalOneToMany(property) || property.isBasicCollectionType()) && jt != null;
    }

    private static void bindUnidirectionalOneToManyInverseValues(GrailsDomainClassProperty property, ManyToOne manyToOne) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config != null) {
            manyToOne.setLazy(config.getLazy());
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
        } else {
            manyToOne.setLazy(true);
        }
        manyToOne.setReferencedEntityName(property.getReferencedPropertyType().getName());
    }

    private static void bindCollectionForPropertyConfig(Collection collection, PropertyConfig config) {
        if (config != null) {
            collection.setLazy(config.getLazy());
        } else {
            collection.setLazy(true);
            collection.setExtraLazy(false);
        }
    }

    public static PropertyConfig getPropertyConfig(GrailsDomainClassProperty property) {
        Mapping m = GrailsDomainBinder.getMapping(property.getDomainClass().getClazz());
        PropertyConfig config = m != null ? m.getPropertyConfig(property.getName()) : null;
        return config;
    }

    private static boolean isUnidirectionalOneToMany(GrailsDomainClassProperty property) {
        return property.isOneToMany() && !property.isBidirectional();
    }

    private static void bindDependentKeyValue(GrailsDomainClassProperty property, DependantValue key, Mappings mappings) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] binding  [" + property.getName() + "] with dependant key"));
        }
        GrailsDomainClass refDomainClass = property.getDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass.getClazz());
        if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property) && GrailsDomainBinder.hasCompositeIdentifier(mapping) || GrailsDomainBinder.hasCompositeIdentifier(mapping) && property.isManyToMany()) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, (SimpleValue)key, ci, refDomainClass, EMPTY_PATH);
        } else {
            GrailsDomainBinder.bindSimpleValue(property, null, (SimpleValue)key, EMPTY_PATH, mappings);
        }
    }

    private static DependantValue createPrimaryKeyValue(GrailsDomainClassProperty property, Collection collection, java.util.Map<?, ?> persistentClasses) {
        String propertyRef = collection.getReferencedPropertyName();
        KeyValue keyValue = propertyRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propertyRef).getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] creating dependant key value  to table [" + keyValue.getTable().getName() + "]"));
        }
        DependantValue key = new DependantValue(collection.getCollectionTable(), keyValue);
        key.setTypeName(null);
        key.setNullable(true);
        key.setUpdateable(false);
        return key;
    }

    private static void bindUnidirectionalOneToMany(GrailsDomainClassProperty property, Mappings mappings, Collection collection) {
        String entityName;
        Value v = collection.getElement();
        v.createForeignKey();
        if (v instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)v;
            entityName = manyToOne.getReferencedEntityName();
        } else {
            entityName = ((OneToMany)v).getReferencedEntityName();
        }
        collection.setInverse(false);
        PersistentClass referenced = mappings.getClass(entityName);
        Backref prop = new Backref();
        prop.setEntityName(property.getDomainClass().getFullName());
        prop.setName('_' + GrailsDomainBinder.addUnderscore(property.getDomainClass().getShortName(), property.getName()) + "Backref");
        prop.setUpdateable(false);
        prop.setInsertable(true);
        prop.setCollectionRole(collection.getRole());
        prop.setValue((Value)collection.getKey());
        prop.setOptional(true);
        referenced.addProperty((Property)prop);
    }

    private static Property getProperty(PersistentClass associatedClass, String propertyName) throws MappingException {
        try {
            return associatedClass.getProperty(propertyName);
        }
        catch (MappingException e) {
            if (associatedClass.getKey() instanceof Component) {
                return ((Component)associatedClass.getKey()).getProperty(propertyName);
            }
            throw e;
        }
    }

    private static void linkBidirectionalOneToMany(Collection collection, PersistentClass associatedClass, DependantValue key, GrailsDomainClassProperty otherSide) {
        collection.setInverse(true);
        Iterator mappedByColumns = GrailsDomainBinder.getProperty(associatedClass, otherSide.getName()).getValue().getColumnIterator();
        while (mappedByColumns.hasNext()) {
            Column column = (Column)mappedByColumns.next();
            GrailsDomainBinder.linkValueUsingAColumnCopy(otherSide, column, key);
        }
    }

    private static boolean isSorted(GrailsDomainClassProperty property) {
        return SortedSet.class.isAssignableFrom(property.getType());
    }

    private static void bindManyToMany(GrailsDomainClassProperty property, ManyToOne element, Mappings mappings) {
        GrailsDomainBinder.bindManyToOne(property, element, EMPTY_PATH, mappings);
        element.setReferencedEntityName(property.getDomainClass().getFullName());
    }

    private static void linkValueUsingAColumnCopy(GrailsDomainClassProperty prop, Column column, DependantValue key) {
        Column mappingColumn = new Column();
        mappingColumn.setName(column.getName());
        mappingColumn.setLength(column.getLength());
        mappingColumn.setNullable(prop.isOptional());
        mappingColumn.setSqlType(column.getSqlType());
        mappingColumn.setValue((Value)key);
        key.addColumn(mappingColumn);
        key.getTable().addColumn(mappingColumn);
    }

    private static void bindCollection(GrailsDomainClassProperty property, Collection collection, PersistentClass owner, Mappings mappings, String path) {
        String propertyName = GrailsDomainBinder.getNameForPropertyAndPath(property, path);
        collection.setRole(StringHelper.qualify((String)property.getDomainClass().getFullName(), (String)propertyName));
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (property.getFetchMode() == 1) {
            collection.setFetchMode(FetchMode.JOIN);
        } else if (pc != null && pc.getFetch() != null) {
            collection.setFetchMode(pc.getFetch());
        } else {
            collection.setFetchMode(FetchMode.DEFAULT);
        }
        if (GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
            OneToMany oneToMany = new OneToMany(collection.getOwner());
            collection.setElement((Value)oneToMany);
            GrailsDomainBinder.bindOneToMany(property, oneToMany, mappings);
        } else {
            GrailsDomainBinder.bindCollectionTable(property, mappings, collection, owner.getTable());
            if (!property.isOwningSide()) {
                collection.setInverse(true);
            }
        }
        if (pc != null && pc.getBatchSize() != null) {
            collection.setBatchSize(pc.getBatchSize().intValue());
        }
        if (collection instanceof Set) {
            mappings.addSecondPass((SecondPass)new GrailsCollectionSecondPass(property, mappings, collection));
        } else if (collection instanceof List) {
            mappings.addSecondPass((SecondPass)new ListSecondPass(property, mappings, collection));
        } else if (collection instanceof Map) {
            mappings.addSecondPass((SecondPass)new MapSecondPass(property, mappings, collection));
        }
    }

    private static boolean shouldBindCollectionWithForeignKey(GrailsDomainClassProperty property) {
        return (property.isOneToMany() && property.isBidirectional() || !GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) && !java.util.Map.class.isAssignableFrom(property.getType()) && !property.isManyToMany() && !property.isBasicCollectionType();
    }

    private static String getNameForPropertyAndPath(GrailsDomainClassProperty property, String path) {
        String propertyName = StringHelper.isNotEmpty((String)path) ? StringHelper.qualify((String)path, (String)property.getName()) : property.getName();
        return propertyName;
    }

    private static void bindCollectionTable(GrailsDomainClassProperty property, Mappings mappings, Collection collection, Table ownerTable) {
        String prefix = ownerTable.getSchema();
        String tableName = (prefix == null ? EMPTY_PATH : prefix + '.') + GrailsDomainBinder.calculateTableForMany(property);
        Table t = mappings.addTable(mappings.getSchemaName(), mappings.getCatalogName(), tableName, null, false);
        collection.setCollectionTable(t);
    }

    private static String calculateTableForMany(GrailsDomainClassProperty property) {
        String propertyColumnName = namingStrategy.propertyToColumnName(property.getName());
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        JoinTable jt = config != null ? config.getJoinTable() : null;
        boolean hasJoinTableMapping = jt != null && jt.getName() != null;
        String left = GrailsDomainBinder.getTableName(property.getDomainClass());
        if (java.util.Map.class.isAssignableFrom(property.getType())) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            return GrailsDomainBinder.addUnderscore(left, propertyColumnName);
        }
        if (property.isBasicCollectionType()) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            return GrailsDomainBinder.addUnderscore(left, propertyColumnName);
        }
        String right = GrailsDomainBinder.getTableName(property.getReferencedDomainClass());
        if (property.isManyToMany()) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            if (property.isOwningSide()) {
                return GrailsDomainBinder.addUnderscore(left, propertyColumnName);
            }
            return GrailsDomainBinder.addUnderscore(right, namingStrategy.propertyToColumnName(property.getOtherSide().getName()));
        }
        if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            left = GrailsDomainBinder.trimBackTigs(left);
            right = GrailsDomainBinder.trimBackTigs(right);
            return GrailsDomainBinder.addUnderscore(left, right);
        }
        if (property.isOwningSide()) {
            return GrailsDomainBinder.addUnderscore(left, right);
        }
        return GrailsDomainBinder.addUnderscore(right, left);
    }

    private static String trimBackTigs(String tableName) {
        if (tableName.startsWith(BACKTICK)) {
            return tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    private static String getTableName(GrailsDomainClass domainClass) {
        Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
        String tableName = null;
        if (m != null && m.getTableName() != null) {
            tableName = m.getTableName();
        }
        if (tableName == null) {
            tableName = namingStrategy.classToTableName(domainClass.getShortName());
        }
        return tableName;
    }

    public static void bindClass(GrailsDomainClass domainClass, Mappings mappings) throws MappingException {
        if (domainClass.isRoot()) {
            GrailsDomainBinder.bindRoot(domainClass, mappings);
        }
    }

    public static Mapping evaluateMapping(GrailsDomainClass domainClass) {
        return GrailsDomainBinder.evaluateMapping(domainClass, null);
    }

    public static Mapping evaluateMapping(GrailsDomainClass domainClass, Closure defaultMapping) {
        try {
            Object o = GrailsClassUtils.getStaticPropertyValue((Class)domainClass.getClazz(), (String)"mapping");
            if (o != null || defaultMapping != null) {
                HibernateMappingBuilder builder = new HibernateMappingBuilder(domainClass.getFullName());
                Mapping m = null;
                if (defaultMapping != null) {
                    m = builder.evaluate(defaultMapping);
                }
                if (o instanceof Closure) {
                    m = builder.evaluate((Closure)o);
                }
                MAPPING_CACHE.put(domainClass.getClazz(), m);
                return m;
            }
        }
        catch (Exception e) {
            GrailsUtil.deepSanitize((Throwable)e);
            throw new GrailsDomainException("Error evaluating ORM mappings block for domain [" + domainClass.getFullName() + "]:  " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Mapping getMapping(Class<?> theClass) {
        return theClass != null ? MAPPING_CACHE.get(theClass) : null;
    }

    public static Mapping getMapping(GrailsDomainClass domainClass) {
        return domainClass != null ? MAPPING_CACHE.get(domainClass.getClazz()) : null;
    }

    private static void bindClass(GrailsDomainClass domainClass, PersistentClass persistentClass, Mappings mappings) {
        persistentClass.setLazy(true);
        persistentClass.setEntityName(domainClass.getFullName());
        persistentClass.setProxyInterfaceName(domainClass.getFullName());
        persistentClass.setClassName(domainClass.getFullName());
        persistentClass.setDynamicInsert(false);
        persistentClass.setDynamicUpdate(false);
        persistentClass.setSelectBeforeUpdate(false);
        if (mappings.isAutoImport() && persistentClass.getEntityName().indexOf(46) > 0) {
            mappings.addImport(persistentClass.getEntityName(), StringHelper.unqualify((String)persistentClass.getEntityName()));
        }
    }

    public static void bindRoot(GrailsDomainClass domainClass, Mappings mappings) {
        if (mappings.getClass(domainClass.getFullName()) == null) {
            RootClass root = new RootClass();
            if (!domainClass.hasSubClasses()) {
                root.setPolymorphic(false);
            }
            GrailsDomainBinder.bindClass(domainClass, (PersistentClass)root, mappings);
            Mapping m = GrailsDomainBinder.getMapping(domainClass);
            GrailsDomainBinder.bindRootPersistentClassCommonValues(domainClass, root, mappings);
            if (!domainClass.getSubClasses().isEmpty()) {
                boolean tablePerSubclass;
                boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
                if (!tablePerSubclass) {
                    GrailsDomainBinder.bindDiscriminatorProperty(root.getTable(), root, mappings);
                }
                GrailsDomainBinder.bindSubClasses(domainClass, (PersistentClass)root, mappings);
            }
            if (root.getEntityPersisterClass() == null) {
                root.setEntityPersisterClass(GroovyAwareSingleTableEntityPersister.class);
            }
            mappings.addClass((PersistentClass)root);
        } else {
            LOG.info((Object)("[GrailsDomainBinder] Class [" + domainClass.getFullName() + "] is already mapped, skipping.. "));
        }
    }

    private static void bindSubClasses(GrailsDomainClass domainClass, PersistentClass parent, Mappings mappings) {
        java.util.Set subClasses = domainClass.getSubClasses();
        for (GrailsDomainClass sub : subClasses) {
            if (!sub.getClazz().getSuperclass().equals(domainClass.getClazz())) continue;
            GrailsDomainBinder.bindSubClass(sub, parent, mappings);
        }
    }

    private static void bindSubClass(GrailsDomainClass sub, PersistentClass parent, Mappings mappings) {
        JoinedSubclass subClass;
        boolean tablePerSubclass;
        GrailsDomainBinder.evaluateMapping(sub);
        Mapping m = GrailsDomainBinder.getMapping(parent.getMappedClass());
        boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
        if (tablePerSubclass) {
            subClass = new JoinedSubclass(parent);
        } else {
            subClass = new SingleTableSubclass(parent);
            Mapping subMapping = GrailsDomainBinder.getMapping(sub);
            subClass.setDiscriminatorValue(subMapping != null && subMapping.getDiscriminator() != null ? subMapping.getDiscriminator() : sub.getFullName());
        }
        subClass.setEntityName(sub.getFullName());
        parent.addSubclass((Subclass)subClass);
        mappings.addClass((PersistentClass)subClass);
        if (tablePerSubclass) {
            GrailsDomainBinder.bindJoinedSubClass(sub, subClass, mappings, m);
        } else {
            GrailsDomainBinder.bindSubClass(sub, (Subclass)subClass, mappings);
        }
        if (!sub.getSubClasses().isEmpty()) {
            GrailsDomainBinder.bindSubClasses(sub, (PersistentClass)subClass, mappings);
        }
    }

    private static void bindJoinedSubClass(GrailsDomainClass sub, JoinedSubclass joinedSubclass, Mappings mappings, Mapping gormMapping) {
        GrailsDomainBinder.bindClass(sub, (PersistentClass)joinedSubclass, mappings);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(GroovyAwareJoinedSubclassEntityPersister.class);
        }
        Table mytable = mappings.addTable(mappings.getSchemaName(), mappings.getCatalogName(), GrailsDomainBinder.getJoinedSubClassTableName(sub, (PersistentClass)joinedSubclass, null, mappings), null, false);
        joinedSubclass.setTable(mytable);
        LOG.info((Object)("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName()));
        DependantValue key = new DependantValue(mytable, joinedSubclass.getIdentifier());
        joinedSubclass.setKey((KeyValue)key);
        GrailsDomainClassProperty identifier = sub.getIdentifier();
        String columnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(identifier, EMPTY_PATH, null);
        GrailsDomainBinder.bindSimpleValue(identifier.getType().getName(), (SimpleValue)key, false, columnName, mappings);
        joinedSubclass.createPrimaryKey();
        GrailsDomainBinder.createClassProperties(sub, (PersistentClass)joinedSubclass, mappings);
    }

    private static String getJoinedSubClassTableName(GrailsDomainClass sub, PersistentClass model, Table denormalizedSuperTable, Mappings mappings) {
        String logicalTableName = StringHelper.unqualify((String)model.getEntityName());
        String physicalTableName = GrailsDomainBinder.getTableName(sub);
        mappings.addTableBinding(mappings.getSchemaName(), mappings.getCatalogName(), logicalTableName, physicalTableName, denormalizedSuperTable);
        return physicalTableName;
    }

    private static void bindSubClass(GrailsDomainClass sub, Subclass subClass, Mappings mappings) {
        GrailsDomainBinder.bindClass(sub, (PersistentClass)subClass, mappings);
        if (subClass.getEntityPersisterClass() == null) {
            subClass.getRootClass().setEntityPersisterClass(GroovyAwareSingleTableEntityPersister.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping subclass: " + subClass.getEntityName() + " -> " + subClass.getTable().getName()));
        }
        GrailsDomainBinder.createClassProperties(sub, (PersistentClass)subClass, mappings);
    }

    private static void bindDiscriminatorProperty(Table table, RootClass entity, Mappings mappings) {
        Mapping m = GrailsDomainBinder.getMapping(entity.getMappedClass());
        SimpleValue d = new SimpleValue(table);
        entity.setDiscriminator((Value)d);
        entity.setDiscriminatorValue(m != null && m.getDiscriminator() != null ? m.getDiscriminator() : entity.getClassName());
        if (m != null && m.getDiscriminatorMap().get("insert") != null) {
            entity.setDiscriminatorInsertable(((Boolean)m.getDiscriminatorMap().get("insert")).booleanValue());
        }
        if (m != null && m.getDiscriminatorMap().get(ENUM_TYPE_PROP) != null) {
            d.setTypeName((String)m.getDiscriminatorMap().get(ENUM_TYPE_PROP));
        }
        if (m != null && m.getDiscriminatorMap().get("formula") != null) {
            Formula formula = new Formula();
            formula.setFormula((String)m.getDiscriminatorMap().get("formula"));
            d.addFormula(formula);
        } else {
            ColumnConfig cc;
            GrailsDomainBinder.bindSimpleValue(STRING_TYPE, d, false, "class", mappings);
            ColumnConfig columnConfig = cc = m != null ? m.getDiscriminatorColumn() : null;
            if (cc != null) {
                Column c = (Column)d.getColumnIterator().next();
                if (cc.getName() != null) {
                    c.setName(cc.getName());
                }
                GrailsDomainBinder.bindColumnConfigToColumn(c, cc);
            }
        }
        entity.setPolymorphic(true);
    }

    private static void bindRootPersistentClassCommonValues(GrailsDomainClass domainClass, RootClass root, Mappings mappings) {
        boolean hasTableDefinition;
        Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
        String schema = mappings.getSchemaName();
        String catalog = mappings.getCatalogName();
        if (m != null) {
            Integer bs;
            CacheConfig cc = m.getCache();
            if (cc != null && cc.getEnabled()) {
                root.setCacheConcurrencyStrategy(cc.getUsage());
                root.setLazyPropertiesCacheable(!"non-lazy".equals(cc.getInclude()));
            }
            if ((bs = m.getBatchSize()) != null) {
                root.setBatchSize(bs.intValue());
            }
            if (m.getDynamicUpdate()) {
                root.setDynamicUpdate(true);
            }
            if (m.getDynamicInsert()) {
                root.setDynamicInsert(true);
            }
        }
        boolean bl = hasTableDefinition = m != null && m.getTable() != null;
        if (hasTableDefinition && m.getTable().getSchema() != null) {
            schema = m.getTable().getSchema();
        }
        if (hasTableDefinition && m.getTable().getCatalog() != null) {
            catalog = m.getTable().getCatalog();
        }
        Table table = mappings.addTable(schema, catalog, GrailsDomainBinder.getTableName(domainClass), null, false);
        root.setTable(table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] Mapping Grails domain class: " + domainClass.getFullName() + " -> " + root.getTable().getName()));
        }
        GrailsDomainBinder.bindIdentity(domainClass, root, mappings, m);
        if (m != null) {
            if (m.getVersioned()) {
                GrailsDomainBinder.bindVersion(domainClass.getVersion(), root, mappings);
            }
        } else {
            GrailsDomainBinder.bindVersion(domainClass.getVersion(), root, mappings);
        }
        root.createPrimaryKey();
        GrailsDomainBinder.createClassProperties(domainClass, (PersistentClass)root, mappings);
    }

    private static void bindIdentity(GrailsDomainClass domainClass, RootClass root, Mappings mappings, Mapping gormMapping) {
        GrailsDomainClassProperty identifierProp = domainClass.getIdentifier();
        if (gormMapping != null) {
            Object id = gormMapping.getIdentity();
            if (id instanceof CompositeIdentity) {
                GrailsDomainBinder.bindCompositeId(domainClass, root, (CompositeIdentity)id, mappings);
            } else {
                Identity identity = (Identity)id;
                String propertyName = identity.getName();
                if (propertyName != null) {
                    GrailsDomainClassProperty namedIdentityProp = domainClass.getPropertyByName(propertyName);
                    if (namedIdentityProp == null) {
                        throw new MappingException("Mapping specifies an identifier property name that doesn't exist [" + propertyName + "]");
                    }
                    if (!namedIdentityProp.equals(identifierProp)) {
                        identifierProp = namedIdentityProp;
                    }
                }
                GrailsDomainBinder.bindSimpleId(identifierProp, root, mappings, identity);
            }
        } else {
            GrailsDomainBinder.bindSimpleId(identifierProp, root, mappings, null);
        }
    }

    private static void bindCompositeId(GrailsDomainClass domainClass, RootClass root, CompositeIdentity compositeIdentity, Mappings mappings) {
        String[] props;
        Component id = new Component((PersistentClass)root);
        id.setNullValue("undefined");
        root.setIdentifier((KeyValue)id);
        root.setEmbeddedIdentifier(true);
        id.setComponentClassName(domainClass.getFullName());
        id.setKey(true);
        id.setEmbedded(true);
        String path = StringHelper.qualify((String)root.getEntityName(), (String)"id");
        id.setRoleName(path);
        for (String propName : props = compositeIdentity.getPropertyNames()) {
            GrailsDomainClassProperty property = domainClass.getPropertyByName(propName);
            if (property == null) {
                throw new MappingException("Property [" + propName + "] referenced in composite-id mapping of class [" + domainClass.getFullName() + "] is not a valid property!");
            }
            GrailsDomainBinder.bindComponentProperty(id, null, property, (PersistentClass)root, EMPTY_PATH, root.getTable(), mappings);
        }
    }

    protected static void createClassProperties(GrailsDomainClass domainClass, PersistentClass persistentClass, Mappings mappings) {
        GrailsDomainClassProperty[] persistentProperties = domainClass.getPersistentProperties();
        Table table = persistentClass.getTable();
        Mapping gormMapping = GrailsDomainBinder.getMapping(domainClass.getClazz());
        for (GrailsDomainClassProperty currentGrailsProp : persistentProperties) {
            boolean isBidirectionalManyToOne = GrailsDomainBinder.isBidirectionalManyToOne(currentGrailsProp);
            if (currentGrailsProp.isInherited() || currentGrailsProp.isInherited() && isBidirectionalManyToOne && currentGrailsProp.isCircular() || GrailsDomainBinder.isCompositeIdProperty(gormMapping, currentGrailsProp) || GrailsDomainBinder.isIdentityProperty(gormMapping, currentGrailsProp)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding persistent property [" + currentGrailsProp.getName() + "]"));
            }
            SimpleValue value = null;
            CollectionType collectionType = CollectionType.collectionTypeForClass(currentGrailsProp.getType());
            Class<?> userType = GrailsDomainBinder.getUserType(currentGrailsProp);
            if (collectionType != null) {
                Collection collection = collectionType.create(currentGrailsProp, persistentClass, EMPTY_PATH, mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if (currentGrailsProp.isEnum()) {
                value = new SimpleValue(table);
                GrailsDomainBinder.bindEnumType(currentGrailsProp, value, EMPTY_PATH);
            } else if (currentGrailsProp.isManyToOne()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
                }
                value = new ManyToOne(table);
                GrailsDomainBinder.bindManyToOne(currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings);
            } else if (currentGrailsProp.isOneToOne() && userType == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
                }
                if (currentGrailsProp.isHasOne() && !currentGrailsProp.isBidirectional()) {
                    throw new MappingException("hasOne property [" + currentGrailsProp.getDomainClass().getName() + "." + currentGrailsProp.getName() + "] is not bidirectional. Specify the other side of the relationship!");
                }
                if (GrailsDomainBinder.canBindOneToOneWithSingleColumnAndForeignKey(currentGrailsProp)) {
                    value = new OneToOne(table, persistentClass);
                    GrailsDomainBinder.bindOneToOne(currentGrailsProp, (OneToOne)value, EMPTY_PATH);
                } else if (currentGrailsProp.isHasOne() && currentGrailsProp.isBidirectional()) {
                    value = new OneToOne(table, persistentClass);
                    GrailsDomainBinder.bindOneToOne(currentGrailsProp, (OneToOne)value, EMPTY_PATH);
                } else {
                    value = new ManyToOne(table);
                    GrailsDomainBinder.bindManyToOne(currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings);
                }
            } else if (currentGrailsProp.isEmbedded()) {
                value = new Component(persistentClass);
                GrailsDomainBinder.bindComponent((Component)value, currentGrailsProp, true, mappings);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
                }
                value = new SimpleValue(table);
                GrailsDomainBinder.bindSimpleValue(currentGrailsProp, null, value, EMPTY_PATH, mappings);
            }
            if (value == null) continue;
            Property property = GrailsDomainBinder.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            persistentClass.addProperty(property);
        }
        GrailsDomainBinder.bindNaturalIdentifier(table, gormMapping, persistentClass);
    }

    private static void bindNaturalIdentifier(Table table, Mapping mapping, PersistentClass persistentClass) {
        Identity identity;
        NaturalId naturalId;
        Object o;
        Object object = o = mapping != null ? mapping.getIdentity() : null;
        if (o instanceof Identity && (naturalId = (identity = (Identity)o).getNatural()) != null && !naturalId.getPropertyNames().isEmpty()) {
            UniqueKey uk = new UniqueKey();
            uk.setName("_UniqueKey");
            uk.setTable(table);
            boolean mutable = naturalId.isMutable();
            for (String propertyName : naturalId.getPropertyNames()) {
                Property property = persistentClass.getProperty(propertyName);
                property.setNaturalIdentifier(true);
                if (!mutable) {
                    property.setUpdateable(false);
                }
                uk.addColumns(property.getColumnIterator());
            }
            table.addUniqueKey(uk);
        }
    }

    private static boolean canBindOneToOneWithSingleColumnAndForeignKey(GrailsDomainClassProperty currentGrailsProp) {
        if (currentGrailsProp.isBidirectional()) {
            GrailsDomainClassProperty otherSide = currentGrailsProp.getOtherSide();
            if (otherSide.isHasOne()) {
                return false;
            }
            if (!currentGrailsProp.isOwningSide() && otherSide != null && otherSide.isOwningSide()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdentityProperty(Mapping gormMapping, GrailsDomainClassProperty currentGrailsProp) {
        Identity identity;
        Object identityMapping;
        return gormMapping != null && (identityMapping = gormMapping.getIdentity()) instanceof Identity && (identity = (Identity)identityMapping).getName() != null && identity.getName() != null && identity.getName().equals(currentGrailsProp.getName());
    }

    private static void bindEnumType(GrailsDomainClassProperty property, SimpleValue simpleValue, String path) {
        GrailsDomainBinder.bindEnumType(property, property.getType(), simpleValue, GrailsDomainBinder.getColumnNameForPropertyAndPath(property, path, null));
    }

    private static void bindEnumType(GrailsDomainClassProperty property, Class<?> propertyType, SimpleValue simpleValue, String columnName) {
        String enumType;
        Properties enumProperties = new Properties();
        enumProperties.put(ENUM_CLASS_PROP, propertyType.getName());
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        String string = enumType = pc != null ? pc.getEnumType() : DEFAULT_ENUM_TYPE;
        if (enumType.equals(DEFAULT_ENUM_TYPE) && IdentityEnumType.supports(propertyType)) {
            simpleValue.setTypeName(IdentityEnumType.class.getName());
        } else {
            simpleValue.setTypeName(ENUM_TYPE_CLASS);
            if (enumType.equals(DEFAULT_ENUM_TYPE) || STRING_TYPE.equalsIgnoreCase(enumType)) {
                enumProperties.put(ENUM_TYPE_PROP, String.valueOf(12));
            } else if (!"ordinal".equalsIgnoreCase(enumType)) {
                LOG.warn((Object)("Invalid enumType specified when mapping property [" + property.getName() + "] of class [" + property.getDomainClass().getClazz().getName() + "]. Using defaults instead."));
            }
        }
        simpleValue.setTypeParameters(enumProperties);
        Table t = simpleValue.getTable();
        Column column = new Column();
        if (property.getDomainClass().isRoot()) {
            column.setNullable(property.isOptional());
        } else {
            Mapping mapping = GrailsDomainBinder.getMapping(property.getDomainClass());
            if (mapping == null || mapping.getTablePerHierarchy()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Sub class property [" + property.getName() + "] for column name [" + column.getName() + "] set to nullable"));
                }
                column.setNullable(true);
            } else {
                column.setNullable(property.isOptional());
            }
        }
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
        PropertyConfig propertyConfig = GrailsDomainBinder.getPropertyConfig(property);
        if (propertyConfig != null && !propertyConfig.getColumns().isEmpty()) {
            GrailsDomainBinder.bindIndex(column, propertyConfig.getColumns().get(0), t);
        }
    }

    private static Class<?> getUserType(GrailsDomainClassProperty currentGrailsProp) {
        Class<?> userType;
        block5: {
            Object typeObj;
            userType = null;
            PropertyConfig config = GrailsDomainBinder.getPropertyConfig(currentGrailsProp);
            Object object = typeObj = config != null ? config.getType() : null;
            if (typeObj instanceof Class) {
                userType = (Class<?>)typeObj;
            } else if (typeObj != null) {
                String typeName = typeObj.toString();
                try {
                    userType = Class.forName(typeName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (typeName.indexOf(".") <= -1 || !LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)"UserType not found ", (Throwable)e);
                }
            }
        }
        return userType;
    }

    private static boolean isCompositeIdProperty(Mapping gormMapping, GrailsDomainClassProperty currentGrailsProp) {
        CompositeIdentity cid;
        Object id;
        return gormMapping != null && gormMapping.getIdentity() != null && (id = gormMapping.getIdentity()) instanceof CompositeIdentity && ArrayUtils.contains((Object[])(cid = (CompositeIdentity)id).getPropertyNames(), (Object)currentGrailsProp.getName());
    }

    private static boolean isBidirectionalManyToOne(GrailsDomainClassProperty currentGrailsProp) {
        return currentGrailsProp.isBidirectional() && currentGrailsProp.isManyToOne();
    }

    private static void bindComponent(Component component, GrailsDomainClassProperty property, boolean isNullable, Mappings mappings) {
        component.setEmbedded(true);
        Class type = property.getType();
        String role = StringHelper.qualify((String)type.getName(), (String)property.getName());
        component.setRoleName(role);
        component.setComponentClassName(type.getName());
        GrailsDomainClass domainClass = property.getReferencedDomainClass() != null ? property.getReferencedDomainClass() : property.getComponent();
        GrailsDomainBinder.evaluateMapping(domainClass);
        GrailsDomainClassProperty[] properties = domainClass.getPersistentProperties();
        Table table = component.getOwner().getTable();
        PersistentClass persistentClass = component.getOwner();
        String path = property.getName();
        Class propertyType = property.getDomainClass().getClazz();
        for (GrailsDomainClassProperty currentGrailsProp : properties) {
            if (currentGrailsProp.isIdentity() || currentGrailsProp.getName().equals("version")) continue;
            if (currentGrailsProp.getType().equals(propertyType)) {
                component.setParentProperty(currentGrailsProp.getName());
                continue;
            }
            GrailsDomainBinder.bindComponentProperty(component, property, currentGrailsProp, persistentClass, path, table, mappings);
        }
    }

    private static void bindComponentProperty(Component component, GrailsDomainClassProperty componentProperty, GrailsDomainClassProperty currentGrailsProp, PersistentClass persistentClass, String path, Table table, Mappings mappings) {
        ManyToOne value = null;
        CollectionType collectionType = CollectionType.collectionTypeForClass(currentGrailsProp.getType());
        if (collectionType != null) {
            Collection collection = collectionType.create(currentGrailsProp, persistentClass, path, mappings);
            mappings.addCollection(collection);
            value = collection;
        } else if (currentGrailsProp.isManyToOne()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
            }
            value = new ManyToOne(table);
            GrailsDomainBinder.bindManyToOne(currentGrailsProp, value, path, mappings);
        } else if (currentGrailsProp.isOneToOne()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
            }
            if (GrailsDomainBinder.canBindOneToOneWithSingleColumnAndForeignKey(currentGrailsProp)) {
                value = new OneToOne(table, persistentClass);
                GrailsDomainBinder.bindOneToOne(currentGrailsProp, (OneToOne)value, path);
            } else {
                value = new ManyToOne(table);
                GrailsDomainBinder.bindManyToOne(currentGrailsProp, value, path, mappings);
            }
        } else if (currentGrailsProp.isEmbedded()) {
            value = new Component(persistentClass);
            GrailsDomainBinder.bindComponent((Component)value, currentGrailsProp, true, mappings);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
            }
            value = new SimpleValue(table);
            if (currentGrailsProp.isEnum()) {
                GrailsDomainBinder.bindEnumType(currentGrailsProp, (SimpleValue)value, path);
            } else {
                GrailsDomainBinder.bindSimpleValue(currentGrailsProp, componentProperty, (SimpleValue)value, path, mappings);
            }
        }
        if (value != null) {
            Property persistentProperty = GrailsDomainBinder.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            component.addProperty(persistentProperty);
            if (GrailsDomainBinder.isComponentPropertyNullable(componentProperty)) {
                Iterator columnIterator = value.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column c = (Column)columnIterator.next();
                    c.setNullable(true);
                }
            }
        }
    }

    private static boolean isComponentPropertyNullable(GrailsDomainClassProperty componentProperty) {
        if (componentProperty == null) {
            return false;
        }
        GrailsDomainClass domainClass = componentProperty.getDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(domainClass.getClazz());
        return !domainClass.isRoot() && (mapping == null || mapping.isTablePerHierarchy()) || componentProperty.isOptional();
    }

    private static Property createProperty(Value value, PersistentClass persistentClass, GrailsDomainClassProperty grailsProperty, Mappings mappings) {
        value.setTypeUsingReflection(persistentClass.getClassName(), grailsProperty.getName());
        if (value.getTable() != null) {
            value.createForeignKey();
        }
        Property prop = new Property();
        prop.setValue(value);
        GrailsDomainBinder.bindProperty(grailsProperty, prop, mappings);
        return prop;
    }

    private static void bindOneToMany(GrailsDomainClassProperty currentGrailsProp, OneToMany one, Mappings mappings) {
        one.setReferencedEntityName(currentGrailsProp.getReferencedPropertyType().getName());
        one.setIgnoreNotFound(true);
    }

    private static void bindManyToOne(GrailsDomainClassProperty property, ManyToOne manyToOne, String path, Mappings mappings) {
        GrailsDomainBinder.bindManyToOneValues(property, manyToOne);
        GrailsDomainClass refDomainClass = property.isManyToMany() ? property.getDomainClass() : property.getReferencedDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass);
        if (GrailsDomainBinder.hasCompositeIdentifier(mapping)) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, (SimpleValue)manyToOne, ci, refDomainClass, path);
        } else if (property.isCircular() && property.isManyToMany()) {
            PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
            if (pc == null) {
                if (mapping == null) {
                    mapping = new Mapping();
                    MAPPING_CACHE.put(refDomainClass.getClazz(), mapping);
                }
                pc = new PropertyConfig();
                mapping.getColumns().put(property.getName(), pc);
            }
            if (!GrailsDomainBinder.hasJoinKeyMapping(pc)) {
                JoinTable jt = new JoinTable();
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(namingStrategy.propertyToColumnName(property.getName()) + '_' + FOREIGN_KEY_SUFFIX);
                jt.setKey(columnConfig);
                pc.setJoinTable(jt);
            }
            GrailsDomainBinder.bindSimpleValue(property, (SimpleValue)manyToOne, path, pc);
        } else {
            GrailsDomainBinder.bindSimpleValue(property, null, (SimpleValue)manyToOne, path, mappings);
        }
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (property.isOneToOne()) {
            manyToOne.setAlternateUniqueKey(true);
            Column c = GrailsDomainBinder.getColumnForSimpleValue((SimpleValue)manyToOne);
            if (config != null) {
                c.setUnique(config.isUnique());
            } else if (property.isBidirectional() && property.getOtherSide().isHasOne()) {
                c.setUnique(true);
            }
        }
    }

    private static void bindCompositeIdentifierToManyToOne(GrailsDomainClassProperty property, SimpleValue value, CompositeIdentity compositeId, GrailsDomainClass refDomainClass, String path) {
        String[] propertyNames = compositeId.getPropertyNames();
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config == null) {
            config = new PropertyConfig();
        }
        for (String propertyName : propertyNames) {
            ColumnConfig cc = new ColumnConfig();
            cc.setName(GrailsDomainBinder.addUnderscore(namingStrategy.classToTableName(refDomainClass.getShortName()), GrailsDomainBinder.getDefaultColumnName(refDomainClass.getPropertyByName(propertyName))));
            config.getColumns().add(cc);
        }
        GrailsDomainBinder.bindSimpleValue(property, value, path, config);
    }

    private static boolean hasCompositeIdentifier(Mapping mapping) {
        return mapping != null && mapping.getIdentity() instanceof CompositeIdentity;
    }

    private static void bindOneToOne(GrailsDomainClassProperty property, OneToOne oneToOne, String path) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        GrailsDomainClassProperty otherSide = property.getOtherSide();
        oneToOne.setConstrained(otherSide.isHasOne());
        oneToOne.setForeignKeyType(oneToOne.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        oneToOne.setAlternateUniqueKey(true);
        if (config != null && config.getFetch() != null) {
            oneToOne.setFetchMode(config.getFetch());
        } else {
            oneToOne.setFetchMode(FetchMode.DEFAULT);
        }
        oneToOne.setReferencedEntityName(otherSide.getDomainClass().getFullName());
        oneToOne.setPropertyName(property.getName());
        if (otherSide.isHasOne()) {
            PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
            GrailsDomainBinder.bindSimpleValue(property, (SimpleValue)oneToOne, path, pc);
        } else {
            oneToOne.setReferencedPropertyName(otherSide.getName());
        }
    }

    private static void bindManyToOneValues(GrailsDomainClassProperty property, ManyToOne manyToOne) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config != null && config.getFetch() != null) {
            manyToOne.setFetchMode(config.getFetch());
        } else {
            manyToOne.setFetchMode(FetchMode.DEFAULT);
        }
        manyToOne.setLazy(GrailsDomainBinder.getLazyiness(property));
        if (config != null) {
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
        }
        manyToOne.setReferencedEntityName(property.getReferencedPropertyType().getName());
    }

    private static void bindVersion(GrailsDomainClassProperty version, RootClass entity, Mappings mappings) {
        SimpleValue val = new SimpleValue(entity.getTable());
        GrailsDomainBinder.bindSimpleValue(version, null, val, EMPTY_PATH, mappings);
        if (val.isTypeSpecified()) {
            if (!(val.getType() instanceof IntegerType || val.getType() instanceof LongType || val.getType() instanceof TimestampType)) {
                LOG.warn((Object)("Invalid version class specified in " + version.getDomainClass().getClazz().getName() + "; must be one of [int, Integer, long, Long, Timestamp, Date]. Not mapping the version."));
                return;
            }
        } else {
            val.setTypeName("version".equals(version.getName()) ? "integer" : "timestamp");
        }
        Property prop = new Property();
        prop.setValue((Value)val);
        GrailsDomainBinder.bindProperty(version, prop, mappings);
        val.setNullValue("undefined");
        entity.setVersion(prop);
        entity.addProperty(prop);
    }

    private static void bindSimpleId(GrailsDomainClassProperty identifier, RootClass entity, Mappings mappings, Identity mappedId) {
        SimpleValue id = new SimpleValue(entity.getTable());
        Properties params = new Properties();
        entity.setIdentifier((KeyValue)id);
        if (mappedId != null) {
            id.setIdentifierGeneratorStrategy(mappedId.getGenerator());
            params.putAll((java.util.Map<?, ?>)mappedId.getParams());
            if ("assigned".equals(mappedId.getGenerator())) {
                id.setNullValue("undefined");
            }
        } else {
            id.setIdentifierGeneratorStrategy("native");
        }
        if (mappings.getSchemaName() != null) {
            params.setProperty("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            params.setProperty("catalog", mappings.getCatalogName());
        }
        id.setIdentifierGeneratorProperties(params);
        GrailsDomainBinder.bindSimpleValue(identifier, null, id, EMPTY_PATH, mappings);
        Property prop = new Property();
        prop.setValue((Value)id);
        GrailsDomainBinder.bindProperty(identifier, prop, mappings);
        entity.setIdentifierProperty(prop);
        id.getTable().setIdentifierValue((KeyValue)id);
    }

    private static void bindProperty(GrailsDomainClassProperty grailsProperty, Property prop, Mappings mappings) {
        boolean isLazyable;
        prop.setName(grailsProperty.getName());
        if (GrailsDomainBinder.isBidirectionalManyToOneWithListMapping(grailsProperty, prop)) {
            prop.setInsertable(false);
            prop.setUpdateable(false);
        } else {
            prop.setInsertable(GrailsDomainBinder.getInsertableness(grailsProperty));
            prop.setUpdateable(GrailsDomainBinder.getUpdateableness(grailsProperty));
        }
        prop.setPropertyAccessorName(mappings.getDefaultAccess());
        prop.setOptional(grailsProperty.isOptional());
        GrailsDomainBinder.setCascadeBehaviour(grailsProperty, prop);
        boolean bl = isLazyable = grailsProperty.isOneToOne() || grailsProperty.isManyToOne() || grailsProperty.isEmbedded() || grailsProperty.isPersistent() && !grailsProperty.isAssociation() && !grailsProperty.isIdentity();
        if (isLazyable) {
            boolean isLazy = GrailsDomainBinder.getLazyiness(grailsProperty);
            prop.setLazy(isLazy);
            if (isLazy && (grailsProperty.isManyToOne() || grailsProperty.isOneToOne())) {
                HibernatePluginSupport.handleLazyProxy(grailsProperty.getDomainClass(), grailsProperty);
            }
        }
    }

    private static boolean getLazyiness(GrailsDomainClassProperty grailsProperty) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        boolean isLazy = config != null ? config.getLazy() : true;
        return isLazy;
    }

    private static boolean getInsertableness(GrailsDomainClassProperty grailsProperty) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        boolean isInsertable = config != null ? config.getInsertable() : true;
        return isInsertable;
    }

    private static boolean getUpdateableness(GrailsDomainClassProperty grailsProperty) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        boolean isUpdateable = config != null ? config.getUpdateable() : true;
        return isUpdateable;
    }

    private static boolean isBidirectionalManyToOneWithListMapping(GrailsDomainClassProperty grailsProperty, Property prop) {
        GrailsDomainClassProperty otherSide = grailsProperty.getOtherSide();
        return grailsProperty.isBidirectional() && otherSide != null && prop.getValue() instanceof ManyToOne && java.util.List.class.isAssignableFrom(otherSide.getType());
    }

    private static void setCascadeBehaviour(GrailsDomainClassProperty grailsProperty, Property prop) {
        String cascadeStrategy = CASCADE_NONE;
        GrailsDomainClass domainClass = grailsProperty.getDomainClass();
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        GrailsDomainClass referenced = grailsProperty.getReferencedDomainClass();
        if (config != null && config.getCascade() != null) {
            cascadeStrategy = config.getCascade();
        } else if (grailsProperty.isAssociation()) {
            if (grailsProperty.isHasOne()) {
                cascadeStrategy = CASCADE_ALL;
            } else if (grailsProperty.isOneToOne()) {
                if (referenced != null && referenced.isOwningClass(domainClass.getClazz())) {
                    cascadeStrategy = CASCADE_ALL;
                }
            } else if (grailsProperty.isOneToMany()) {
                cascadeStrategy = referenced != null && referenced.isOwningClass(domainClass.getClazz()) ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
            } else if (grailsProperty.isManyToMany()) {
                if (referenced != null && referenced.isOwningClass(domainClass.getClazz()) || grailsProperty.isCircular()) {
                    cascadeStrategy = CASCADE_SAVE_UPDATE;
                }
            } else if (grailsProperty.isManyToOne()) {
                cascadeStrategy = referenced != null && referenced.isOwningClass(domainClass.getClazz()) && !GrailsDomainBinder.isCircularAssociation(grailsProperty) ? CASCADE_ALL : CASCADE_NONE;
            }
        } else if (grailsProperty.isBasicCollectionType()) {
            cascadeStrategy = CASCADE_ALL;
        } else if (java.util.Map.class.isAssignableFrom(grailsProperty.getType())) {
            referenced = grailsProperty.getReferencedDomainClass();
            cascadeStrategy = referenced != null && referenced.isOwningClass(grailsProperty.getDomainClass().getClazz()) ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
        }
        GrailsDomainBinder.logCascadeMapping(grailsProperty, cascadeStrategy, referenced);
        prop.setCascade(cascadeStrategy);
    }

    private static boolean isCircularAssociation(GrailsDomainClassProperty grailsProperty) {
        return grailsProperty.getType().equals(grailsProperty.getDomainClass().getClazz());
    }

    private static void logCascadeMapping(GrailsDomainClassProperty grailsProperty, String cascadeStrategy, GrailsDomainClass referenced) {
        if (LOG.isDebugEnabled() && grailsProperty.isAssociation() && referenced != null) {
            String assType = GrailsDomainBinder.getAssociationDescription(grailsProperty);
            LOG.debug((Object)("Mapping cascade strategy for " + assType + " property " + grailsProperty.getDomainClass().getFullName() + "." + grailsProperty.getName() + " referencing type [" + referenced.getClazz() + "] -> [CASCADE: " + cascadeStrategy + "]"));
        }
    }

    private static String getAssociationDescription(GrailsDomainClassProperty grailsProperty) {
        String assType = "unknown";
        if (grailsProperty.isManyToMany()) {
            assType = "many-to-many";
        } else if (grailsProperty.isOneToMany()) {
            assType = "one-to-many";
        } else if (grailsProperty.isOneToOne()) {
            assType = "one-to-one";
        } else if (grailsProperty.isManyToOne()) {
            assType = "many-to-one";
        } else if (grailsProperty.isEmbedded()) {
            assType = "embedded";
        }
        return assType;
    }

    private static void bindSimpleValue(GrailsDomainClassProperty property, GrailsDomainClassProperty parentProperty, SimpleValue simpleValue, String path, Mappings mappings) {
        GrailsDomainBinder.bindSimpleValue(property, parentProperty, simpleValue, path, GrailsDomainBinder.getPropertyConfig(property));
    }

    private static void bindSimpleValue(GrailsDomainClassProperty grailsProp, SimpleValue simpleValue, String path, PropertyConfig propertyConfig) {
        GrailsDomainBinder.bindSimpleValue(grailsProp, null, simpleValue, path, propertyConfig);
    }

    private static void bindSimpleValue(GrailsDomainClassProperty grailsProp, GrailsDomainClassProperty parentProperty, SimpleValue simpleValue, String path, PropertyConfig propertyConfig) {
        GrailsDomainBinder.setTypeForPropertyConfig(grailsProp, simpleValue, propertyConfig);
        if (propertyConfig != null && propertyConfig.getFormula() != null) {
            Formula formula = new Formula();
            formula.setFormula(propertyConfig.getFormula());
            simpleValue.addFormula(formula);
        } else {
            java.util.List<Object> columnDefinitions;
            Table table = simpleValue.getTable();
            java.util.List<Object> list = columnDefinitions = propertyConfig != null ? propertyConfig.getColumns() : Arrays.asList(new Object[]{null});
            if (columnDefinitions.isEmpty()) {
                columnDefinitions = Arrays.asList(new Object[]{null});
            }
            int n = columnDefinitions.size();
            for (int i = 0; i < n; ++i) {
                ColumnConfig cc = (ColumnConfig)columnDefinitions.get(i);
                Column column = new Column();
                if (cc != null) {
                    if (cc.getName() != null) {
                        column.setName(cc.getName());
                    }
                    if (cc.getSqlType() != null) {
                        column.setSqlType(cc.getSqlType());
                    }
                }
                column.setValue((Value)simpleValue);
                GrailsDomainBinder.bindColumn(grailsProp, parentProperty, column, cc, path, table);
                if (cc != null) {
                    if (cc.getLength() != -1) {
                        column.setLength(cc.getLength());
                    }
                    if (cc.getPrecision() != -1) {
                        column.setPrecision(cc.getPrecision());
                    }
                    if (cc.getScale() != -1) {
                        column.setScale(cc.getScale());
                    }
                    column.setUnique(cc.isUnique());
                }
                if (table != null) {
                    table.addColumn(column);
                }
                simpleValue.addColumn(column);
            }
        }
    }

    private static void setTypeForPropertyConfig(GrailsDomainClassProperty grailsProp, SimpleValue simpleValue, PropertyConfig config) {
        String typeName = GrailsDomainBinder.getTypeName(grailsProp, GrailsDomainBinder.getPropertyConfig(grailsProp), GrailsDomainBinder.getMapping(grailsProp.getDomainClass()));
        if (typeName != null) {
            simpleValue.setTypeName(typeName);
            if (config != null) {
                simpleValue.setTypeParameters(config.getTypeParams());
            }
        } else {
            simpleValue.setTypeName(grailsProp.getType().getName());
        }
    }

    private static void bindSimpleValue(String type, SimpleValue simpleValue, boolean nullable, String columnName, Mappings mappings) {
        simpleValue.setTypeName(type);
        Table t = simpleValue.getTable();
        Column column = new Column();
        column.setNullable(nullable);
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
    }

    private static void bindColumn(GrailsDomainClassProperty property, GrailsDomainClassProperty parentProperty, Column column, ColumnConfig cc, String path, Table table) {
        Class<?> userType = GrailsDomainBinder.getUserType(property);
        String columnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(property, path, cc);
        if ((property.isAssociation() || property.isBasicCollectionType()) && userType == null) {
            if (column.getName() == null) {
                column.setName(columnName);
            }
            if (property.isManyToMany()) {
                column.setNullable(false);
            } else if (property.isOneToOne() && property.isBidirectional() && !property.isOwningSide()) {
                if (property.getOtherSide().isHasOne()) {
                    column.setNullable(false);
                } else {
                    column.setNullable(true);
                }
            } else if ((property.isManyToOne() || property.isOneToOne()) && property.isCircular()) {
                column.setNullable(true);
            } else {
                column.setNullable(property.isOptional());
            }
        } else {
            column.setName(columnName);
            column.setNullable(property.isOptional() || parentProperty != null && parentProperty.isOptional());
            ConstrainedProperty constrainedProperty = GrailsDomainBinder.getConstrainedProperty(property);
            if (constrainedProperty != null) {
                if (String.class.isAssignableFrom(property.getType()) || byte[].class.isAssignableFrom(property.getType())) {
                    GrailsDomainBinder.bindStringColumnConstraints(column, constrainedProperty);
                }
                if (Number.class.isAssignableFrom(property.getType())) {
                    GrailsDomainBinder.bindNumericColumnConstraints(column, constrainedProperty);
                }
            }
        }
        ConstrainedProperty cp = GrailsDomainBinder.getConstrainedProperty(property);
        if (cp != null && cp.hasAppliedConstraint("unique")) {
            UniqueConstraint uc = (UniqueConstraint)cp.getAppliedConstraint("unique");
            if (uc != null && uc.isUnique()) {
                if (!uc.isUniqueWithinGroup()) {
                    column.setUnique(true);
                } else if (uc.getUniquenessGroup().size() > 0) {
                    GrailsDomainBinder.createKeyForProps(property, path, table, columnName, uc.getUniquenessGroup());
                }
            }
        } else {
            Object val;
            Object object = val = cp != null ? cp.getMetaConstraintValue("unique") : null;
            if (val instanceof Boolean) {
                column.setUnique(((Boolean)val).booleanValue());
            } else if (val instanceof String) {
                GrailsDomainBinder.createKeyForProps(property, path, table, columnName, Arrays.asList((String)val));
            } else if (val instanceof java.util.List && ((java.util.List)val).size() > 0) {
                GrailsDomainBinder.createKeyForProps(property, path, table, columnName, (java.util.List)val);
            }
        }
        GrailsDomainBinder.bindIndex(column, cc, table);
        if (!property.getDomainClass().isRoot()) {
            Mapping mapping = GrailsDomainBinder.getMapping(property.getDomainClass());
            if (mapping == null || mapping.getTablePerHierarchy()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Sub class property [" + property.getName() + "] for column name [" + column.getName() + "] set to nullable"));
                }
                column.setNullable(true);
            } else {
                column.setNullable(property.isOptional());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] bound property [" + property.getName() + "] to column name [" + column.getName() + "] in table [" + table.getName() + "]"));
        }
    }

    private static void createKeyForProps(GrailsDomainClassProperty grailsProp, String path, Table table, String columnName, java.util.List<?> propertyNames) {
        ArrayList<Column> keyList = new ArrayList<Column>();
        keyList.add(new Column(columnName));
        for (String propertyName : propertyNames) {
            GrailsDomainClassProperty otherProp = grailsProp.getDomainClass().getPropertyByName(propertyName);
            String otherColumnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(otherProp, path, null);
            keyList.add(new Column(otherColumnName));
        }
        GrailsDomainBinder.createUniqueKeyForColumns(table, columnName, keyList);
    }

    private static void createUniqueKeyForColumns(Table table, String columnName, java.util.List<Column> keyList) {
        Collections.reverse(keyList);
        UniqueKey key = table.getOrCreateUniqueKey("unique-" + columnName);
        java.util.List columns = key.getColumns();
        if (columns.size() == 0) {
            LOG.debug((Object)("create unique key for " + table.getName() + " columns = " + keyList));
            key.addColumns(keyList.iterator());
        }
    }

    private static void bindIndex(Column column, ColumnConfig cc, Table table) {
        if (cc == null) {
            return;
        }
        String indexDefinition = cc.getIndex();
        if (indexDefinition == null) {
            return;
        }
        String[] tokens = indexDefinition.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String index = tokens[i];
            table.getOrCreateIndex(index).addColumn(column);
        }
    }

    private static String getColumnNameForPropertyAndPath(GrailsDomainClassProperty grailsProp, String path, ColumnConfig cc) {
        String columnName = null;
        if (cc != null) {
            PropertyConfig pc;
            columnName = GrailsDomainBinder.supportsJoinColumnMapping(grailsProp) ? (GrailsDomainBinder.hasJoinKeyMapping(pc = GrailsDomainBinder.getPropertyConfig(grailsProp)) ? pc.getJoinTable().getKey().getName() : cc.getName()) : cc.getName();
        } else {
            GrailsDomainClass domainClass = grailsProp.getDomainClass();
            Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
            if (m != null) {
                PropertyConfig c = m.getPropertyConfig(grailsProp.getName());
                if (GrailsDomainBinder.supportsJoinColumnMapping(grailsProp) && GrailsDomainBinder.hasJoinKeyMapping(c)) {
                    columnName = c.getJoinTable().getKey().getName();
                } else if (c != null && c.getColumn() != null) {
                    columnName = c.getColumn();
                }
            }
        }
        if (columnName == null) {
            columnName = StringHelper.isNotEmpty((String)path) ? GrailsDomainBinder.addUnderscore(namingStrategy.propertyToColumnName(path), GrailsDomainBinder.getDefaultColumnName(grailsProp)) : GrailsDomainBinder.getDefaultColumnName(grailsProp);
        }
        return columnName;
    }

    private static boolean hasJoinKeyMapping(PropertyConfig c) {
        return c != null && c.getJoinTable() != null && c.getJoinTable().getKey() != null;
    }

    private static boolean supportsJoinColumnMapping(GrailsDomainClassProperty grailsProp) {
        return grailsProp.isManyToMany() || GrailsDomainBinder.isUnidirectionalOneToMany(grailsProp) || grailsProp.isBasicCollectionType();
    }

    private static String getDefaultColumnName(GrailsDomainClassProperty property) {
        String columnName = namingStrategy.propertyToColumnName(property.getName());
        if (property.isAssociation() && property.getReferencedDomainClass() != null) {
            if (property.isManyToMany()) {
                return GrailsDomainBinder.getForeignKeyForPropertyDomainClass(property);
            }
            if (!property.isBidirectional() && property.isOneToMany()) {
                String prefix = namingStrategy.classToTableName(property.getDomainClass().getName());
                return GrailsDomainBinder.addUnderscore(prefix, columnName) + FOREIGN_KEY_SUFFIX;
            }
            if (property.isInherited() && GrailsDomainBinder.isBidirectionalManyToOne(property)) {
                return namingStrategy.propertyToColumnName(property.getDomainClass().getName()) + '_' + columnName + FOREIGN_KEY_SUFFIX;
            }
            return columnName + FOREIGN_KEY_SUFFIX;
        }
        if (property.isBasicCollectionType()) {
            return GrailsDomainBinder.getForeignKeyForPropertyDomainClass(property);
        }
        return columnName;
    }

    private static String getForeignKeyForPropertyDomainClass(GrailsDomainClassProperty property) {
        String propertyName = property.getDomainClass().getPropertyName();
        return namingStrategy.propertyToColumnName(propertyName) + FOREIGN_KEY_SUFFIX;
    }

    private static String getIndexColumnName(GrailsDomainClassProperty property) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getColumn() != null) {
            return pc.getIndexColumn().getColumn();
        }
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "idx";
    }

    private static String getIndexColumnType(GrailsDomainClassProperty property, String defaultType) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getType() != null) {
            return GrailsDomainBinder.getTypeName(property, pc.getIndexColumn(), GrailsDomainBinder.getMapping(property.getDomainClass()));
        }
        return defaultType;
    }

    private static String getMapElementName(GrailsDomainClassProperty property) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (GrailsDomainBinder.hasJoinTableColumnNameMapping(pc)) {
            return pc.getJoinTable().getColumn().getName();
        }
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "elt";
    }

    private static boolean hasJoinTableColumnNameMapping(PropertyConfig pc) {
        return pc != null && pc.getJoinTable() != null && pc.getJoinTable().getColumn() != null && pc.getJoinTable().getColumn().getName() != null;
    }

    private static ConstrainedProperty getConstrainedProperty(GrailsDomainClassProperty grailsProp) {
        ConstrainedProperty constrainedProperty = null;
        java.util.Map constraints = grailsProp.getDomainClass().getConstrainedProperties();
        Iterator constrainedPropertyIter = constraints.values().iterator();
        while (constrainedPropertyIter.hasNext() && constrainedProperty == null) {
            ConstrainedProperty tmpConstrainedProperty = (ConstrainedProperty)constrainedPropertyIter.next();
            if (!tmpConstrainedProperty.getPropertyName().equals(grailsProp.getName())) continue;
            constrainedProperty = tmpConstrainedProperty;
        }
        return constrainedProperty;
    }

    protected static void bindStringColumnConstraints(Column column, ConstrainedProperty constrainedProperty) {
        Integer columnLength = constrainedProperty.getMaxSize();
        java.util.List inListValues = constrainedProperty.getInList();
        if (columnLength != null) {
            column.setLength(columnLength.intValue());
        } else if (inListValues != null) {
            column.setLength(GrailsDomainBinder.getMaxSize(inListValues));
        }
    }

    protected static void bindNumericColumnConstraints(Column column, ConstrainedProperty constrainedProperty) {
        int scale = 2;
        int precision = 19;
        if (constrainedProperty.getScale() != null) {
            scale = constrainedProperty.getScale();
            column.setScale(scale);
        }
        Comparable minConstraintValue = constrainedProperty.getMin();
        Comparable maxConstraintValue = constrainedProperty.getMax();
        int minConstraintValueLength = 0;
        if (minConstraintValue != null && minConstraintValue instanceof Number) {
            minConstraintValueLength = Math.max(GrailsDomainBinder.countDigits((Number)((Object)minConstraintValue)), GrailsDomainBinder.countDigits(new Long(((Number)((Object)minConstraintValue)).longValue())) + scale);
        }
        int maxConstraintValueLength = 0;
        if (maxConstraintValue != null && maxConstraintValue instanceof Number) {
            maxConstraintValueLength = Math.max(GrailsDomainBinder.countDigits((Number)((Object)maxConstraintValue)), GrailsDomainBinder.countDigits(new Long(((Number)((Object)maxConstraintValue)).longValue())) + scale);
        }
        precision = minConstraintValueLength > 0 && maxConstraintValueLength > 0 ? NumberUtils.max((int[])new int[]{minConstraintValueLength, maxConstraintValueLength}) : NumberUtils.max((int[])new int[]{precision, minConstraintValueLength, maxConstraintValueLength});
        column.setPrecision(precision);
    }

    private static int countDigits(Number number) {
        int numDigits = 0;
        if (number != null) {
            String digitsOnly = number.toString().replaceAll("\\D", EMPTY_PATH);
            numDigits = digitsOnly.length();
        }
        return numDigits;
    }

    private static int getMaxSize(java.util.List<?> inListValues) {
        int maxSize = 0;
        for (String value : inListValues) {
            maxSize = Math.max(value.length(), maxSize);
        }
        return maxSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapSecondPass
    extends GrailsCollectionSecondPass {
        private static final long serialVersionUID = -3244991685626409031L;

        public MapSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            super(property, mappings, coll);
        }

        @Override
        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection);
        }

        @Override
        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListSecondPass
    extends GrailsCollectionSecondPass {
        private static final long serialVersionUID = -3024674993774205193L;

        public ListSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            super(property, mappings, coll);
        }

        @Override
        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindListSecondPass(this.property, this.mappings, persistentClasses, (List)this.collection);
        }

        @Override
        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindListSecondPass(this.property, this.mappings, persistentClasses, (List)this.collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GrailsCollectionSecondPass
    implements SecondPass {
        protected static final long serialVersionUID = -5540526942092611348L;
        protected GrailsDomainClassProperty property;
        protected Mappings mappings;
        protected Collection collection;

        public GrailsCollectionSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            this.property = property;
            this.mappings = mappings;
            this.collection = coll;
        }

        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection);
            this.createCollectionKeys();
        }

        private void createCollectionKeys() {
            this.collection.createAllKeys();
            if (LOG.isDebugEnabled()) {
                String msg = "Mapped collection key: " + GrailsCollectionSecondPass.columns((Value)this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + GrailsCollectionSecondPass.columns(((IndexedCollection)this.collection).getIndex());
                }
                msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + GrailsCollectionSecondPass.columns(this.collection.getElement());
                LOG.debug((Object)msg);
            }
        }

        private static String columns(Value val) {
            StringBuilder columns = new StringBuilder();
            Iterator iter = val.getColumnIterator();
            while (iter.hasNext()) {
                columns.append(((Selectable)iter.next()).getText());
                if (!iter.hasNext()) continue;
                columns.append(", ");
            }
            return columns.toString();
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection);
            this.createCollectionKeys();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class CollectionType {
        private Class<?> clazz;
        private static CollectionType SET = new CollectionType((Class)java.util.Set.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                Set coll = new Set(owner);
                coll.setCollectionTable(owner.getTable());
                GrailsDomainBinder.bindCollection(property, (Collection)coll, owner, mappings, path);
                return coll;
            }
        };
        private static CollectionType LIST = new CollectionType((Class)java.util.List.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                List coll = new List(owner);
                coll.setCollectionTable(owner.getTable());
                GrailsDomainBinder.bindCollection(property, (Collection)coll, owner, mappings, path);
                return coll;
            }
        };
        private static CollectionType MAP = new CollectionType((Class)java.util.Map.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                Map map = new Map(owner);
                GrailsDomainBinder.bindCollection(property, (Collection)map, owner, mappings, path);
                return map;
            }
        };
        private static final java.util.Map<Class<?>, CollectionType> INSTANCES = new HashMap();

        public abstract Collection create(GrailsDomainClassProperty var1, PersistentClass var2, String var3, Mappings var4) throws MappingException;

        CollectionType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            return this.clazz.getName();
        }

        public static CollectionType collectionTypeForClass(Class<?> clazz) {
            return INSTANCES.get(clazz);
        }

        static {
            INSTANCES.put(java.util.Set.class, SET);
            INSTANCES.put(SortedSet.class, SET);
            INSTANCES.put(java.util.List.class, LIST);
            INSTANCES.put(java.util.Map.class, MAP);
        }
    }
}

