/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractDynamicPersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.BeforeValidateHelper;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.hibernate.SessionFactory;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class ValidatePersistentMethod
extends AbstractDynamicPersistentMethod {
    public static final String METHOD_SIGNATURE = "validate";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^validate$");
    private GrailsApplication application;
    public static final String ARGUMENT_DEEP_VALIDATE = "deepValidate";
    private static final String ARGUMENT_EVICT = "evict";
    private Validator validator;
    private BeforeValidateHelper beforeValidateHelper = new BeforeValidateHelper();

    public ValidatePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        this(sessionFactory, classLoader, application, null);
    }

    public ValidatePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, Validator validator) {
        super(METHOD_PATTERN, sessionFactory, classLoader);
        Assert.notNull((Object)application, (String)"Constructor argument 'application' cannot be null");
        this.application = application;
        this.validator = validator;
    }

    protected Object doInvokeInternal(Object target, Object[] arguments) {
        Errors errors = this.setupErrorsProperty(target);
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", target.getClass().getName());
        if (this.validator == null && domainClass != null) {
            this.validator = domainClass.getValidator();
        }
        if (this.validator == null) {
            return true;
        }
        Boolean valid = Boolean.TRUE;
        boolean evict = false;
        boolean deepValidate = true;
        HashSet validatedFields = null;
        List validatedFieldsList = null;
        if (arguments.length > 0) {
            if (arguments[0] instanceof Boolean) {
                evict = (Boolean)arguments[0];
            }
            if (arguments[0] instanceof Map) {
                Map argsMap = (Map)arguments[0];
                if (argsMap.containsKey(ARGUMENT_DEEP_VALIDATE)) {
                    deepValidate = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_DEEP_VALIDATE, (Map)argsMap);
                }
                evict = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_EVICT, (Map)argsMap);
            }
            if (arguments[0] instanceof List) {
                validatedFieldsList = (List)arguments[0];
                validatedFields = new HashSet(validatedFieldsList);
            }
        }
        this.beforeValidateHelper.invokeBeforeValidate(target, validatedFieldsList);
        if (deepValidate && this.validator instanceof CascadingValidator) {
            ((CascadingValidator)this.validator).validate(target, errors, deepValidate);
        } else {
            this.validator.validate(target, errors);
        }
        int oldErrorCount = errors.getErrorCount();
        errors = this.filterErrors(errors, validatedFields, target);
        if (errors.hasErrors()) {
            valid = Boolean.FALSE;
            if (evict) {
                if (this.getHibernateTemplate().contains(target)) {
                    this.getHibernateTemplate().evict(target);
                }
            } else {
                this.setObjectToReadOnly(target);
            }
        } else {
            this.setObjectToReadWrite(target);
        }
        if (errors.getErrorCount() != oldErrorCount) {
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
            metaClass.setProperty(target, "errors", (Object)errors);
        }
        return valid;
    }

    private Errors filterErrors(Errors errors, Set validatedFields, Object target) {
        if (validatedFields == null) {
            return errors;
        }
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(target, target.getClass().getName());
        List allErrors = errors.getAllErrors();
        for (int i = 0; i < allErrors.size(); ++i) {
            FieldError fieldError;
            ObjectError error = (ObjectError)allErrors.get(i);
            if (error instanceof FieldError && !validatedFields.contains((fieldError = (FieldError)error).getField())) continue;
            result.addError(error);
        }
        return result;
    }
}

