/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedThreadPool
extends AbstractExecutorService
implements ExtendedThreadPool {
    protected static final Runnable poison = new Runnable(){

        public void run() {
        }
    };
    protected final ConcurrentHashMap<BasicWorker, Boolean> workers = new ConcurrentHashMap();
    protected final AtomicInteger aliveworkerCount = new AtomicInteger();
    protected final AtomicInteger approximateRunningWorkerCount = new AtomicInteger();
    protected final BlockingQueue<Runnable> workQueue;
    protected volatile ThreadFactory threadFactory;
    protected final Object statelock = new Object();
    protected volatile int maxPoolSize;
    protected volatile boolean running = true;
    protected String name = "GrizzlyWorker";

    public FixedThreadPool() {
        this(8);
    }

    public FixedThreadPool(int size) {
        this(size, "GrizzlyWorker");
    }

    public FixedThreadPool(int size, final String name) {
        this(size, new ThreadFactory(){
            private final AtomicInteger c = new AtomicInteger();

            public Thread newThread(Runnable r) {
                WorkerThreadImpl t = new WorkerThreadImpl(null, name + this.c.incrementAndGet(), r, 0);
                t.setDaemon(true);
                return t;
            }
        });
        this.name = name;
    }

    public FixedThreadPool(int size, ThreadFactory threadfactory) {
        this(size, new LinkedTransferQueue<Runnable>(), threadfactory);
    }

    public FixedThreadPool(int fixedsize, BlockingQueue<Runnable> workQueue, ThreadFactory threadfactory) {
        if (threadfactory == null) {
            throw new IllegalArgumentException("threadfactory == null");
        }
        if (workQueue == null) {
            throw new IllegalArgumentException("workQueue == null");
        }
        if (fixedsize < 1) {
            throw new IllegalArgumentException("fixedsize < 1");
        }
        this.threadFactory = threadfactory;
        this.workQueue = workQueue;
        this.maxPoolSize = fixedsize;
        while (fixedsize-- > 0) {
            this.aliveworkerCount.incrementAndGet();
            this.startWorker(new BasicWorker());
        }
    }

    protected FixedThreadPool(BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        if (workQueue == null) {
            throw new IllegalArgumentException("workQueue == null");
        }
        this.workQueue = workQueue;
        this.threadFactory = threadFactory;
    }

    protected void startWorker(BasicWorker wt) {
        wt.t = this.threadFactory.newThread(wt);
        this.workers.put(wt, Boolean.TRUE);
        wt.t.start();
    }

    @Override
    public void execute(Runnable command) {
        if (this.running) {
            this.workQueue.offer(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Object object = this.statelock;
        synchronized (object) {
            ArrayList<Runnable> drained = new ArrayList<Runnable>();
            if (this.running) {
                this.running = false;
                this.workQueue.drainTo(drained);
                this.poisonAll();
                for (BasicWorker w : this.workers.keySet()) {
                    w.t.interrupt();
                }
            }
            return drained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.statelock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.poisonAll();
            }
        }
    }

    private void poisonAll() {
        int size = Math.max(this.maxPoolSize, this.aliveworkerCount.get()) * 4 / 3;
        while (size-- > 0) {
            this.workQueue.offer(poison);
        }
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getActiveCount() {
        return 0;
    }

    @Override
    public long getTaskCount() {
        return 0L;
    }

    @Override
    public long getCompletedTaskCount() {
        return 0L;
    }

    @Override
    public int getCorePoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
    }

    @Override
    public int getLargestPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public int getQueueSize() {
        return this.workQueue.size();
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return 0L;
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
    }

    @Override
    public int getMaxQueuedTasksCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxQueuedTasksCount(int maxTasksCount) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected class BasicWorker
    implements Runnable {
        Thread t;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.dowork();
            }
            finally {
                FixedThreadPool.this.aliveworkerCount.decrementAndGet();
                FixedThreadPool.this.workers.remove(this);
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void dowork() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        Thread.interrupted();
                        r = this.getTask();
                        if (r == FixedThreadPool.poison || r == null) {
                            return;
                        }
                        ran = false;
                        FixedThreadPool.this.beforeExecute(this.t, r);
                        try {
                            FixedThreadPool.this.approximateRunningWorkerCount.incrementAndGet();
                            r.run();
                            FixedThreadPool.this.afterExecute(r, null);
                        }
                        catch (Throwable t) {
                            if (!ran) {
                                FixedThreadPool.this.afterExecute(r, t);
                            }
                            throw t;
                        }
                        finally {
                            FixedThreadPool.this.approximateRunningWorkerCount.decrementAndGet();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var1_2) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        protected Runnable getTask() throws InterruptedException {
            return FixedThreadPool.this.workQueue.take();
        }
    }
}

