/*
 * Decompiled with CFR 0.152.
 */
package extra166y;

import extra166y.AbstractParallelAnyArray;
import extra166y.Ops;
import extra166y.ParallelArray;
import extra166y.ParallelArrayWithMapping;
import extra166y.ParallelDoubleArray;
import extra166y.ParallelDoubleArrayWithDoubleMapping;
import extra166y.ParallelLongArray;
import extra166y.ParallelLongArrayWithLongMapping;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;

class PAS {
    private static volatile ForkJoinPool defaultExecutor;
    private static final Object poolLock;
    static final int INSERTION_SORT_THRESHOLD = 8;

    private PAS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ForkJoinPool defaultExecutor() {
        ForkJoinPool p = defaultExecutor;
        if (p == null) {
            Object object = poolLock;
            synchronized (object) {
                p = defaultExecutor;
                if (p == null) {
                    int nprocs = Runtime.getRuntime().availableProcessors();
                    int nthreads = nprocs - (nprocs >>> 3);
                    defaultExecutor = p = new ForkJoinPool(nthreads);
                }
            }
        }
        return p;
    }

    static void dquickSort(double[] a, Ops.DoubleComparator cmp, int lo, int hi) {
        while (true) {
            double t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && cmp.compare(t, a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (cmp.compare(a[lo], a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (cmp.compare(a[mid], a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (cmp.compare(a[lo], a[mid]) > 0) {
                    double u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            double pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            boolean sameLefts = true;
            while (true) {
                int c;
                if (cmp.compare(pivot, a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && (c = cmp.compare(pivot, a[left])) >= 0) {
                    if (c != 0) {
                        sameLefts = false;
                    }
                    ++left;
                }
                if (left >= right) break;
                double t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            if (sameLefts && right == hi - 1) {
                return;
            }
            if (left - lo <= hi - right) {
                PAS.dquickSort(a, cmp, lo, left);
                lo = left + 1;
                continue;
            }
            PAS.dquickSort(a, cmp, right, hi);
            hi = left;
        }
    }

    static void lquickSort(long[] a, Ops.LongComparator cmp, int lo, int hi) {
        while (true) {
            long t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && cmp.compare(t, a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (cmp.compare(a[lo], a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (cmp.compare(a[mid], a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (cmp.compare(a[lo], a[mid]) > 0) {
                    long u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            long pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            boolean sameLefts = true;
            while (true) {
                int c;
                if (cmp.compare(pivot, a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && (c = cmp.compare(pivot, a[left])) >= 0) {
                    if (c != 0) {
                        sameLefts = false;
                    }
                    ++left;
                }
                if (left >= right) break;
                long t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            if (sameLefts && right == hi - 1) {
                return;
            }
            if (left - lo <= hi - right) {
                PAS.lquickSort(a, cmp, lo, left);
                lo = left + 1;
                continue;
            }
            PAS.lquickSort(a, cmp, right, hi);
            hi = left;
        }
    }

    static {
        poolLock = new Object();
    }

    static final class FJLPrecumulatePlusOp
    extends FJLScanPlusOp {
        FJLPrecumulatePlusOp(AbstractParallelAnyArray.LPap pap) {
            super(pap);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                sum += arr[i];
            }
            f.lsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum += x;
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum += x;
            }
            f.lsetOut(sum);
        }
    }

    static final class FJLCumulatePlusOp
    extends FJLScanPlusOp {
        FJLCumulatePlusOp(AbstractParallelAnyArray.LPap pap) {
            super(pap);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            long sum = 0L;
            if (hi != this.fence) {
                long[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum += arr[i];
                }
            }
            f.lsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
            f.lsetOut(sum);
        }
    }

    static abstract class FJLScanPlusOp
    extends FJScanOp {
        final long[] array;

        FJLScanPlusOp(AbstractParallelAnyArray.LPap pap) {
            super(pap);
            this.array = pap.array;
        }

        @Override
        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            long pin = parent.lgetIn();
            left.lsetIn(pin);
            right.lsetIn(pin + left.lgetOut());
        }

        @Override
        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.lsetOut(left.lgetOut() + right.lgetOut());
        }

        @Override
        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJLScan f = new FJLScan(parent, this, lo, hi);
            f.in = 0L;
            f.out = 0L;
            return f;
        }
    }

    static final class FJDPrecumulatePlusOp
    extends FJDScanPlusOp {
        FJDPrecumulatePlusOp(AbstractParallelAnyArray.DPap pap) {
            super(pap);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                sum += arr[i];
            }
            f.dsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum += x;
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum += x;
            }
            f.dsetOut(sum);
        }
    }

    static final class FJDCumulatePlusOp
    extends FJDScanPlusOp {
        FJDCumulatePlusOp(AbstractParallelAnyArray.DPap pap) {
            super(pap);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            double sum = 0.0;
            if (hi != this.fence) {
                double[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum += arr[i];
                }
            }
            f.dsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
            f.dsetOut(sum);
        }
    }

    static abstract class FJDScanPlusOp
    extends FJScanOp {
        final double[] array;

        FJDScanPlusOp(AbstractParallelAnyArray.DPap pap) {
            super(pap);
            this.array = pap.array;
        }

        @Override
        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            double pin = parent.dgetIn();
            left.dsetIn(pin);
            right.dsetIn(pin + left.dgetOut());
        }

        @Override
        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.dsetOut(left.dgetOut() + right.dgetOut());
        }

        @Override
        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJDScan f = new FJDScan(parent, this, lo, hi);
            f.in = 0.0;
            f.out = 0.0;
            return f;
        }
    }

    static final class FJLPrecumulateOp
    extends FJLScanOp {
        FJLPrecumulateOp(AbstractParallelAnyArray.LPap pap, Ops.LongReducer reducer, long base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.op(sum, arr[i]);
            }
            f.lsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
            f.lsetOut(sum);
        }
    }

    static final class FJLCumulateOp
    extends FJLScanOp {
        FJLCumulateOp(AbstractParallelAnyArray.LPap pap, Ops.LongReducer reducer, long base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            long sum = this.base;
            if (hi != this.fence) {
                long[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.op(sum, arr[i]);
                }
            }
            f.lsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
            f.lsetOut(sum);
        }
    }

    static abstract class FJLScanOp
    extends FJScanOp {
        final long[] array;
        final Ops.LongReducer reducer;
        final long base;

        FJLScanOp(AbstractParallelAnyArray.LPap pap, Ops.LongReducer reducer, long base) {
            super(pap);
            this.array = pap.array;
            this.reducer = reducer;
            this.base = base;
        }

        @Override
        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            long pin = parent.lgetIn();
            left.lsetIn(pin);
            right.lsetIn(this.reducer.op(pin, left.lgetOut()));
        }

        @Override
        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.lsetOut(this.reducer.op(left.lgetOut(), right.lgetOut()));
        }

        @Override
        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJLScan f = new FJLScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static final class FJDPrecumulateOp
    extends FJDScanOp {
        FJDPrecumulateOp(AbstractParallelAnyArray.DPap pap, Ops.DoubleReducer reducer, double base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.op(sum, arr[i]);
            }
            f.dsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
            f.dsetOut(sum);
        }
    }

    static final class FJDCumulateOp
    extends FJDScanOp {
        FJDCumulateOp(AbstractParallelAnyArray.DPap pap, Ops.DoubleReducer reducer, double base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            double sum = this.base;
            if (hi != this.fence) {
                double[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.op(sum, arr[i]);
                }
            }
            f.dsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
            f.dsetOut(sum);
        }
    }

    static abstract class FJDScanOp
    extends FJScanOp {
        final double[] array;
        final Ops.DoubleReducer reducer;
        final double base;

        FJDScanOp(AbstractParallelAnyArray.DPap pap, Ops.DoubleReducer reducer, double base) {
            super(pap);
            this.array = pap.array;
            this.reducer = reducer;
            this.base = base;
        }

        @Override
        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            double pin = parent.dgetIn();
            left.dsetIn(pin);
            right.dsetIn(this.reducer.op(pin, left.dgetOut()));
        }

        @Override
        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.dsetOut(this.reducer.op(left.dgetOut(), right.dgetOut()));
        }

        @Override
        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJDScan f = new FJDScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static final class FJOPrecumulateOp
    extends FJOScanOp {
        FJOPrecumulateOp(AbstractParallelAnyArray.OPap pap, Ops.Reducer reducer, Object base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.op(sum, arr[i]);
            }
            f.rsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = f.ogetIn();
            for (int i = lo; i < hi; ++i) {
                Object x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                Object x = arr[i];
                arr[i] = sum;
                sum = this.reducer.op(sum, x);
            }
            f.rsetOut(sum);
        }
    }

    static final class FJOCumulateOp
    extends FJOScanOp {
        FJOCumulateOp(AbstractParallelAnyArray.OPap pap, Ops.Reducer reducer, Object base) {
            super(pap, reducer, base);
        }

        @Override
        void sumLeaf(int lo, int hi, FJScan f) {
            Object sum = this.base;
            if (hi != this.fence) {
                Object[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.op(sum, arr[i]);
                }
            }
            f.rsetOut(sum);
        }

        @Override
        void cumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = f.ogetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
        }

        @Override
        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.op(sum, arr[i]);
            }
            f.rsetOut(sum);
        }
    }

    static abstract class FJOScanOp
    extends FJScanOp {
        final Object[] array;
        final Ops.Reducer reducer;
        final Object base;

        FJOScanOp(AbstractParallelAnyArray.OPap pap, Ops.Reducer reducer, Object base) {
            super(pap);
            this.array = pap.array;
            this.reducer = reducer;
            this.base = base;
        }

        @Override
        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            Object pin = parent.ogetIn();
            left.rsetIn(pin);
            right.rsetIn(this.reducer.op(pin, left.ogetOut()));
        }

        @Override
        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.rsetOut(this.reducer.op(left.ogetOut(), right.ogetOut()));
        }

        @Override
        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJOScan f = new FJOScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static abstract class FJScanOp {
        final int threshold;
        final int origin;
        final int fence;

        FJScanOp(AbstractParallelAnyArray pap) {
            this.origin = pap.origin;
            this.fence = pap.fence;
            this.threshold = pap.computeThreshold();
        }

        abstract void pushDown(FJScan var1, FJScan var2, FJScan var3);

        abstract void pushUp(FJScan var1, FJScan var2, FJScan var3);

        abstract void sumLeaf(int var1, int var2, FJScan var3);

        abstract void cumulateLeaf(int var1, int var2, FJScan var3);

        abstract void sumAndCumulateLeaf(int var1, int var2, FJScan var3);

        abstract FJScan newSubtask(FJScan var1, int var2, int var3);
    }

    static final class FJLScan
    extends FJScan {
        long in;
        long out;

        FJLScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        @Override
        long lgetIn() {
            return this.in;
        }

        @Override
        long lgetOut() {
            return this.out;
        }

        @Override
        void lsetIn(long x) {
            this.in = x;
        }

        @Override
        void lsetOut(long x) {
            this.out = x;
        }
    }

    static final class FJDScan
    extends FJScan {
        double in;
        double out;

        FJDScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        @Override
        double dgetIn() {
            return this.in;
        }

        @Override
        double dgetOut() {
            return this.out;
        }

        @Override
        void dsetIn(double x) {
            this.in = x;
        }

        @Override
        void dsetOut(double x) {
            this.out = x;
        }
    }

    static final class FJOScan
    extends FJScan {
        Object in;
        Object out;

        FJOScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        @Override
        Object ogetIn() {
            return this.in;
        }

        @Override
        Object ogetOut() {
            return this.out;
        }

        @Override
        void rsetIn(Object x) {
            this.in = x;
        }

        @Override
        void rsetOut(Object x) {
            this.out = x;
        }
    }

    static abstract class FJScan
    extends ForkJoinTask<Void> {
        static final short CUMULATE = 1;
        static final short SUMMED = 2;
        static final short FINISHED = 4;
        final FJScan parent;
        final FJScanOp op;
        FJScan left;
        FJScan right;
        volatile int phase;
        final int lo;
        final int hi;
        static final AtomicIntegerFieldUpdater<FJScan> phaseUpdater = AtomicIntegerFieldUpdater.newUpdater(FJScan.class, "phase");

        FJScan(FJScan parent, FJScanOp op, int lo, int hi) {
            this.parent = parent;
            this.op = op;
            this.lo = lo;
            this.hi = hi;
        }

        public final Void getRawResult() {
            return null;
        }

        protected final void setRawResult(Void mustBeNull) {
        }

        final boolean transitionToCumulate() {
            int c;
            while (((c = this.phase) & 1) == 0) {
                if (!phaseUpdater.compareAndSet(this, c, c | 1)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean exec() {
            if (this.hi - this.lo > this.op.threshold) {
                boolean cumulate;
                if (this.left == null) {
                    int mid = this.lo + this.hi >>> 1;
                    this.left = this.op.newSubtask(this, this.lo, mid);
                    this.right = this.op.newSubtask(this, mid, this.hi);
                }
                boolean bl = cumulate = (this.phase & 1) != 0;
                if (cumulate) {
                    this.op.pushDown(this, this.left, this.right);
                }
                if (!cumulate || this.right.transitionToCumulate()) {
                    this.right.fork();
                }
                if (cumulate && !this.left.transitionToCumulate()) return false;
                this.left.exec();
                return false;
            } else {
                int cb;
                int b;
                do {
                    if (((b = this.phase) & 4) == 0) continue;
                    return false;
                } while (!phaseUpdater.compareAndSet(this, b, b | (cb = (b & 1) != 0 ? 4 : (this.lo == this.op.origin ? 6 : 2))));
                if (cb == 2) {
                    this.op.sumLeaf(this.lo, this.hi, this);
                } else if (cb == 4) {
                    this.op.cumulateLeaf(this.lo, this.hi, this);
                } else if (cb == 6) {
                    this.op.sumAndCumulateLeaf(this.lo, this.hi, this);
                }
                FJScan ch = this;
                FJScan par = this.parent;
                while (true) {
                    if (par == null) {
                        if ((cb & 4) == 0) return false;
                        ch.complete(null);
                        return false;
                    }
                    int pb = par.phase;
                    if ((pb & cb & 4) != 0) {
                        ch = par;
                        par = par.parent;
                        continue;
                    }
                    if ((pb & cb & 2) != 0) {
                        this.op.pushUp(par, par.left, par.right);
                        int refork = (pb & 1) == 0 && par.lo == this.op.origin ? 1 : 0;
                        int nextPhase = pb | cb | refork;
                        if (pb != nextPhase && !phaseUpdater.compareAndSet(par, pb, nextPhase)) continue;
                        if (refork != 0) {
                            par.fork();
                        }
                        cb = 2;
                        ch = par;
                        par = par.parent;
                        continue;
                    }
                    if (phaseUpdater.compareAndSet(par, pb, pb | cb)) return false;
                }
            }
        }

        Object ogetIn() {
            return null;
        }

        Object ogetOut() {
            return null;
        }

        void rsetIn(Object x) {
        }

        void rsetOut(Object x) {
        }

        double dgetIn() {
            return 0.0;
        }

        double dgetOut() {
            return 0.0;
        }

        void dsetIn(double x) {
        }

        void dsetOut(double x) {
        }

        long lgetIn() {
            return 0L;
        }

        long lgetOut() {
            return 0L;
        }

        void lsetIn(long x) {
        }

        void lsetOut(long x) {
        }
    }

    static final class FJLCMerger
    extends RecursiveAction {
        final long[] a;
        final long[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJLCMerger next;

        FJLCMerger(long[] a, long[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJLCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJLCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                long split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split <= this.a[this.ro + mid]) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJLCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                long t;
                long al = this.a[l];
                long ar = this.a[r];
                if (al <= ar) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJLMerger
    extends RecursiveAction {
        final Ops.LongComparator cmp;
        final long[] a;
        final long[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJLMerger next;

        FJLMerger(Ops.LongComparator cmp, long[] a, long[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJLMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJLMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                long split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJLMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                long t;
                long al = this.a[l];
                long ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJDCMerger
    extends RecursiveAction {
        final double[] a;
        final double[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJDCMerger next;

        FJDCMerger(double[] a, double[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJDCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJDCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                double split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split <= this.a[this.ro + mid]) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJDCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                double t;
                double al = this.a[l];
                double ar = this.a[r];
                if (al <= ar) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJDMerger
    extends RecursiveAction {
        final Ops.DoubleComparator cmp;
        final double[] a;
        final double[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJDMerger next;

        FJDMerger(Ops.DoubleComparator cmp, double[] a, double[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJDMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJDMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                double split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJDMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                double t;
                double al = this.a[l];
                double ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJOCMerger
    extends RecursiveAction {
        final Comparable[] a;
        final Comparable[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJOCMerger next;

        FJOCMerger(Comparable[] a, Comparable[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJOCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJOCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                Comparable split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split.compareTo(this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJOCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                Comparable t;
                Comparable al = this.a[l];
                Comparable ar = this.a[r];
                if (al.compareTo(ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJOMerger
    extends RecursiveAction {
        final Comparator cmp;
        final Object[] a;
        final Object[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJOMerger next;

        FJOMerger(Comparator cmp, Object[] a, Object[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJOMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJOMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                Object split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJOMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                Object t;
                Object al = this.a[l];
                Object ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (rights.tryUnfork()) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJSubSorter
    extends RecursiveAction {
        final RecursiveAction left;
        final RecursiveAction right;
        final RecursiveAction merger;

        FJSubSorter(RecursiveAction left, RecursiveAction right, RecursiveAction merger) {
            this.left = left;
            this.right = right;
            this.merger = merger;
        }

        public void compute() {
            this.right.fork();
            this.left.invoke();
            this.right.join();
            this.merger.invoke();
        }
    }

    static final class FJLCSorter
    extends RecursiveAction {
        final long[] a;
        final long[] w;
        final int origin;
        final int n;
        final int gran;

        FJLCSorter(long[] a, long[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJLCSorter(this.a, this.w, l, q, g), new FJLCSorter(this.a, this.w, l + q, h - q, g), new FJLCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJLCSorter(this.a, this.w, l + h, q, g), new FJLCSorter(this.a, this.w, l + u, this.n - u, g), new FJLCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJLCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                Arrays.sort(this.a, l, l + this.n);
            }
        }
    }

    static final class FJLSorter
    extends RecursiveAction {
        final Ops.LongComparator cmp;
        final long[] a;
        final long[] w;
        final int origin;
        final int n;
        final int gran;

        FJLSorter(Ops.LongComparator cmp, long[] a, long[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJLSorter(this.cmp, this.a, this.w, l, q, g), new FJLSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJLMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJLSorter(this.cmp, this.a, this.w, l + h, q, g), new FJLSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJLMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJLMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.lquickSort(this.a, this.cmp, l, l + this.n - 1);
            }
        }
    }

    static final class FJDCSorter
    extends RecursiveAction {
        final double[] a;
        final double[] w;
        final int origin;
        final int n;
        final int gran;

        FJDCSorter(double[] a, double[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJDCSorter(this.a, this.w, l, q, g), new FJDCSorter(this.a, this.w, l + q, h - q, g), new FJDCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJDCSorter(this.a, this.w, l + h, q, g), new FJDCSorter(this.a, this.w, l + u, this.n - u, g), new FJDCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJDCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                Arrays.sort(this.a, l, l + this.n);
            }
        }
    }

    static final class FJDSorter
    extends RecursiveAction {
        final Ops.DoubleComparator cmp;
        final double[] a;
        final double[] w;
        final int origin;
        final int n;
        final int gran;

        FJDSorter(Ops.DoubleComparator cmp, double[] a, double[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJDSorter(this.cmp, this.a, this.w, l, q, g), new FJDSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJDMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJDSorter(this.cmp, this.a, this.w, l + h, q, g), new FJDSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJDMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJDMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.dquickSort(this.a, this.cmp, l, l + this.n - 1);
            }
        }
    }

    static final class FJOCSorter
    extends RecursiveAction {
        final Comparable[] a;
        final Comparable[] w;
        final int origin;
        final int n;
        final int gran;

        FJOCSorter(Comparable[] a, Comparable[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJOCSorter(this.a, this.w, l, q, g), new FJOCSorter(this.a, this.w, l + q, h - q, g), new FJOCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJOCSorter(this.a, this.w, l + h, q, g), new FJOCSorter(this.a, this.w, l + u, this.n - u, g), new FJOCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJOCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                Arrays.sort(this.a, l, l + this.n);
            }
        }
    }

    static final class FJOSorter
    extends RecursiveAction {
        final Comparator cmp;
        final Object[] a;
        final Object[] w;
        final int origin;
        final int n;
        final int gran;

        FJOSorter(Comparator cmp, Object[] a, Object[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJSubSorter ls = new FJSubSorter(new FJOSorter(this.cmp, this.a, this.w, l, q, g), new FJOSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJOMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null));
                FJSubSorter rs = new FJSubSorter(new FJOSorter(this.cmp, this.a, this.w, l + h, q, g), new FJOSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJOMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null));
                rs.fork();
                ls.compute();
                if (rs.tryUnfork()) {
                    rs.compute();
                } else {
                    rs.join();
                }
                new FJOMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                Arrays.sort(this.a, l, l + this.n, this.cmp);
            }
        }
    }

    static final class UniquifierTable
    extends AtomicLongArray {
        final AbstractParallelAnyArray pap;
        final boolean byIdentity;

        UniquifierTable(int size, AbstractParallelAnyArray pap, boolean byIdentity) {
            super(UniquifierTable.tableSizeFor(size));
            this.pap = pap;
            this.byIdentity = byIdentity;
        }

        static int tableSizeFor(int n) {
            int s;
            int padded = n + (n >>> 1) + 1;
            if (padded < n) {
                throw new OutOfMemoryError();
            }
            for (s = 8; s < padded; s <<= 1) {
            }
            return s;
        }

        static int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        int addObjects(int lo, int hi) {
            boolean filtered = this.pap.hasFilter();
            Object[] src = this.pap.ogetArray();
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                Object x;
                if (filtered && !this.pap.isSelected(k) || (x = src[k]) == null) continue;
                int hc = this.byIdentity ? System.identityHashCode(x) : x.hashCode();
                int hash = UniquifierTable.hash(hc);
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        Object y;
                        if ((int)(d >>> 32) == hash && (x == (y = src[(int)(d - 1L & Integer.MAX_VALUE)]) || !this.byIdentity && x.equals(y))) continue block0;
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        int addDoubles(int lo, int hi) {
            boolean filtered = this.pap.hasFilter();
            double[] src = this.pap.dgetArray();
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                if (filtered && !this.pap.isSelected(k)) continue;
                double x = src[k];
                long bits = Double.doubleToLongBits(x);
                int hash = UniquifierTable.hash((int)(bits ^ bits >>> 32));
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        if ((int)(d >>> 32) == hash && x == src[(int)(d - 1L & Integer.MAX_VALUE)]) continue block0;
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        int addLongs(int lo, int hi) {
            boolean filtered = this.pap.hasFilter();
            long[] src = this.pap.lgetArray();
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                if (filtered && !this.pap.isSelected(k)) continue;
                long x = src[k];
                int hash = UniquifierTable.hash((int)(x ^ x >>> 32));
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        if ((int)(d >>> 32) == hash && x == src[(int)(d - 1L & Integer.MAX_VALUE)]) continue block0;
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        Object[] uniqueObjects(int size) {
            Object[] src = this.pap.ogetArray();
            Class<?> sclass = src.getClass().getComponentType();
            Object[] res = (Object[])Array.newInstance(sclass, size);
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }

        double[] uniqueDoubles(int size) {
            double[] src = this.pap.dgetArray();
            double[] res = new double[size];
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }

        long[] uniqueLongs(int size) {
            long[] src = this.pap.lgetArray();
            long[] res = new long[size];
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }
    }

    static final class FJLUniquifier
    extends FJBase {
        final UniquifierTable table;
        int count;

        FJLUniquifier(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, UniquifierTable table) {
            super(pap, lo, hi, next);
            this.table = table;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLUniquifier(this.pap, l, h, r, this.table);
        }

        @Override
        void atLeaf(int l, int h) {
            this.count = this.table.addLongs(l, h);
        }

        @Override
        void onReduce(FJBase right) {
            this.count += ((FJLUniquifier)right).count;
        }
    }

    static final class FJDUniquifier
    extends FJBase {
        final UniquifierTable table;
        int count;

        FJDUniquifier(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, UniquifierTable table) {
            super(pap, lo, hi, next);
            this.table = table;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDUniquifier(this.pap, l, h, r, this.table);
        }

        @Override
        void atLeaf(int l, int h) {
            this.count = this.table.addDoubles(l, h);
        }

        @Override
        void onReduce(FJBase right) {
            this.count += ((FJDUniquifier)right).count;
        }
    }

    static final class FJOUniquifier
    extends FJBase {
        final UniquifierTable table;
        int count;

        FJOUniquifier(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, UniquifierTable table) {
            super(pap, lo, hi, next);
            this.table = table;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOUniquifier(this.pap, l, h, r, this.table);
        }

        @Override
        void atLeaf(int l, int h) {
            this.count = this.table.addObjects(l, h);
        }

        @Override
        void onReduce(FJBase right) {
            this.count += ((FJOUniquifier)right).count;
        }
    }

    static final class FJRemoveAll
    extends RecursiveAction {
        final AbstractParallelAnyArray pap;
        final int lo;
        final int hi;
        final FJRemoveAll next;
        final int[] indices;
        int count;
        FJRemoveAll right;
        final int threshold;

        FJRemoveAll(AbstractParallelAnyArray pap, int lo, int hi, FJRemoveAll next, int[] indices) {
            this.pap = pap;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
            this.indices = indices;
            this.threshold = pap.getThreshold();
        }

        public void compute() {
            FJRemoveAll r = null;
            int l = this.lo;
            int h = this.hi;
            int g = this.threshold;
            while (h - l > g) {
                int rh = h;
                h = l + h >>> 1;
                r = new FJRemoveAll(this.pap, h, rh, r, this.indices);
                r.fork();
            }
            this.right = r;
            this.count = this.pap.leafIndexSelected(l, h, false, this.indices);
            while (r != null) {
                if (r.tryUnfork()) {
                    r.count = this.pap.leafIndexSelected(r.lo, r.hi, false, this.indices);
                } else {
                    r.join();
                }
                r = r.next;
            }
        }
    }

    static final class FJRemoveAllDriver
    extends RecursiveAction {
        final AbstractParallelAnyArray pap;
        final int lo;
        final int hi;
        final int[] indices;
        int offset;
        final int threshold;

        FJRemoveAllDriver(AbstractParallelAnyArray pap, int lo, int hi) {
            this.pap = pap;
            this.lo = lo;
            this.hi = hi;
            this.indices = new int[hi - lo];
            this.threshold = pap.getThreshold();
        }

        public void compute() {
            FJRemoveAll r = null;
            int l = this.lo;
            int h = this.hi;
            int g = this.threshold;
            while (h - l > g) {
                int rh = h;
                h = l + h >>> 1;
                r = new FJRemoveAll(this.pap, h, rh, r, this.indices);
                r.fork();
            }
            int k = this.pap.leafMoveSelected(l, h, l, false);
            while (r != null) {
                if (r.tryUnfork()) {
                    k = this.pap.leafMoveSelected(r.lo, r.hi, k, false);
                } else {
                    r.join();
                    int n = r.count;
                    if (n != 0) {
                        this.pap.leafMoveByIndex(this.indices, r.lo, r.lo + n, k);
                    }
                    k += n;
                    FJRemoveAll rr = r.right;
                    if (rr != null) {
                        k = FJRemoveAllDriver.inorderMove(rr, k);
                    }
                }
                r = r.next;
            }
            this.offset = k;
        }

        static int inorderMove(FJRemoveAll t, int index) {
            while (t != null) {
                int n = t.count;
                if (n != 0) {
                    t.pap.leafMoveByIndex(t.indices, t.lo, t.lo + n, index);
                }
                index += n;
                FJRemoveAll p = t.next;
                if (p != null) {
                    index = FJRemoveAllDriver.inorderMove(p, index);
                }
                t = t.right;
            }
            return index;
        }
    }

    static final class FJLAppendAllDriver
    extends FJSelectAllDriver {
        long[] results;

        FJLAppendAllDriver(AbstractParallelAnyArray pap, int initialOffset, long[] results) {
            super(pap, initialOffset);
            this.results = results;
        }

        @Override
        void createResults(int size) {
            int newSize = this.initialOffset + size;
            int oldLength = this.results.length;
            if (newSize > oldLength) {
                long[] r = new long[newSize];
                System.arraycopy(this.results, 0, r, 0, oldLength);
                this.results = r;
            }
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJDAppendAllDriver
    extends FJSelectAllDriver {
        double[] results;

        FJDAppendAllDriver(AbstractParallelAnyArray pap, int initialOffset, double[] results) {
            super(pap, initialOffset);
            this.results = results;
        }

        @Override
        void createResults(int size) {
            int newSize = this.initialOffset + size;
            int oldLength = this.results.length;
            if (newSize > oldLength) {
                double[] r = new double[newSize];
                System.arraycopy(this.results, 0, r, 0, oldLength);
                this.results = r;
            }
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJOAppendAllDriver
    extends FJSelectAllDriver {
        Object[] results;

        FJOAppendAllDriver(AbstractParallelAnyArray pap, int initialOffset, Object[] results) {
            super(pap, 0);
            this.results = results;
        }

        @Override
        void createResults(int size) {
            int newSize = this.initialOffset + size;
            int oldLength = this.results.length;
            if (newSize > oldLength) {
                Class<?> elementType = this.results.getClass().getComponentType();
                Object[] r = (Object[])Array.newInstance(elementType, newSize);
                System.arraycopy(this.results, 0, r, 0, oldLength);
                this.results = r;
            }
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJLSelectAllDriver
    extends FJSelectAllDriver {
        long[] results;

        FJLSelectAllDriver(AbstractParallelAnyArray pap) {
            super(pap, 0);
        }

        @Override
        void createResults(int size) {
            this.results = new long[size];
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJDSelectAllDriver
    extends FJSelectAllDriver {
        double[] results;

        FJDSelectAllDriver(AbstractParallelAnyArray pap) {
            super(pap, 0);
        }

        @Override
        void createResults(int size) {
            this.results = new double[size];
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJOSelectAllDriver
    extends FJSelectAllDriver {
        final Class elementType;
        Object[] results;

        FJOSelectAllDriver(AbstractParallelAnyArray pap, Class elementType) {
            super(pap, 0);
            this.elementType = elementType;
        }

        @Override
        void createResults(int size) {
            this.results = (Object[])Array.newInstance(this.elementType, size);
        }

        @Override
        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.pap.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static abstract class FJSelectAllDriver
    extends RecursiveAction {
        final int[] indices;
        final AbstractParallelAnyArray pap;
        final int initialOffset;
        int phase;
        int resultSize;

        FJSelectAllDriver(AbstractParallelAnyArray pap, int initialOffset) {
            this.pap = pap;
            this.initialOffset = initialOffset;
            int n = pap.fence - pap.origin;
            this.indices = new int[n];
        }

        public final void compute() {
            FJSelectAll r = new FJSelectAll(this, this.pap.origin, this.pap.fence);
            r.offset = this.initialOffset;
            r.compute();
            this.resultSize = r.count;
            this.createResults(this.resultSize);
            this.phase = 1;
            r.compute();
        }

        abstract void createResults(int var1);

        abstract void leafPhase1(int var1, int var2, int var3);
    }

    static final class FJSelectAll
    extends RecursiveAction {
        final FJSelectAllDriver driver;
        FJSelectAll left;
        FJSelectAll right;
        final int lo;
        final int hi;
        int count;
        int offset;
        boolean isInternal;
        final int threshold;

        FJSelectAll(FJSelectAllDriver driver, int lo, int hi) {
            this.driver = driver;
            this.lo = lo;
            this.hi = hi;
            this.threshold = driver.pap.getThreshold();
        }

        public void compute() {
            int l = this.lo;
            int h = this.hi;
            FJSelectAllDriver d = this.driver;
            if (d.phase == 0) {
                AbstractParallelAnyArray p = d.pap;
                this.isInternal = h - l > this.threshold;
                if (this.isInternal) {
                    this.internalPhase0();
                } else {
                    this.count = p.leafIndexSelected(l, h, true, d.indices);
                }
            } else if (this.count != 0) {
                if (this.isInternal) {
                    this.internalPhase1();
                } else {
                    d.leafPhase1(l, l + this.count, this.offset);
                }
            }
        }

        void internalPhase0() {
            int rn;
            int mid = this.lo + this.hi >>> 1;
            FJSelectAll l = new FJSelectAll(this.driver, this.lo, mid);
            FJSelectAll r = new FJSelectAll(this.driver, mid, this.hi);
            r.fork();
            l.compute();
            if (r.tryUnfork()) {
                r.compute();
            } else {
                r.join();
            }
            int ln = l.count;
            if (ln != 0) {
                this.left = l;
            }
            if ((rn = r.count) != 0) {
                this.right = r;
            }
            this.count = ln + rn;
        }

        void internalPhase1() {
            int k = this.offset;
            if (this.left != null) {
                int ln = this.left.count;
                this.left.offset = k;
                this.left.reinitialize();
                if (this.right != null) {
                    this.right.offset = k + ln;
                    this.right.reinitialize();
                    this.right.fork();
                    this.left.compute();
                    if (this.right.tryUnfork()) {
                        this.right.compute();
                    } else {
                        this.right.join();
                    }
                } else {
                    this.left.compute();
                }
            } else if (this.right != null) {
                this.right.offset = k;
                this.right.compute();
            }
        }
    }

    static final class FJLIndexOf
    extends FJSearchBase {
        final long target;

        FJLIndexOf(AbstractParallelAnyArray pap, int lo, int hi, FJSearchBase next, AtomicInteger result, long target) {
            super(pap, lo, hi, next, result);
            this.target = target;
        }

        @Override
        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJLIndexOf(this.pap, l, h, r, this.result, this.target);
        }

        @Override
        void atLeaf(int l, int h) {
            long[] array = this.pap.lgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target == array[i]) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJDIndexOf
    extends FJSearchBase {
        final double target;

        FJDIndexOf(AbstractParallelAnyArray pap, int lo, int hi, FJSearchBase next, AtomicInteger result, double target) {
            super(pap, lo, hi, next, result);
            this.target = target;
        }

        @Override
        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJDIndexOf(this.pap, l, h, r, this.result, this.target);
        }

        @Override
        void atLeaf(int l, int h) {
            double[] array = this.pap.dgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target == array[i]) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJOIndexOf
    extends FJSearchBase {
        final Object target;

        FJOIndexOf(AbstractParallelAnyArray pap, int lo, int hi, FJSearchBase next, AtomicInteger result, Object target) {
            super(pap, lo, hi, next, result);
            this.target = target;
        }

        @Override
        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJOIndexOf(this.pap, l, h, r, this.result, this.target);
        }

        @Override
        void atLeaf(int l, int h) {
            Object[] array = this.pap.ogetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target.equals(array[i])) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJSelectAny
    extends FJSearchBase {
        FJSelectAny(AbstractParallelAnyArray pap, int lo, int hi, FJSearchBase next, AtomicInteger result) {
            super(pap, lo, hi, next, result);
        }

        @Override
        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJSelectAny(this.pap, l, h, r, this.result);
        }

        @Override
        void atLeaf(int l, int h) {
            for (int i = l; i < h; ++i) {
                if (this.pap.isSelected(i)) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static abstract class FJSearchBase
    extends RecursiveAction {
        final AbstractParallelAnyArray pap;
        final int lo;
        final int hi;
        final FJSearchBase next;
        final AtomicInteger result;

        FJSearchBase(AbstractParallelAnyArray pap, int lo, int hi, FJSearchBase next, AtomicInteger result) {
            this.pap = pap;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
            this.result = result;
        }

        public void compute() {
            if (this.result.get() >= 0) {
                return;
            }
            FJSearchBase r = null;
            int l = this.lo;
            int h = this.hi;
            int g = this.pap.getThreshold();
            while (h - l > g) {
                int rh = h;
                h = l + h >>> 1;
                r = this.newSubtask(h, rh, r);
                r.fork();
            }
            this.atLeaf(l, h);
            boolean stopping = false;
            while (r != null) {
                stopping |= this.result.get() >= 0;
                if (r.tryUnfork()) {
                    if (!stopping) {
                        r.atLeaf(r.lo, r.hi);
                    }
                } else if (stopping) {
                    r.cancel(false);
                } else {
                    r.join();
                }
                r = r.next;
            }
        }

        abstract FJSearchBase newSubtask(int var1, int var2, FJSearchBase var3);

        abstract void atLeaf(int var1, int var2);
    }

    static final class FJCountSelected
    extends FJBase {
        int count;

        FJCountSelected(AbstractParallelAnyArray pap, int lo, int hi, FJBase next) {
            super(pap, lo, hi, next);
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJCountSelected(this.pap, l, h, r);
        }

        @Override
        void onReduce(FJBase right) {
            this.count += ((FJCountSelected)right).count;
        }

        @Override
        void atLeaf(int l, int h) {
            int n = 0;
            for (int i = l; i < h; ++i) {
                if (!this.pap.isSelected(i)) continue;
                ++n;
            }
            this.count = n;
        }
    }

    static final class FJLStats
    extends FJBase
    implements ParallelLongArray.SummaryStatistics {
        final Ops.LongComparator comparator;
        int size;
        long min;
        long max;
        long sum;
        int indexOfMin;
        int indexOfMax;

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long min() {
            return this.min;
        }

        @Override
        public long max() {
            return this.max;
        }

        @Override
        public long sum() {
            return this.sum;
        }

        @Override
        public double average() {
            return (double)this.sum / (double)this.size;
        }

        @Override
        public int indexOfMin() {
            return this.indexOfMin;
        }

        @Override
        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJLStats(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.LongComparator comparator) {
            super(pap, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLStats(this.pap, l, h, r, this.comparator);
        }

        @Override
        void onReduce(FJBase right) {
            FJLStats r = (FJLStats)right;
            this.size += r.size;
            this.sum += r.sum;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, long x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, long x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        @Override
        void atLeaf(int l, int h) {
            if (this.pap.hasFilter()) {
                this.filteredAtLeaf(l, h);
            } else {
                this.size = h - l;
                for (int i = l; i < h; ++i) {
                    long x = this.pap.lget(i);
                    this.sum += x;
                    this.updateMin(i, x);
                    this.updateMax(i, x);
                }
            }
        }

        void filteredAtLeaf(int l, int h) {
            for (int i = l; i < h; ++i) {
                if (!this.pap.isSelected(i)) continue;
                long x = this.pap.lget(i);
                ++this.size;
                this.sum += x;
                this.updateMin(i, x);
                this.updateMax(i, x);
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ") sum: " + this.sum;
        }
    }

    static final class FJDStats
    extends FJBase
    implements ParallelDoubleArray.SummaryStatistics {
        final Ops.DoubleComparator comparator;
        int size;
        double min;
        double max;
        double sum;
        int indexOfMin;
        int indexOfMax;

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double sum() {
            return this.sum;
        }

        @Override
        public double average() {
            return this.sum / (double)this.size;
        }

        @Override
        public int indexOfMin() {
            return this.indexOfMin;
        }

        @Override
        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJDStats(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.DoubleComparator comparator) {
            super(pap, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDStats(this.pap, l, h, r, this.comparator);
        }

        @Override
        void onReduce(FJBase right) {
            FJDStats r = (FJDStats)right;
            this.size += r.size;
            this.sum += r.sum;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, double x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, double x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        @Override
        void atLeaf(int l, int h) {
            if (this.pap.hasFilter()) {
                this.filteredAtLeaf(l, h);
            } else {
                this.size = h - l;
                for (int i = l; i < h; ++i) {
                    double x = this.pap.dget(i);
                    this.sum += x;
                    this.updateMin(i, x);
                    this.updateMax(i, x);
                }
            }
        }

        void filteredAtLeaf(int l, int h) {
            for (int i = l; i < h; ++i) {
                if (!this.pap.isSelected(i)) continue;
                double x = this.pap.dget(i);
                ++this.size;
                this.sum += x;
                this.updateMin(i, x);
                this.updateMax(i, x);
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ") sum: " + this.sum;
        }
    }

    static final class FJOStats
    extends FJBase
    implements ParallelArray.SummaryStatistics {
        final Comparator comparator;
        int size;
        Object min;
        Object max;
        int indexOfMin;
        int indexOfMax;

        @Override
        public int size() {
            return this.size;
        }

        public Object min() {
            return this.min;
        }

        public Object max() {
            return this.max;
        }

        @Override
        public int indexOfMin() {
            return this.indexOfMin;
        }

        @Override
        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJOStats(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Comparator comparator) {
            super(pap, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOStats(this.pap, l, h, r, this.comparator);
        }

        @Override
        void onReduce(FJBase right) {
            FJOStats r = (FJOStats)right;
            this.size += r.size;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, Object x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, Object x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        @Override
        void atLeaf(int l, int h) {
            if (this.pap.hasFilter()) {
                this.filteredAtLeaf(l, h);
            } else {
                this.size = h - l;
                for (int i = l; i < h; ++i) {
                    Object x = this.pap.oget(i);
                    this.updateMin(i, x);
                    this.updateMax(i, x);
                }
            }
        }

        void filteredAtLeaf(int l, int h) {
            for (int i = l; i < h; ++i) {
                if (!this.pap.isSelected(i)) continue;
                Object x = this.pap.oget(i);
                ++this.size;
                this.updateMin(i, x);
                this.updateMax(i, x);
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ")";
        }
    }

    static final class FJLPACombineInPlace
    extends FJBase {
        final ParallelLongArrayWithLongMapping other;
        final int otherOffset;
        final Ops.BinaryLongOp combiner;

        FJLPACombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, ParallelLongArrayWithLongMapping other, int otherOffset, Ops.BinaryLongOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLPACombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJDPACombineInPlace
    extends FJBase {
        final ParallelDoubleArrayWithDoubleMapping other;
        final int otherOffset;
        final Ops.BinaryDoubleOp combiner;

        FJDPACombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, ParallelDoubleArrayWithDoubleMapping other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDPACombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJOPACombineInPlace
    extends FJBase {
        final ParallelArrayWithMapping other;
        final int otherOffset;
        final Ops.BinaryOp combiner;

        FJOPACombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, ParallelArrayWithMapping other, int otherOffset, Ops.BinaryOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOPACombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJLCombineInPlace
    extends FJBase {
        final long[] other;
        final int otherOffset;
        final Ops.BinaryLongOp combiner;

        FJLCombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, long[] other, int otherOffset, Ops.BinaryLongOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLCombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJDCombineInPlace
    extends FJBase {
        final double[] other;
        final int otherOffset;
        final Ops.BinaryDoubleOp combiner;

        FJDCombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, double[] other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDCombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJOCombineInPlace
    extends FJBase {
        final Object[] other;
        final int otherOffset;
        final Ops.BinaryOp combiner;

        FJOCombineInPlace(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Object[] other, int otherOffset, Ops.BinaryOp combiner) {
            super(pap, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOCombineInPlace(this.pap, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJLFill
    extends FJBase {
        final long value;

        FJLFill(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, long value) {
            super(pap, lo, hi, next);
            this.value = value;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLFill(this.pap, l, h, r, this.value);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafFill(l, h, this.value);
        }
    }

    static final class FJDFill
    extends FJBase {
        final double value;

        FJDFill(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, double value) {
            super(pap, lo, hi, next);
            this.value = value;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDFill(this.pap, l, h, r, this.value);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafFill(l, h, this.value);
        }
    }

    static final class FJOFill
    extends FJBase {
        final Object value;

        FJOFill(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Object value) {
            super(pap, lo, hi, next);
            this.value = value;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOFill(this.pap, l, h, r, this.value);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafFill(l, h, this.value);
        }
    }

    static final class FJLGenerate
    extends FJBase {
        final Ops.LongGenerator generator;

        FJLGenerate(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.LongGenerator generator) {
            super(pap, lo, hi, next);
            this.generator = generator;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLGenerate(this.pap, l, h, r, this.generator);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJDGenerate
    extends FJBase {
        final Ops.DoubleGenerator generator;

        FJDGenerate(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.DoubleGenerator generator) {
            super(pap, lo, hi, next);
            this.generator = generator;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDGenerate(this.pap, l, h, r, this.generator);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJOGenerate
    extends FJBase {
        final Ops.Generator generator;

        FJOGenerate(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.Generator generator) {
            super(pap, lo, hi, next);
            this.generator = generator;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOGenerate(this.pap, l, h, r, this.generator);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJLBinaryIndexMap
    extends FJBase {
        final Ops.IntAndLongToLong op;

        FJLBinaryIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntAndLongToLong op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLBinaryIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafBinaryIndexMap(l, h, this.op);
        }
    }

    static final class FJDBinaryIndexMap
    extends FJBase {
        final Ops.IntAndDoubleToDouble op;

        FJDBinaryIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntAndDoubleToDouble op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDBinaryIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafBinaryIndexMap(l, h, this.op);
        }
    }

    static final class FJOBinaryIndexMap
    extends FJBase {
        final Ops.IntAndObjectToObject op;

        FJOBinaryIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntAndObjectToObject op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOBinaryIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafBinaryIndexMap(l, h, this.op);
        }
    }

    static final class FJLIndexMap
    extends FJBase {
        final Ops.IntToLong op;

        FJLIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntToLong op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafIndexMap(l, h, this.op);
        }
    }

    static final class FJDIndexMap
    extends FJBase {
        final Ops.IntToDouble op;

        FJDIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntToDouble op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafIndexMap(l, h, this.op);
        }
    }

    static final class FJOIndexMap
    extends FJBase {
        final Ops.IntToObject op;

        FJOIndexMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.IntToObject op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOIndexMap(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafIndexMap(l, h, this.op);
        }
    }

    static final class FJLTransform
    extends FJBase {
        final Ops.LongOp op;

        FJLTransform(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.LongOp op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLTransform(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransform(l, h, this.op);
        }
    }

    static final class FJDTransform
    extends FJBase {
        final Ops.DoubleOp op;

        FJDTransform(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.DoubleOp op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDTransform(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransform(l, h, this.op);
        }
    }

    static final class FJOTransform
    extends FJBase {
        final Ops.Op op;

        FJOTransform(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.Op op) {
            super(pap, lo, hi, next);
            this.op = op;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOTransform(this.pap, l, h, r, this.op);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransform(l, h, this.op);
        }
    }

    static final class FJLMap
    extends FJBase {
        final long[] dest;
        final int offset;

        FJLMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, long[] dest, int offset) {
            super(pap, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLMap(this.pap, l, h, r, this.dest, this.offset);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransfer(l, h, this.dest, l + this.offset);
        }
    }

    static final class FJDMap
    extends FJBase {
        final double[] dest;
        final int offset;

        FJDMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, double[] dest, int offset) {
            super(pap, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDMap(this.pap, l, h, r, this.dest, this.offset);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransfer(l, h, this.dest, l + this.offset);
        }
    }

    static final class FJOMap
    extends FJBase {
        final Object[] dest;
        final int offset;

        FJOMap(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Object[] dest, int offset) {
            super(pap, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOMap(this.pap, l, h, r, this.dest, this.offset);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafTransfer(l, h, this.dest, l + this.offset);
        }
    }

    static final class FJLReduce
    extends FJBase {
        final Ops.LongReducer reducer;
        long result;

        FJLReduce(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.LongReducer reducer, long base) {
            super(pap, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLReduce(this.pap, l, h, r, this.reducer, this.result);
        }

        @Override
        void atLeaf(int l, int h) {
            this.result = this.pap.leafReduce(l, h, this.reducer, this.result);
        }

        @Override
        void onReduce(FJBase right) {
            this.result = this.reducer.op(this.result, ((FJLReduce)right).result);
        }
    }

    static final class FJDReduce
    extends FJBase {
        final Ops.DoubleReducer reducer;
        double result;

        FJDReduce(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.DoubleReducer reducer, double base) {
            super(pap, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDReduce(this.pap, l, h, r, this.reducer, this.result);
        }

        @Override
        void atLeaf(int l, int h) {
            this.result = this.pap.leafReduce(l, h, this.reducer, this.result);
        }

        @Override
        void onReduce(FJBase right) {
            this.result = this.reducer.op(this.result, ((FJDReduce)right).result);
        }
    }

    static final class FJOReduce
    extends FJBase {
        final Ops.Reducer reducer;
        Object result;

        FJOReduce(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.Reducer reducer, Object base) {
            super(pap, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOReduce(this.pap, l, h, r, this.reducer, this.result);
        }

        @Override
        void atLeaf(int l, int h) {
            this.result = this.pap.leafReduce(l, h, this.reducer, this.result);
        }

        @Override
        void onReduce(FJBase right) {
            this.result = this.reducer.op(this.result, ((FJOReduce)right).result);
        }
    }

    static final class FJLApply
    extends FJBase {
        final Ops.LongProcedure procedure;

        FJLApply(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.LongProcedure procedure) {
            super(pap, lo, hi, next);
            this.procedure = procedure;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLApply(this.pap, l, h, r, this.procedure);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafApply(l, h, this.procedure);
        }
    }

    static final class FJDApply
    extends FJBase {
        final Ops.DoubleProcedure procedure;

        FJDApply(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.DoubleProcedure procedure) {
            super(pap, lo, hi, next);
            this.procedure = procedure;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDApply(this.pap, l, h, r, this.procedure);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafApply(l, h, this.procedure);
        }
    }

    static final class FJOApply
    extends FJBase {
        final Ops.Procedure procedure;

        FJOApply(AbstractParallelAnyArray pap, int lo, int hi, FJBase next, Ops.Procedure procedure) {
            super(pap, lo, hi, next);
            this.procedure = procedure;
        }

        @Override
        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJOApply(this.pap, l, h, r, this.procedure);
        }

        @Override
        void atLeaf(int l, int h) {
            this.pap.leafApply(l, h, this.procedure);
        }
    }

    static abstract class FJBase
    extends RecursiveAction {
        final AbstractParallelAnyArray pap;
        final int lo;
        final int hi;
        final FJBase next;

        FJBase(AbstractParallelAnyArray pap, int lo, int hi, FJBase next) {
            this.pap = pap;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
        }

        public final void compute() {
            int h = this.hi;
            int l = this.lo;
            int g = this.pap.getThreshold();
            if (h - l > g) {
                this.internalCompute(l, h, g);
            } else {
                this.atLeaf(l, h);
            }
        }

        final void internalCompute(int l, int h, int g) {
            FJBase r = null;
            do {
                int rh = h;
                h = l + h >>> 1;
                r = this.newSubtask(h, rh, r);
                r.fork();
            } while (h - l > g);
            this.atLeaf(l, h);
            do {
                if (r.tryUnfork()) {
                    r.atLeaf(r.lo, r.hi);
                } else {
                    r.join();
                }
                this.onReduce(r);
            } while ((r = r.next) != null);
        }

        abstract void atLeaf(int var1, int var2);

        void onReduce(FJBase right) {
        }

        abstract FJBase newSubtask(int var1, int var2, FJBase var3);
    }
}

