/*
 * Decompiled with CFR 0.152.
 */
package extra166y;

import extra166y.AbstractParallelAnyArray;
import extra166y.Ops;
import extra166y.PAS;
import extra166y.ParallelArrayWithMapping;
import extra166y.ParallelDoubleArrayWithBounds;
import extra166y.ParallelDoubleArrayWithDoubleMapping;
import extra166y.ParallelDoubleArrayWithFilter;
import extra166y.ParallelDoubleArrayWithLongMapping;
import extra166y.ParallelDoubleArrayWithMapping;
import extra166y.ParallelLongArrayWithLongMapping;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;

public class ParallelDoubleArray
extends AbstractParallelAnyArray.DUPap {
    AsList listView;

    public static ForkJoinPool defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelDoubleArray(ForkJoinPool executor, double[] array, int limit) {
        super(executor, 0, limit, array);
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
    }

    ParallelDoubleArray(ForkJoinPool executor, double[] array) {
        super(executor, 0, array.length, array);
    }

    public static ParallelDoubleArray create(int size, ForkJoinPool executor) {
        double[] array = new double[size];
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createUsingHandoff(double[] handoff, ForkJoinPool executor) {
        return new ParallelDoubleArray(executor, handoff, handoff.length);
    }

    public static ParallelDoubleArray createFromCopy(double[] source, ForkJoinPool executor) {
        int size = source.length;
        double[] array = new double[size];
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createFromCopy(int size, double[] source, ForkJoinPool executor) {
        double[] array = new double[size];
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createEmpty(int size, ForkJoinPool executor) {
        double[] array = new double[size];
        return new ParallelDoubleArray(executor, array, 0);
    }

    public ForkJoinPool getExecutor() {
        return this.ex;
    }

    @Override
    public void apply(Ops.DoubleProcedure procedure) {
        super.apply(procedure);
    }

    @Override
    public double reduce(Ops.DoubleReducer reducer, double base) {
        return super.reduce(reducer, base);
    }

    @Override
    public ParallelDoubleArray all() {
        return super.all();
    }

    @Override
    public ParallelDoubleArray replaceWithMapping(Ops.DoubleOp op) {
        super.replaceWithMapping(op);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithMappedIndex(Ops.IntToDouble op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithMappedIndex(Ops.IntAndDoubleToDouble op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithGeneratedValue(Ops.DoubleGenerator generator) {
        super.replaceWithGeneratedValue(generator);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithValue(double value) {
        super.replaceWithValue(value);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithMapping(Ops.BinaryDoubleOp combiner, ParallelDoubleArrayWithDoubleMapping other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public ParallelDoubleArray replaceWithMapping(Ops.BinaryDoubleOp combiner, double[] other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public int indexOf(double target) {
        return super.indexOf(target);
    }

    @Override
    public int binarySearch(double target) {
        return super.binarySearch(target);
    }

    @Override
    public int binarySearch(double target, Ops.DoubleComparator comparator) {
        return super.binarySearch(target, comparator);
    }

    @Override
    public SummaryStatistics summary(Ops.DoubleComparator comparator) {
        return super.summary(comparator);
    }

    @Override
    public SummaryStatistics summary() {
        return super.summary();
    }

    @Override
    public double min(Ops.DoubleComparator comparator) {
        return super.min(comparator);
    }

    @Override
    public double min() {
        return super.min();
    }

    @Override
    public double max(Ops.DoubleComparator comparator) {
        return super.max(comparator);
    }

    @Override
    public double max() {
        return super.max();
    }

    @Override
    public ParallelDoubleArray cumulate(Ops.DoubleReducer reducer, double base) {
        super.cumulate(reducer, base);
        return this;
    }

    @Override
    public double precumulate(Ops.DoubleReducer reducer, double base) {
        return super.precumulate(reducer, base);
    }

    @Override
    public ParallelDoubleArray sort(Ops.DoubleComparator comparator) {
        super.sort(comparator);
        return this;
    }

    @Override
    public ParallelDoubleArray sort() {
        super.sort();
        return this;
    }

    public ParallelDoubleArray removeConsecutiveDuplicates() {
        int k = 0;
        int n = this.fence;
        if (k < n) {
            double[] arr = this.array;
            double last = arr[k++];
            for (int i = k; i < n; ++i) {
                double x = arr[i];
                if (last == x) continue;
                arr[k++] = last = x;
            }
            this.removeSlotsAt(k, n);
        }
        return this;
    }

    public ParallelDoubleArray addAll(double[] other) {
        int csize = other.length;
        int end = this.fence;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
        return this;
    }

    public ParallelDoubleArray addAll(ParallelDoubleArrayWithDoubleMapping other) {
        int end = this.fence;
        if (other.hasFilter()) {
            PAS.FJDAppendAllDriver r = new PAS.FJDAppendAllDriver(other, end, this.array);
            this.ex.invoke((ForkJoinTask)r);
            this.array = r.results;
            this.fence = end + r.resultSize;
        } else {
            int csize = other.size();
            this.insertSlotsAt(end, csize);
            if (other.hasMap()) {
                this.ex.invoke((ForkJoinTask)new PAS.FJDMap(other, other.origin, other.fence, null, this.array, end - other.origin));
            } else {
                System.arraycopy(other.array, 0, this.array, end, csize);
            }
        }
        return this;
    }

    @Override
    public ParallelDoubleArray allUniqueElements() {
        return super.allUniqueElements();
    }

    public ParallelDoubleArray removeAll(Ops.DoublePredicate selector) {
        AbstractParallelAnyArray.DFPap v = new AbstractParallelAnyArray.DFPap(this.ex, 0, this.fence, this.array, selector);
        PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(v, 0, this.fence);
        this.ex.invoke((ForkJoinTask)f);
        this.removeSlotsAt(f.offset, this.fence);
        return this;
    }

    @Override
    public boolean hasAllEqualElements(ParallelDoubleArrayWithDoubleMapping other) {
        return super.hasAllEqualElements(other);
    }

    @Override
    public double sum() {
        return super.sum();
    }

    @Override
    public ParallelDoubleArray cumulateSum() {
        super.cumulateSum();
        return this;
    }

    @Override
    public double precumulateSum() {
        return super.precumulateSum();
    }

    @Override
    public ParallelDoubleArrayWithBounds withBounds(int firstIndex, int upperBound) {
        return super.withBounds(firstIndex, upperBound);
    }

    @Override
    public ParallelDoubleArrayWithFilter withFilter(Ops.DoublePredicate selector) {
        return super.withFilter(selector);
    }

    @Override
    public ParallelDoubleArrayWithFilter withFilter(Ops.BinaryDoublePredicate selector, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withFilter(selector, other);
    }

    @Override
    public ParallelDoubleArrayWithFilter withIndexedFilter(Ops.IntAndDoublePredicate selector) {
        return super.withIndexedFilter(selector);
    }

    @Override
    public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
        return super.withMapping(op);
    }

    @Override
    public <V, W, X> ParallelDoubleArrayWithMapping<W> withMapping(Ops.DoubleAndObjectToObject<? super V, ? extends W> combiner, ParallelArrayWithMapping<X, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.DoubleAndDoubleToObject<? extends V> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.DoubleAndLongToObject<? extends V> combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V, W> ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleAndObjectToDouble<? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.BinaryDoubleOp combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleAndLongToDouble combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V, W> ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleAndObjectToLong<? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleAndDoubleToLong combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleAndLongToLong combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    public <U> ParallelDoubleArrayWithMapping<U> withIndexedMapping(Ops.IntAndDoubleToObject<? extends U> mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
        return super.withIndexedMapping(mapper);
    }

    public Iterator<Double> iterator() {
        return new ParallelDoubleArrayIterator(this.array, this.fence);
    }

    public List<Double> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    @Override
    public int size() {
        return this.fence;
    }

    public double[] getArray() {
        return this.array;
    }

    public double get(int i) {
        return this.array[i];
    }

    public void set(int i, double x) {
        this.array[i] = x;
    }

    public String toString() {
        return this.asList().toString();
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.fence = newLimit;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            double[] a = new double[newCap];
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, double e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(double e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.fence + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.fence) {
            System.arraycopy(this.array, index, this.array, index + len, this.fence - index);
        }
        this.fence = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.fence - index - 1);
        --this.fence;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.fence;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.fence = newSize = size - (toIndex - fromIndex);
        }
    }

    final int seqIndexOf(double target) {
        double[] arr = this.array;
        int end = this.fence;
        for (int i = 0; i < end; ++i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final int seqLastIndexOf(double target) {
        double[] arr = this.array;
        for (int i = this.fence - 1; i >= 0; --i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final class AsList
    extends AbstractList<Double>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public Double get(int i) {
            if (i >= ParallelDoubleArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelDoubleArray.this.array[i];
        }

        @Override
        public Double set(int i, Double x) {
            if (i >= ParallelDoubleArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            double[] arr = ParallelDoubleArray.this.array;
            Double t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelDoubleArray.this.fence == 0;
        }

        @Override
        public int size() {
            return ParallelDoubleArray.this.fence;
        }

        @Override
        public Iterator<Double> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Double> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Double> listIterator(int index) {
            if (index < 0 || index > ParallelDoubleArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(Double e) {
            ParallelDoubleArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, Double e) {
            if (index < 0 || index > ParallelDoubleArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            ParallelDoubleArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelDoubleArray.this.fence;
            ParallelDoubleArray.this.setLimit(hi + csize);
            double[] arr = ParallelDoubleArray.this.array;
            for (Double d : c) {
                arr[hi++] = d;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            if (index < 0 || index > ParallelDoubleArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelDoubleArray.this.insertSlotsAt(index, csize);
            double[] arr = ParallelDoubleArray.this.array;
            for (Double d : c) {
                arr[index++] = d;
            }
            return true;
        }

        @Override
        public void clear() {
            ParallelDoubleArray.this.fence = 0;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Double)) {
                return false;
            }
            int idx = ParallelDoubleArray.this.seqIndexOf((Double)o);
            if (idx < 0) {
                return false;
            }
            ParallelDoubleArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public Double remove(int index) {
            Double oldValue = this.get(index);
            ParallelDoubleArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            ParallelDoubleArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Double)) {
                return false;
            }
            return ParallelDoubleArray.this.seqIndexOf((Double)o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof Double)) {
                return -1;
            }
            return ParallelDoubleArray.this.seqIndexOf((Double)o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof Double)) {
                return -1;
            }
            return ParallelDoubleArray.this.seqLastIndexOf((Double)o);
        }
    }

    final class ListIter
    implements ListIterator<Double> {
        int cursor;
        int lastRet;
        double[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelDoubleArray.this.array;
            this.hi = ParallelDoubleArray.this.fence;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Double next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            double next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelDoubleArray.this.removeSlotAt(k);
            this.hi = ParallelDoubleArray.this.fence;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Double previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            double previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Double e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(Double e) {
            int i = this.cursor;
            ParallelDoubleArray.this.insertElementAt(i, e);
            this.arr = ParallelDoubleArray.this.array;
            this.hi = ParallelDoubleArray.this.fence;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    static final class ParallelDoubleArrayIterator
    implements Iterator<Double> {
        int cursor;
        final double[] arr;
        final int hi;

        ParallelDoubleArrayIterator(double[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Double next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SummaryStatistics {
        public int size();

        public double min();

        public double max();

        public int indexOfMin();

        public int indexOfMax();

        public double sum();

        public double average();
    }
}

